/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IChainingModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.model.IPropertyReflectionAwareModel;
import org.apache.wicket.util.lang.PropertyResolver;
import org.apache.wicket.util.lang.PropertyResolverConverter;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyModel<T>
implements IChainingModel<T>,
IObjectClassAwareModel<T>,
IPropertyReflectionAwareModel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPropertyModel.class);
    private static final long serialVersionUID = 1L;
    private Object target;

    public AbstractPropertyModel(Object modelObject) {
        if (modelObject == null) {
            throw new IllegalArgumentException("Parameter modelObject cannot be null");
        }
        if (modelObject instanceof Session) {
            logger.warn("It is not a good idea to reference the Session instance in models directly as it may lead to serialization problems. If you need to access a property of the session via the model use the page instance as the model object and 'session.attribute' as the path.");
        }
        this.target = modelObject;
    }

    @Override
    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    @Override
    public IModel<?> getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    @Override
    public T getObject() {
        String expression = this.propertyExpression();
        if (Strings.isEmpty(expression)) {
            return (T)this.getTarget();
        }
        Object target = this.getTarget();
        if (target != null) {
            return (T)PropertyResolver.getValue(expression, target);
        }
        return null;
    }

    public final String getPropertyExpression() {
        return this.propertyExpression();
    }

    @Override
    public void setChainedModel(IModel<?> model) {
        this.target = model;
    }

    @Override
    public void setObject(T object) {
        String expression = this.propertyExpression();
        if (Strings.isEmpty(expression)) {
            if (this.target instanceof IModel) {
                ((IModel)this.target).setObject(object);
            } else {
                this.target = object;
            }
        } else {
            PropertyResolverConverter prc = null;
            prc = new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale());
            PropertyResolver.setValue(expression, this.getTarget(), object, prc);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Model:classname=[");
        sb.append(this.getClass().getName()).append("]");
        sb.append(":nestedModel=[").append(this.target).append("]");
        return sb.toString();
    }

    public final Object getTarget() {
        Object tmp;
        Object object = this.target;
        while (object instanceof IModel && (tmp = ((IModel)object).getObject()) != object) {
            object = tmp;
        }
        return object;
    }

    @Override
    public Class<T> getObjectClass() {
        block8: {
            String expression = this.propertyExpression();
            if (Strings.isEmpty(expression)) {
                Object target = this.getTarget();
                return target != null ? target.getClass() : null;
            }
            Object target = this.getTarget();
            if (target != null) {
                try {
                    return PropertyResolver.getPropertyClass(expression, target);
                }
                catch (Exception e) {
                    break block8;
                }
            }
            if (this.target instanceof IObjectClassAwareModel) {
                try {
                    Class targetClass = ((IObjectClassAwareModel)this.target).getObjectClass();
                    if (targetClass != null) {
                        return PropertyResolver.getPropertyClass(expression, targetClass);
                    }
                }
                catch (WicketRuntimeException wicketRuntimeException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Field getPropertyField() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty(expression) && (target = this.getTarget()) != null) {
            try {
                return PropertyResolver.getPropertyField(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Method getPropertyGetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty(expression) && (target = this.getTarget()) != null) {
            try {
                return PropertyResolver.getPropertyGetter(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Method getPropertySetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty(expression) && (target = this.getTarget()) != null) {
            try {
                return PropertyResolver.getPropertySetter(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract String propertyExpression();

    @Deprecated
    protected final Object onGetObject(Component component) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected final void onSetObject(Component component, Object object) {
        throw new UnsupportedOperationException();
    }
}

