/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Stack;
import org.apache.wicket.Session;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.string.Strings;

public final class InlineEnclosureHandler
extends AbstractMarkupFilter {
    private static final String INLINE_ENCLOSURE_ID_PREFIX = "inlineEnclosure-";
    private static final String INLINE_ENCLOSURE_ATTRIBUTE_NAME = "wicket:enclosure";
    private Stack<ComponentTag> enclosures;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MarkupElement nextTag() throws ParseException {
        ComponentTag tag = this.nextComponentTag();
        if (tag == null || tag instanceof WicketTag) {
            return tag;
        }
        String enclosureAttr = InlineEnclosureHandler.getInlineEnclosureAttribute(tag);
        if (enclosureAttr != null) {
            if (!tag.isOpen()) throw new ParseException("Open-close tags don't make sense for InlineEnclosure. Tag:" + tag.toString(), tag.getPos());
            String htmlId = tag.getAttribute("id");
            if (tag.getId() != null && !Strings.isEmpty(htmlId) && !htmlId.equals(tag.getId())) {
                throw new ParseException("Make sure the 'id' and 'wicket:id' should be the same if both are used. Tag:" + tag.toString(), tag.getPos());
            }
            if (Strings.isEmpty(tag.getId())) {
                if (Strings.isEmpty(htmlId)) {
                    String id = INLINE_ENCLOSURE_ID_PREFIX + Session.get().nextSequenceValue();
                    tag.setId(id);
                } else {
                    tag.setId(htmlId);
                }
                tag.setAutoComponentTag(true);
                tag.setModified(true);
            }
            tag.getAttributes().put("id", tag.getId());
            if (this.enclosures == null) {
                this.enclosures = new Stack();
            }
            this.enclosures.push(tag);
            return tag;
        } else {
            if (this.enclosures == null || this.enclosures.size() <= 0) return tag;
            if (tag.isOpen() && tag.getId() != null && !(tag instanceof WicketTag) && !tag.isAutoComponentTag()) {
                for (int i = this.enclosures.size() - 1; i >= 0; --i) {
                    ComponentTag lastEnclosure = (ComponentTag)this.enclosures.get(i);
                    String attr = InlineEnclosureHandler.getInlineEnclosureAttribute(lastEnclosure);
                    if (!Strings.isEmpty(attr)) continue;
                    lastEnclosure.getAttributes().put(INLINE_ENCLOSURE_ATTRIBUTE_NAME, tag.getId());
                    lastEnclosure.setModified(true);
                }
                return tag;
            } else {
                ComponentTag lastEnclosure;
                String attr;
                if (!tag.isClose() || !tag.closes(this.enclosures.peek()) || !Strings.isEmpty(attr = InlineEnclosureHandler.getInlineEnclosureAttribute(lastEnclosure = this.enclosures.pop()))) return tag;
                throw new ParseException("Did not find any child for InlineEnclosure. Tag:" + lastEnclosure.toString(), tag.getPos());
            }
        }
    }

    public static final String getInlineEnclosureAttribute(ComponentTag tag) {
        return tag.getAttributes().getString(INLINE_ENCLOSURE_ATTRIBUTE_NAME);
    }
}

