/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Stack;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;

public final class EnclosureHandler
extends AbstractMarkupFilter {
    public static final String CHILD_ATTRIBUTE = "child";
    private Stack<ComponentTag> stack;
    private String childId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MarkupElement nextTag() throws ParseException {
        boolean isEnclosureTag;
        ComponentTag tag = this.nextComponentTag();
        if (tag == null) {
            return tag;
        }
        boolean isWicketTag = tag instanceof WicketTag;
        boolean bl = isEnclosureTag = isWicketTag && ((WicketTag)tag).isEnclosureTag();
        if (isEnclosureTag) {
            if (tag.isOpen()) {
                if (this.stack == null) {
                    this.stack = new Stack();
                }
                this.stack.push(tag);
                return tag;
            } else {
                if (!tag.isClose()) throw new ParseException("Open-close tag not allowed for Enclosure: " + tag.toString(), tag.getPos());
                if (this.stack == null) {
                    throw new ParseException("Missing open tag for Enclosure: " + tag.toString(), tag.getPos());
                }
                ComponentTag lastEnclosure = this.stack.pop();
                if (this.childId != null) {
                    lastEnclosure.put(CHILD_ATTRIBUTE, this.childId);
                    lastEnclosure.setModified(true);
                    this.childId = null;
                }
                if (this.stack.size() != 0) return tag;
                this.stack = null;
            }
            return tag;
        } else {
            ComponentTag lastEnclosure;
            if (tag.getId() == null || isWicketTag || this.stack == null || (lastEnclosure = (ComponentTag)this.stack.lastElement()).getString(CHILD_ATTRIBUTE) != null) return tag;
            if (this.childId != null) {
                throw new ParseException("Use <wicket:enclosure child='xxx'> to name the child component", tag.getPos());
            }
            this.childId = tag.getId();
        }
        return tag;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("enclosure");
    }
}

