/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.loader;

import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MergedMarkup;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.loader.IMarkupLoader;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InheritedMarkupMarkupLoader
implements IMarkupLoader {
    private static final Logger log = LoggerFactory.getLogger(InheritedMarkupMarkupLoader.class);

    public final Markup loadMarkup(MarkupContainer container, MarkupResourceStream markupResourceStream, IMarkupLoader baseLoader, boolean enforceReload) throws IOException, ResourceStreamNotFoundException {
        Markup markup = baseLoader.loadMarkup(container, markupResourceStream, null, enforceReload);
        markup = this.checkForMarkupInheritance(container, markup, enforceReload);
        return markup;
    }

    private Markup checkForMarkupInheritance(MarkupContainer container, Markup markup, boolean enforceReload) {
        int extendIndex = this.requiresBaseMarkup(markup);
        if (extendIndex == -1) {
            return markup;
        }
        Markup baseMarkup = this.getBaseMarkup(container, markup, enforceReload);
        if (baseMarkup == Markup.NO_MARKUP) {
            throw new MarkupNotFoundException("Base markup of inherited markup not found. Component class: " + markup.getMarkupResourceData().getResource().getContainerInfo().getContainerClass().getName() + ". Enable debug messages for org.apache.wicket.util.resource.locator.ResourceStreamLocator to get a list of all filenames tried.");
        }
        return new MergedMarkup(markup, baseMarkup, extendIndex);
    }

    private Markup getBaseMarkup(MarkupContainer container, Markup markup, boolean enforceReload) {
        Markup baseMarkup = Application.get().getMarkupSettings().getMarkupCache().getMarkup(container, markup.getMarkupResourceData().getResource().getMarkupClass().getSuperclass(), enforceReload);
        return baseMarkup;
    }

    private int requiresBaseMarkup(Markup markup) {
        for (int i = 0; i < markup.size(); ++i) {
            WicketTag wtag;
            MarkupElement elem = markup.get(i);
            if (!(elem instanceof WicketTag) || !(wtag = (WicketTag)elem).isExtendTag()) continue;
            return i;
        }
        return -1;
    }
}

