/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupSettings
implements IClusterable {
    private static final Logger log = LoggerFactory.getLogger(PopupSettings.class);
    private static final long serialVersionUID = 1L;
    public static final int LOCATION_BAR = 1;
    public static final int MENU_BAR = 2;
    public static final int RESIZABLE = 4;
    public static final int SCROLLBARS = 8;
    public static final int STATUS_BAR = 16;
    public static final int TOOL_BAR = 32;
    private int displayFlags;
    private int height = -1;
    private int left = -1;
    private String target = "href";
    private int top = -1;
    private int width = -1;
    private String windowName = null;
    private String pageMapName;

    public PopupSettings() {
    }

    public PopupSettings(int displayFlags) {
        this((String)null, displayFlags);
    }

    @Deprecated
    public PopupSettings(IPageMap pagemap) {
        this(pagemap.getName(), 0);
    }

    public PopupSettings(String pageMapName) {
        this(pageMapName, 0);
    }

    @Deprecated
    public PopupSettings(IPageMap pageMapName, int displayFlags) {
        this(pageMapName.getName(), displayFlags);
    }

    public PopupSettings(String pageMapName, int displayFlags) {
        this.displayFlags = displayFlags;
        this.windowName = this.pageMapName = pageMapName;
    }

    public String getPopupJavaScript() {
        String windowTitle = this.windowName;
        windowTitle = windowTitle == null ? "" : windowTitle.replaceAll("\\W", "_");
        StringBuffer script = new StringBuffer("var w = window.open(" + this.target + ", '").append(windowTitle).append("', '");
        script.append("scrollbars=").append(this.flagToString(8));
        script.append(",location=").append(this.flagToString(1));
        script.append(",menuBar=").append(this.flagToString(2));
        script.append(",resizable=").append(this.flagToString(4));
        script.append(",status=").append(this.flagToString(16));
        script.append(",toolbar=").append(this.flagToString(32));
        if (this.width != -1) {
            script.append(",width=").append(this.width);
        }
        if (this.height != -1) {
            script.append(",height=").append(this.height);
        }
        if (this.left != -1) {
            script.append(",left=").append(this.left);
        }
        if (this.top != -1) {
            script.append(",top=").append(this.top);
        }
        script.append("'); if(w.blur) w.focus();").append(" return false;");
        return script.toString();
    }

    public PopupSettings setHeight(int popupHeight) {
        this.height = popupHeight;
        return this;
    }

    public PopupSettings setLeft(int popupPositionLeft) {
        this.left = popupPositionLeft;
        return this;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public PopupSettings setTop(int popupPositionTop) {
        this.top = popupPositionTop;
        return this;
    }

    public PopupSettings setWidth(int popupWidth) {
        this.width = popupWidth;
        return this;
    }

    public PopupSettings setWindowName(String popupWindowName) {
        if (popupWindowName != null) {
            this.windowName = popupWindowName;
            if (this.pageMapName != null && !this.pageMapName.equals(popupWindowName)) {
                log.warn("the page map and window name should be the same. The page map was " + this.pageMapName + ", and the requested window name is " + popupWindowName + "; changing the page map to " + popupWindowName);
            }
            this.pageMapName = popupWindowName;
        }
        return this;
    }

    private String flagToString(int flag) {
        return (this.displayFlags & flag) != 0 ? "yes" : "no";
    }

    @Deprecated
    public IPageMap getPageMap() {
        if (this.pageMapName != null) {
            return PageMap.forName(this.pageMapName);
        }
        throw new UnsupportedOperationException("this method can only work when a page map is set. Either call getPageMap(Component) or set the page map");
    }

    @Deprecated
    public IPageMap getPageMap(Component callee) {
        if (this.pageMapName != null) {
            return PageMap.forName(this.pageMapName);
        }
        if (callee == null) {
            throw new IllegalArgumentException("when the page map is not set, argument callee may not be null");
        }
        Page page = callee.getPage();
        if (page == null) {
            throw new IllegalStateException(callee + " is not yet set on a page; if you want to use this method " + "without a page map being set, argument callee must be not null " + "and added to a page");
        }
        return page.getPageMap();
    }

    public String getPageMapName(Component callee) {
        if (this.pageMapName != null) {
            return this.pageMapName;
        }
        return this.getPageMap(callee).getName();
    }
}

