/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalLink
extends AbstractLink {
    private static final long serialVersionUID = 1L;
    private final IModel<String> label;
    private boolean contextRelative = false;
    private PopupSettings popupSettings = null;

    public ExternalLink(String id, String href, String label) {
        super(id);
        this.setDefaultModel(href != null ? new Model<String>(href) : null);
        this.label = label != null ? new Model<String>(label) : null;
    }

    public ExternalLink(String id, String href) {
        this(id, href, null);
    }

    public ExternalLink(String id, IModel<String> href, IModel<String> label) {
        super(id);
        this.setDefaultModel((IModel)this.wrap(href));
        this.label = this.wrap(label);
    }

    public ExternalLink(String id, IModel<String> href) {
        this(id, href, null);
    }

    public final PopupSettings getPopupSettings() {
        return this.popupSettings;
    }

    public final ExternalLink setPopupSettings(PopupSettings popupSettings) {
        this.popupSettings = popupSettings;
        return this;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isLinkEnabled()) {
            this.disableLink(tag);
        } else if (this.getDefaultModel() != null) {
            String popupPageMapName;
            Object hrefValue = this.getDefaultModelObject();
            if (hrefValue != null) {
                String url = hrefValue.toString();
                if (this.contextRelative) {
                    if (url.length() > 0 && url.charAt(0) == '/') {
                        url = url.substring(1);
                    }
                    url = RequestCycle.get().getProcessor().getRequestCodingStrategy().rewriteStaticRelativeUrl(url);
                }
                if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                    tag.put("href", Strings.replaceAll(url, "&", "&amp;"));
                    if (this.popupSettings != null) {
                        tag.put("onclick", this.popupSettings.getPopupJavaScript());
                    }
                } else if (this.popupSettings != null) {
                    this.popupSettings.setTarget("'" + url + "'");
                    String popupScript = this.popupSettings.getPopupJavaScript();
                    tag.put("onclick", popupScript);
                } else {
                    tag.put("onclick", "window.location.href='" + url + "';return false;");
                }
            }
            if (this.popupSettings != null && (popupPageMapName = this.popupSettings.getPageMapName(this)) != null) {
                tag.put("target", popupPageMapName);
            }
        }
    }

    @Override
    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (!this.isLinkEnabled() && this.getBeforeDisabledLink() != null) {
            this.getResponse().write(this.getBeforeDisabledLink());
        }
        if (this.label != null && this.label.getObject() != null) {
            this.replaceComponentTagBody(markupStream, openTag, this.getDefaultModelObjectAsString(this.label.getObject()));
        } else {
            this.renderComponentTagBody(markupStream, openTag);
        }
        if (!this.isLinkEnabled() && this.getAfterDisabledLink() != null) {
            this.getResponse().write(this.getAfterDisabledLink());
        }
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public ExternalLink setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
        return this;
    }

    public IModel<String> getLabel() {
        return this.label;
    }
}

