/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.util.collections.MiniMap;
import org.apache.wicket.util.lang.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkablePageLink<T>
extends Link<T> {
    private static final long serialVersionUID = 1L;
    private final String pageClassName;
    private String pageMapName = null;
    protected MiniMap<String, Object> parameters;

    public <C extends Page> BookmarkablePageLink(String id, Class<C> pageClass) {
        this(id, pageClass, null);
    }

    private MiniMap<String, Object> pageParametersToMiniMap(PageParameters parameters) {
        if (parameters != null) {
            MiniMap<String, Object> map = new MiniMap<String, Object>(parameters, parameters.keySet().size());
            return map;
        }
        return null;
    }

    public PageParameters getPageParameters() {
        PageParameters result = new PageParameters();
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private void setParameterImpl(String key, Object value) {
        PageParameters parameters = this.getPageParameters();
        parameters.put(key, value);
        this.parameters = this.pageParametersToMiniMap(parameters);
    }

    public <C extends Page> BookmarkablePageLink(String id, Class<C> pageClass, PageParameters parameters) {
        super(id);
        this.parameters = this.pageParametersToMiniMap(parameters);
        if (pageClass == null) {
            throw new IllegalArgumentException("Page class for bookmarkable link cannot be null");
        }
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("Page class must be derived from " + Page.class.getName());
        }
        this.pageClassName = pageClass.getName();
    }

    public final Class<? extends Page> getPageClass() {
        return Classes.resolveClass(this.pageClassName);
    }

    public final IPageMap getPageMap() {
        if (this.pageMapName != null) {
            return PageMap.forName(this.pageMapName);
        }
        return this.getPage().getPageMap();
    }

    @Override
    public boolean linksTo(Page page) {
        return page.getClass() == this.getPageClass();
    }

    @Override
    protected boolean getStatelessHint() {
        return true;
    }

    @Override
    public final void onClick() {
    }

    public final BookmarkablePageLink<T> setPageMap(IPageMap pageMap) {
        if (pageMap != null) {
            this.pageMapName = pageMap.getName();
            this.add(new AttributeModifier("target", true, new Model<String>(this.pageMapName)));
        }
        return this;
    }

    public BookmarkablePageLink<T> setParameter(String property, int value) {
        this.setParameterImpl(property, Integer.toString(value));
        return this;
    }

    public BookmarkablePageLink<T> setParameter(String property, long value) {
        this.setParameterImpl(property, Long.toString(value));
        return this;
    }

    public BookmarkablePageLink<T> setParameter(String property, String value) {
        this.setParameterImpl(property, value);
        return this;
    }

    @Override
    protected CharSequence getURL() {
        if (this.pageMapName != null && this.getPopupSettings() != null) {
            throw new IllegalStateException("You cannot specify popup settings and a page map");
        }
        PageParameters parameters = this.getPageParameters();
        if (this.getPopupSettings() != null) {
            String pageMapName = this.getPopupSettings().getPageMapName(this);
            if (pageMapName == null) {
                pageMapName = PageMap.DEFAULT_NAME;
            }
            return this.urlFor(new BookmarkablePageRequestTarget(pageMapName, this.getPageClass(), parameters));
        }
        return this.urlFor(this.getPageMap(), this.getPageClass(), parameters);
    }
}

