/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.internal.DirectChildTagIterator;
import org.apache.wicket.markup.html.internal.Enclosure;
import org.apache.wicket.markup.html.internal.ResponseBufferZone;
import org.apache.wicket.markup.resolver.ComponentResolvers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineEnclosure
extends Enclosure {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InlineEnclosure.class);
    private transient List<Component> children = null;

    public InlineEnclosure(String id, String childId) {
        super(id, childId);
    }

    public boolean isVisible() {
        this.updateVisibility();
        return super.isVisible();
    }

    protected void onAfterRenderChildren() {
        if (this.children == null) {
            log.warn("Child list not yet generated.");
        } else {
            for (Component child : this.children) {
                child.afterRender();
            }
        }
        super.onAfterRenderChildren();
    }

    private Component getChildComponent() {
        MarkupContainer container = this.getEnclosureParent();
        Component child = container.get(((Object)this.childId).toString());
        return child;
    }

    public boolean updateVisibility() {
        Component child = this.getChildComponent();
        if (child == null) {
            throw new WicketRuntimeException("Could not find child with id: " + this.childId + " in the wicket:enclosure");
        }
        boolean visible = child.isVisible();
        this.setVisible(visible);
        return visible;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag enclosureOpenTag) {
        this.enumerateChildren(markupStream, enclosureOpenTag);
        super.onComponentTagBody(markupStream, enclosureOpenTag);
    }

    private void enumerateChildren(final MarkupStream markupStream, ComponentTag enclosureOpenTag) {
        final MarkupContainer container = this.getEnclosureParent();
        this.children = new ArrayList<Component>();
        DirectChildTagIterator it = new DirectChildTagIterator(markupStream, enclosureOpenTag);
        while (it.hasNext()) {
            final ComponentTag tag = it.next();
            if (tag.isAutoComponentTag()) continue;
            Component child = container.get(tag.getId());
            if (child == null) {
                CharSequence buffer = new ResponseBufferZone(this.getRequestCycle(), markupStream){

                    protected void executeInsideBufferedZone() {
                        int ind = markupStream.findComponentIndex(tag.getPath(), tag.getId());
                        markupStream.setCurrentIndex(ind);
                        ComponentResolvers.resolve(InlineEnclosure.this.getApplication(), container, markupStream, tag);
                    }
                }.execute();
                child = container.get(tag.getId());
                if (child == null) {
                    throw new WicketRuntimeException("Could not find child with id: " + tag.getId() + " in the wicket:enclosure");
                }
            }
            this.children.add(child);
        }
        it.rewind();
    }

    public String getChildId() {
        return ((Object)this.childId).toString();
    }
}

