/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.upload.FileItem;

public class FileUpload
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final FileItem item;
    private transient List<InputStream> inputStreamsToClose;

    public FileUpload(FileItem item) {
        this.item = item;
    }

    public final void closeStreams() {
        if (this.inputStreamsToClose != null) {
            for (InputStream inputStream : this.inputStreamsToClose) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.inputStreamsToClose = null;
        }
    }

    public void delete() {
        this.item.delete();
    }

    public byte[] getBytes() {
        return this.item.get();
    }

    public byte[] getMD5() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WicketRuntimeException("Your java runtime does not support MD5 digests. Please see java.security.MessageDigest.getInstance(\"MD5\"", ex);
        }
        if (this.item.isInMemory()) {
            digest.update(this.getBytes());
            return digest.digest();
        }
        InputStream in = null;
        try {
            int len;
            in = this.item.getInputStream();
            byte[] buf = new byte[Math.min((int)this.item.getSize(), 40960)];
            while (-1 != (len = in.read(buf))) {
                digest.update(buf, 0, len);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        catch (IOException ex) {
            throw new WicketRuntimeException("Error while reading input data for MD5 checksum", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public String getClientFileName() {
        String name = this.item.getName();
        name = Strings.lastPathComponent(name, '/');
        name = Strings.lastPathComponent(name, '\\');
        return name;
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStreamsToClose == null) {
            this.inputStreamsToClose = new ArrayList<InputStream>();
        }
        InputStream is = this.item.getInputStream();
        this.inputStreamsToClose.add(is);
        return is;
    }

    public long getSize() {
        return this.item.getSize();
    }

    public void writeTo(File file) throws IOException {
        this.writeTo(file, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file, int bufSize) throws IOException {
        InputStream is = this.getInputStream();
        try {
            Files.writeTo(file, is, bufSize);
        }
        finally {
            is.close();
        }
    }

    public final File writeToTempFile() throws IOException {
        String sessionId = Session.exists() ? Session.get().getId() : "";
        String tempFileName = sessionId + "_" + RequestCycle.get().getStartTime();
        File temp = File.createTempFile(tempFileName, Files.cleanupFilename(this.item.getFieldName()));
        this.writeTo(temp);
        return temp;
    }
}

