/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.persistence;

import javax.servlet.http.Cookie;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.persistence.CookieValuePersisterSettings;
import org.apache.wicket.markup.html.form.persistence.IValuePersister;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieValuePersister
implements IValuePersister {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CookieValuePersister.class);
    private final CookieValuePersisterSettings settings;

    public CookieValuePersister() {
        this.settings = new CookieValuePersisterSettings();
    }

    public CookieValuePersister(CookieValuePersisterSettings settings) {
        this.settings = settings;
    }

    @Override
    public void clear(String key) {
        Cookie cookie = this.getCookie(this.getSaveKey(key));
        if (cookie != null) {
            this.clear(cookie);
        }
    }

    @Override
    public void clear(FormComponent<?> formComponent) {
        this.clear(formComponent.getPageRelativePath());
    }

    @Override
    public String load(String key) {
        Cookie cookie = this.getCookie(this.getSaveKey(key));
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void load(FormComponent<?> formComponent) {
        String value = this.load(formComponent.getPageRelativePath());
        if (value != null) {
            formComponent.setModelValue(value.split(FormComponent.VALUE_SEPARATOR));
        }
    }

    @Override
    public void save(String key, String value) {
        Cookie cookie = this.getCookie(key = this.getSaveKey(key));
        if (cookie == null) {
            cookie = new Cookie(key, value == null ? "" : value);
        } else {
            cookie.setValue(value == null ? "" : value);
        }
        cookie.setSecure(false);
        cookie.setMaxAge(this.settings.getMaxAge());
        this.save(cookie);
    }

    @Override
    public void save(FormComponent<?> formComponent) {
        this.save(formComponent.getPageRelativePath(), formComponent.getValue());
    }

    protected String getSaveKey(String key) {
        if (Strings.isEmpty(key)) {
            throw new IllegalArgumentException("A Cookie name can not be null or empty");
        }
        key = key.replace(".", "..");
        key = key.replace(":", ".");
        return key;
    }

    private void clear(Cookie cookie) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setValue(null);
            this.save(cookie);
            if (log.isDebugEnabled()) {
                log.debug("Removed Cookie: " + cookie.getName());
            }
        }
    }

    private Cookie getCookie(String name) {
        try {
            Cookie cookie = this.getWebRequest().getCookie(name);
            if (log.isDebugEnabled()) {
                if (cookie != null) {
                    log.debug("Found Cookie with name=" + name + " and request URI=" + this.getWebRequest().getHttpServletRequest().getRequestURI());
                } else {
                    log.debug("Unable to find Cookie with name=" + name + " and request URI=" + this.getWebRequest().getHttpServletRequest().getRequestURI());
                }
            }
            return cookie;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private Cookie save(Cookie cookie) {
        String path;
        String domain;
        if (cookie == null) {
            return null;
        }
        String comment = this.settings.getComment();
        if (comment != null) {
            cookie.setComment(comment);
        }
        if ((domain = this.settings.getDomain()) != null) {
            cookie.setDomain(domain);
        }
        if (Strings.isEmpty(path = this.getWebRequest().getHttpServletRequest().getContextPath())) {
            path = "/";
        }
        cookie.setPath(path);
        cookie.setVersion(this.settings.getVersion());
        cookie.setSecure(this.settings.getSecure());
        this.getWebResponse().addCookie(cookie);
        if (log.isDebugEnabled()) {
            log.debug("Cookie saved: " + this.cookieToDebugString(cookie) + "; request URI=" + this.getWebRequest().getHttpServletRequest().getRequestURI());
        }
        return cookie;
    }

    private WebRequest getWebRequest() {
        return (WebRequest)RequestCycle.get().getRequest();
    }

    private WebResponse getWebResponse() {
        return (WebResponse)RequestCycle.get().getResponse();
    }

    private String cookieToDebugString(Cookie cookie) {
        return "[Cookie  name = " + cookie.getName() + ", value = " + cookie.getValue() + ", domain = " + cookie.getDomain() + ", path = " + cookie.getPath() + ", maxAge = " + Time.valueOf(cookie.getMaxAge()).toDateString() + "(" + cookie.getMaxAge() + ")" + "]";
    }
}

