/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AutoLabelResolver;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.ILabelProvider;
import org.apache.wicket.markup.html.internal.ResponseBufferZone;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class AutoLabelTextResolver
implements IComponentResolver {
    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag && "label".equals(((WicketTag)tag).getName())) {
            Component related = null;
            if (tag.getAttribute("for") != null) {
                Component component;
                related = component = AutoLabelResolver.findRelatedComponent(container, tag.getAttribute("for"));
            }
            if (related == null) {
                AutoLabelResolver.AutoLabel autoLabel;
                if (container instanceof AutoLabelResolver.AutoLabel) {
                    related = ((AutoLabelResolver.AutoLabel)container).getRelatedComponent();
                }
                if (related == null && (autoLabel = container.findParent(AutoLabelResolver.AutoLabel.class)) != null) {
                    related = autoLabel.getRelatedComponent();
                }
            }
            if (related == null) {
                throw new IllegalStateException("no related component found for <wicket:label>");
            }
            container.autoAdd(new TextLabel("label" + container.getPage().getAutoIndex2(), related), markupStream);
            return true;
        }
        return false;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("label");
    }

    private static class TextLabel
    extends WebMarkupContainer {
        private final Component labeled;

        public TextLabel(String id, Component labeled) {
            super(id);
            this.labeled = labeled;
            this.setRenderBodyOnly(true);
        }

        protected void onComponentTag(ComponentTag tag) {
            if (tag.isOpenClose()) {
                tag.setType(XmlTag.OPEN);
            }
            super.onComponentTag(tag);
        }

        protected void onComponentTagBody(final MarkupStream markupStream, final ComponentTag openTag) {
            String text;
            String text2;
            ILabelProvider provider;
            boolean storeLabelText = false;
            String labelText = null;
            if (this.labeled instanceof ILabelProvider && (provider = (ILabelProvider)((Object)this.labeled)).getLabel() != null && !Strings.isEmpty(text2 = (String)provider.getLabel().getObject())) {
                labelText = text2;
            }
            if (labelText == null && this.labeled instanceof FormComponent && !"wicket:unknown".equals(text = ((FormComponent)this.labeled).getDefaultLabel("wicket:unknown")) && !Strings.isEmpty(text)) {
                labelText = text;
            }
            if (labelText == null && openTag.getAttribute("key") != null && !Strings.isEmpty(text = this.labeled.getString(openTag.getAttribute("key")))) {
                labelText = text;
                storeLabelText = true;
            }
            if (labelText == null && !Strings.isEmpty(text = ((Object)new ResponseBufferZone(RequestCycle.get(), markupStream){

                protected void executeInsideBufferedZone() {
                    TextLabel.super.onComponentTagBody(markupStream, openTag);
                }
            }.execute()).toString())) {
                labelText = text;
                storeLabelText = true;
            }
            this.replaceComponentTagBody(markupStream, openTag, labelText);
            if (this.labeled instanceof FormComponent) {
                FormComponent fc = (FormComponent)this.labeled;
                fc.setLabel(Model.of(labelText));
            }
        }
    }
}

