/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.string.Strings;

public class AutoLabelTagHandler
extends AbstractMarkupFilter {
    public MarkupElement nextTag() throws ParseException {
        ComponentTag tag = this.nextComponentTag();
        if (tag == null || tag.isClose()) {
            return tag;
        }
        String related = tag.getAttribute("wicket:for");
        if (related == null) {
            return tag;
        }
        if (Strings.isEmpty(related = related.trim())) {
            throw new ParseException("Tag contains an empty wicket:for attribute", tag.getPos());
        }
        if (!"label".equalsIgnoreCase(tag.getName())) {
            throw new ParseException("Attribute wicket:for can only be attached to <label> tag", tag.getPos());
        }
        if (tag.getId() != null) {
            throw new ParseException("Attribute wicket:for cannot be used in conjunction with wicket:id", tag.getPos());
        }
        tag.setId(this.getClass().getName());
        tag.setModified(true);
        tag.setAutoComponentTag(true);
        return tag;
    }
}

