/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AutoLabelTagHandler;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.ILabelProvider;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLabelResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(AutoLabelResolver.class);

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (!AutoLabelTagHandler.class.getName().equals(tag.getId())) {
            return false;
        }
        String id = tag.getAttribute("wicket:for").trim();
        Component component = AutoLabelResolver.findRelatedComponent(container, id);
        if (component == null) {
            throw new WicketRuntimeException("Could not find form component with id: " + id + " while trying to resolve wicket:for attribute");
        }
        if (!(component instanceof ILabelProvider)) {
            throw new WicketRuntimeException("Component pointed to by wicket:for attribute: " + id + " does not implement " + ILabelProvider.class.getName());
        }
        if (!component.getOutputMarkupId()) {
            component.setOutputMarkupId(true);
            if (!component.hasBeenRendered()) {
                logger.warn("Component: {} is reference via a wicket:for attribute but does not have its outputMarkupId property set to true", (Object)component.toString(false));
            }
        }
        container.autoAdd(new AutoLabel("label" + container.getPage().getAutoIndex2(), component), markupStream);
        return true;
    }

    static Component findRelatedComponent(MarkupContainer container, final String id) {
        Component component = container.get(id);
        if (component != null && component instanceof ILabelProvider) {
            return component;
        }
        final Component[] searched = new Component[]{null};
        while (container != null) {
            component = (Component)container.visitChildren(Component.class, new Component.IVisitor<Component>(){

                @Override
                public Object component(Component child) {
                    if (child == searched[0]) {
                        return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                    }
                    if (id.equals(child.getId())) {
                        return child;
                    }
                    return CONTINUE_TRAVERSAL;
                }
            });
            if (component != null) {
                return component;
            }
            searched[0] = container;
            container = container.getParent();
        }
        return null;
    }

    protected static class AutoLabel
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AutoLabel(String id, Component fc) {
            super(id);
            this.component = fc;
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            tag.put("for", this.component.getMarkupId());
            if (this.component instanceof FormComponent) {
                FormComponent fc = (FormComponent)this.component;
                if (fc.isRequired()) {
                    tag.append("class", "required", " ");
                }
                if (!fc.isValid()) {
                    tag.append("class", "error", " ");
                }
                if (!fc.isEnabledInHierarchy()) {
                    tag.append("class", "disabled", " ");
                }
            }
        }

        public boolean isTransparentResolver() {
            return true;
        }

        public Component getRelatedComponent() {
            return this.component;
        }
    }
}

