/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubmitLink
extends AbstractLink
implements IFormSubmittingComponent {
    private static final long serialVersionUID = 1L;
    private Form<?> form;
    private boolean defaultFormProcessing = true;

    public AbstractSubmitLink(String id, IModel<?> model) {
        super(id, model);
    }

    public AbstractSubmitLink(String id) {
        super(id);
    }

    public AbstractSubmitLink(String id, IModel<?> model, Form<?> form) {
        super(id, model);
        this.form = form;
    }

    public AbstractSubmitLink(String id, Form<?> form) {
        super(id);
        this.form = form;
    }

    public final AbstractSubmitLink setDefaultFormProcessing(boolean defaultFormProcessing) {
        if (this.defaultFormProcessing != defaultFormProcessing) {
            this.addStateChange(new Change(){
                private static final long serialVersionUID = 1L;
                boolean formerValue;
                {
                    this.formerValue = AbstractSubmitLink.this.defaultFormProcessing;
                }

                public void undo() {
                    AbstractSubmitLink.this.defaultFormProcessing = this.formerValue;
                }

                public String toString() {
                    return "DefaultFormProcessingChange[component: " + AbstractSubmitLink.this.getPath() + ", default processing: " + this.formerValue + "]";
                }
            });
        }
        this.defaultFormProcessing = defaultFormProcessing;
        return this;
    }

    @Override
    public boolean getDefaultFormProcessing() {
        return this.defaultFormProcessing;
    }

    @Override
    public Form<?> getForm() {
        if (this.form != null) {
            return this.form;
        }
        return this.findParent(Form.class);
    }

    @Override
    public String getInputName() {
        return Form.getRootFormRelativeId(this);
    }
}

