/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupResourceData;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.html.form.AutoLabelTagHandler;
import org.apache.wicket.markup.parser.IMarkupFilter;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.filter.EnclosureHandler;
import org.apache.wicket.markup.parser.filter.HeadForceTagIdHandler;
import org.apache.wicket.markup.parser.filter.HtmlHandler;
import org.apache.wicket.markup.parser.filter.HtmlHeaderSectionHandler;
import org.apache.wicket.markup.parser.filter.InlineEnclosureHandler;
import org.apache.wicket.markup.parser.filter.OpenCloseTagExpander;
import org.apache.wicket.markup.parser.filter.RelativePathPrefixHandler;
import org.apache.wicket.markup.parser.filter.WicketLinkTagHandler;
import org.apache.wicket.markup.parser.filter.WicketMessageTagHandler;
import org.apache.wicket.markup.parser.filter.WicketNamespaceHandler;
import org.apache.wicket.markup.parser.filter.WicketRemoveTagHandler;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupParser {
    private static final Logger log = LoggerFactory.getLogger(MarkupParser.class);
    public static final Pattern CONDITIONAL_COMMENT_OPENING = Pattern.compile("(s?)^[^>]*?<!--\\[if.*?\\]>(-->)?(<!.*?-->)?");
    private final IXmlPullParser xmlParser;
    private IMarkupFilter markupFilterChain;
    private final Markup markup;
    private final IMarkupSettings markupSettings;

    public MarkupParser(MarkupResourceStream resource) {
        this(new XmlPullParser(), resource);
    }

    public MarkupParser(String markup) {
        this(new XmlPullParser(), new MarkupResourceStream(new StringResourceStream((CharSequence)markup)));
    }

    public MarkupParser(IXmlPullParser xmlParser, MarkupResourceStream resource) {
        this.xmlParser = xmlParser;
        this.markupSettings = Application.get().getMarkupSettings();
        MarkupResourceData markup = new MarkupResourceData();
        markup.setResource(resource);
        this.markup = new Markup(markup);
        this.initializeMarkupFilters();
    }

    public final void setWicketNamespace(String namespace) {
        this.markup.getMarkupResourceData().setWicketNamespace(namespace);
    }

    protected MarkupResourceStream getMarkupResourceStream() {
        return this.markup.getMarkupResourceData().getResource();
    }

    private final void initializeMarkupFilters() {
        ContainerInfo containerInfo;
        this.markupFilterChain = this.xmlParser;
        MarkupResourceData markupResourceData = this.markup.getMarkupResourceData();
        this.appendMarkupFilter(new WicketTagIdentifier(markupResourceData));
        this.appendMarkupFilter(new HtmlHandler());
        this.appendMarkupFilter(new WicketRemoveTagHandler());
        this.appendMarkupFilter(new WicketLinkTagHandler());
        this.appendMarkupFilter(new WicketNamespaceHandler(markupResourceData));
        MarkupResourceStream resource = markupResourceData.getResource();
        if (resource != null && (containerInfo = resource.getContainerInfo()) != null) {
            this.appendMarkupFilter(new WicketMessageTagHandler());
            if (Page.class.isAssignableFrom(containerInfo.getContainerClass())) {
                this.appendMarkupFilter(new HtmlHeaderSectionHandler(this.markup));
            }
            this.appendMarkupFilter(new HeadForceTagIdHandler(containerInfo.getContainerClass()));
        }
        this.appendMarkupFilter(new OpenCloseTagExpander());
        this.appendMarkupFilter(new RelativePathPrefixHandler());
        this.appendMarkupFilter(new EnclosureHandler());
        this.appendMarkupFilter(new InlineEnclosureHandler());
        this.appendMarkupFilter(new AutoLabelTagHandler());
    }

    @Deprecated
    protected void initFilterChain() {
        throw new WicketRuntimeException("This method is no longer suppoert: since 1.3");
    }

    public final void appendMarkupFilter(IMarkupFilter filter) {
        this.appendMarkupFilter(filter, RelativePathPrefixHandler.class);
    }

    public final void appendMarkupFilter(IMarkupFilter filter, Class<? extends IMarkupFilter> beforeFilter) {
        if (beforeFilter == null || this.markupFilterChain == null) {
            filter.setParent(this.markupFilterChain);
            this.markupFilterChain = filter;
        } else {
            IMarkupFilter current;
            for (current = this.markupFilterChain; current != null; current = current.getParent()) {
                if (current.getClass() != beforeFilter) continue;
                filter.setParent(current.getParent());
                current.setParent(filter);
                break;
            }
            if (current == null) {
                filter.setParent(this.markupFilterChain);
                this.markupFilterChain = filter;
            }
        }
    }

    public final Markup parse() throws IOException, ResourceStreamNotFoundException {
        MarkupResourceData markupResourceData = this.markup.getMarkupResourceData();
        this.xmlParser.parse(markupResourceData.getResource().getInputStream(), this.markupSettings.getDefaultMarkupEncoding());
        this.parseMarkup();
        markupResourceData.setEncoding(this.xmlParser.getEncoding());
        markupResourceData.setXmlDeclaration(this.xmlParser.getXmlDeclaration());
        if (this.xmlParser.getXmlDeclaration() == null) {
            if (this.markupSettings.getThrowExceptionOnMissingXmlDeclaration()) {
                throw new MarkupException(markupResourceData.getResource(), "The markup file does not have a XML declaration prolog. . E.g. <?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            }
            log.debug("The markup file does not have a XML declaration prolog: " + markupResourceData.getResource() + ". It is more save to use it. E.g. <?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        }
        return this.markup;
    }

    public ComponentTag getNextTag() throws ParseException {
        return (ComponentTag)this.markupFilterChain.nextTag();
    }

    private void parseMarkup() {
        boolean stripComments = this.markupSettings.getStripComments();
        boolean compressWhitespace = this.markupSettings.getCompressWhitespace();
        try {
            ComponentTag tag;
            int size = this.markup.size();
            while (null != (tag = this.getNextTag())) {
                boolean add;
                boolean bl = add = tag.getId() != null;
                if (!add && tag.getXmlTag().isClose()) {
                    boolean bl2 = add = tag.getOpenTag() != null && tag.getOpenTag().getId() != null;
                }
                if (add || tag.isModified() || this.markup.size() != size) {
                    CharSequence text = this.xmlParser.getInputFromPositionMarker(tag.getPos());
                    if (text.length() > 0) {
                        String rawMarkup = ((Object)text).toString();
                        if (stripComments) {
                            rawMarkup = MarkupParser.removeComment(rawMarkup);
                        }
                        if (compressWhitespace) {
                            rawMarkup = this.compressWhitespace(rawMarkup);
                        }
                        this.markup.addMarkupElement(size, new RawMarkup(rawMarkup));
                    }
                    this.xmlParser.setPositionMarker();
                    if (add) {
                        if (!tag.isIgnore()) {
                            this.markup.addMarkupElement(tag);
                        }
                    } else if (tag.isModified()) {
                        this.markup.addMarkupElement(new RawMarkup(tag.toCharSequence()));
                    } else {
                        this.xmlParser.setPositionMarker(tag.getPos());
                    }
                }
                size = this.markup.size();
            }
        }
        catch (ParseException ex) {
            CharSequence text = this.xmlParser.getInputFromPositionMarker(-1);
            if (text.length() > 0) {
                this.markup.addMarkupElement(new RawMarkup(text));
            }
            this.markup.getMarkupResourceData().setEncoding(this.xmlParser.getEncoding());
            this.markup.getMarkupResourceData().setXmlDeclaration(this.xmlParser.getXmlDeclaration());
            MarkupStream markupStream = new MarkupStream(this.markup);
            markupStream.setCurrentIndex(this.markup.size() - 1);
            throw new MarkupException(markupStream, ex.getMessage(), (Throwable)ex);
        }
        CharSequence text = this.xmlParser.getInputFromPositionMarker(-1);
        if (text.length() > 0) {
            String rawMarkup = ((Object)text).toString();
            if (stripComments) {
                rawMarkup = MarkupParser.removeComment(rawMarkup);
            }
            if (compressWhitespace) {
                rawMarkup = this.compressWhitespace(rawMarkup);
            }
            this.markup.addMarkupElement(new RawMarkup(rawMarkup));
        }
        this.markup.makeImmutable();
    }

    protected String compressWhitespace(String rawMarkup) {
        Pattern preBlock = Pattern.compile("<pre>.*?</pre>", 40);
        Matcher m = preBlock.matcher(rawMarkup);
        int lastend = 0;
        StringBuffer sb = null;
        while (true) {
            boolean matched;
            String nonPre = (matched = m.find()) ? rawMarkup.substring(lastend, m.start()) : rawMarkup.substring(lastend);
            nonPre = nonPre.replaceAll("[ \\t]+", " ");
            nonPre = nonPre.replaceAll("( ?[\\r\\n] ?)+", "\n");
            if (lastend == 0) {
                if (matched) {
                    sb = new StringBuffer(rawMarkup.length());
                } else {
                    return nonPre;
                }
            }
            sb.append(nonPre);
            if (!matched) break;
            sb.append(m.group());
            lastend = m.end();
        }
        return sb.toString();
    }

    private static String removeComment(String rawMarkup) {
        int pos1 = rawMarkup.indexOf("<!--");
        while (pos1 != -1) {
            StringBuilder buf = new StringBuilder(rawMarkup.length());
            String possibleComment = rawMarkup.substring(pos1);
            Matcher matcher = CONDITIONAL_COMMENT_OPENING.matcher(possibleComment);
            if (matcher.find()) {
                pos1 += matcher.end();
            } else {
                int pos2 = rawMarkup.indexOf("-->", pos1 + 4);
                buf.append(rawMarkup.substring(0, pos1));
                if (rawMarkup.length() >= pos2 + 3) {
                    buf.append(rawMarkup.substring(pos2 + 3));
                }
                rawMarkup = buf.toString();
            }
            pos1 = rawMarkup.indexOf("<!--", pos1);
        }
        return rawMarkup;
    }
}

