/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.DefaultMarkupCacheKeyProvider;
import org.apache.wicket.markup.DefaultMarkupResourceStreamProvider;
import org.apache.wicket.markup.IMarkupCache;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupResourceData;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.loader.DefaultMarkupLoader;
import org.apache.wicket.markup.loader.IMarkupLoader;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupCache
implements IMarkupCache {
    private static final Logger log = LoggerFactory.getLogger(MarkupCache.class);
    private final ICache<CharSequence, Markup> markupCache;
    private final ICache<CharSequence, CharSequence> markupKeyCache;
    private IMarkupCacheKeyProvider markupCacheKeyProvider;
    private IMarkupResourceStreamProvider markupResourceStreamProvider;
    private IMarkupLoader markupLoader;
    private final Application application;

    public MarkupCache(Application application) {
        this.application = application;
        this.markupCache = this.newCacheImplementation();
        this.markupKeyCache = this.newCacheImplementation();
        if (this.markupCache == null) {
            throw new WicketRuntimeException("The map used to cache markup must not be null");
        }
    }

    @Override
    public final void clear() {
        this.markupCache.clear();
        this.markupKeyCache.clear();
    }

    @Override
    public void shutdown() {
        this.markupCache.shutdown();
        this.markupKeyCache.shutdown();
    }

    @Override
    public final Markup removeMarkup(String cacheKey) {
        String locationString;
        Markup markup;
        if (cacheKey == null) {
            throw new IllegalArgumentException("Parameter 'cacheKey' must not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Remove from cache: cacheKey=" + cacheKey);
        }
        if ((markup = this.markupCache.get(locationString = (String)this.markupKeyCache.get(cacheKey))) != null) {
            int count;
            this.markupCache.remove(locationString);
            do {
                count = 0;
                Iterator<CharSequence> iter = this.markupCache.getKeys().iterator();
                while (iter.hasNext()) {
                    String baseCacheKey;
                    String baseLocationString;
                    Markup cacheMarkup = this.markupCache.get(iter.next());
                    MarkupResourceData resourceData = cacheMarkup.getMarkupResourceData().getBaseMarkupResourceData();
                    if (resourceData == null || (baseLocationString = (String)this.markupKeyCache.get(baseCacheKey = resourceData.getResource().getCacheKey())) == null || this.markupCache.get(baseLocationString) != null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Remove from cache: cacheKey=" + cacheMarkup.getMarkupResourceData().getResource().getCacheKey());
                    }
                    iter.remove();
                    ++count;
                }
            } while (count > 0);
            IModificationWatcher watcher = this.application.getResourceSettings().getResourceWatcher(true);
            if (watcher != null) {
                Iterator<IModifiable> iter = watcher.getEntries().iterator();
                while (iter.hasNext()) {
                    MarkupResourceStream resourceStream;
                    String resourceCacheKey;
                    String resouceLocationString;
                    IModifiable modifiable = iter.next();
                    if (!(modifiable instanceof MarkupResourceStream) || (resouceLocationString = (String)this.markupKeyCache.get(resourceCacheKey = (resourceStream = (MarkupResourceStream)modifiable).getCacheKey())) == null || this.markupCache.containsKey(resouceLocationString)) continue;
                    iter.remove();
                }
            }
        }
        return markup;
    }

    @Override
    public final MarkupStream getMarkupStream(MarkupContainer container, boolean enforceReload, boolean throwException) {
        if (container == null) {
            throw new IllegalArgumentException("Parameter 'container' must not be 'null'.");
        }
        Markup markup = this.getMarkup(container, container.getClass(), enforceReload);
        if (markup != Markup.NO_MARKUP) {
            return new MarkupStream(markup);
        }
        if (throwException) {
            throw new MarkupNotFoundException("Markup of type '" + container.getMarkupType() + "' for component '" + container.getClass().getName() + "' not found." + " Enable debug messages for org.apache.wicket.util.resource to get a list of all filenames tried.: " + container.toString());
        }
        return null;
    }

    @Override
    public final boolean hasAssociatedMarkup(MarkupContainer container) {
        return this.getMarkup(container, container.getClass(), false) != Markup.NO_MARKUP;
    }

    @Override
    public final int size() {
        return this.markupCache.size();
    }

    protected final ICache<CharSequence, Markup> getMarkupCache() {
        return this.markupCache;
    }

    @Override
    public final Markup getMarkup(MarkupContainer container, Class<?> clazz, boolean enforceReload) {
        Markup markup;
        Class<?> containerClass = clazz;
        if (clazz == null) {
            containerClass = container.getClass();
        } else if (!clazz.isAssignableFrom(container.getClass())) {
            throw new WicketRuntimeException("Parameter clazz must be an instance of " + container.getClass().getName() + ", but is a " + clazz.getName());
        }
        String cacheKey = this.getMarkupCacheKeyProvider(container).getCacheKey(container, containerClass);
        Markup markup2 = markup = !enforceReload ? this.getMarkupFromCache(cacheKey, container) : null;
        if (markup == null) {
            IResourceStream resourceStream;
            if (log.isDebugEnabled()) {
                log.debug("Load markup: cacheKey=" + cacheKey);
            }
            if ((resourceStream = this.getMarkupResourceStreamProvider(container).getMarkupResourceStream(container, containerClass)) != null) {
                MarkupResourceStream markupResourceStream = resourceStream instanceof MarkupResourceStream ? (MarkupResourceStream)resourceStream : new MarkupResourceStream(resourceStream, new ContainerInfo(container), containerClass);
                markupResourceStream.setCacheKey(cacheKey);
                markup = this.loadMarkupAndWatchForChanges(container, markupResourceStream, enforceReload);
            } else {
                markup = this.onMarkupNotFound(cacheKey, container);
            }
        }
        return markup;
    }

    protected Markup onMarkupNotFound(String cacheKey, MarkupContainer container) {
        if (log.isDebugEnabled()) {
            log.debug("Markup not found: " + cacheKey);
        }
        this.markupKeyCache.put(cacheKey, cacheKey);
        return this.putIntoCache(cacheKey, container, Markup.NO_MARKUP);
    }

    @Deprecated
    protected Markup putIntoCache(String locationString, Markup markup) {
        if (locationString != null) {
            if (!this.markupCache.containsKey(locationString)) {
                this.markupCache.put(locationString, markup);
            } else {
                markup = this.markupCache.get(locationString);
            }
        }
        return markup;
    }

    protected Markup putIntoCache(String locationString, MarkupContainer container, Markup markup) {
        return this.putIntoCache(locationString, markup);
    }

    protected Markup getMarkupFromCache(CharSequence cacheKey, MarkupContainer container) {
        String locationString;
        if (cacheKey != null && (locationString = (String)this.markupKeyCache.get(cacheKey)) != null) {
            return this.markupCache.get(locationString);
        }
        return null;
    }

    private final Markup loadMarkup(MarkupContainer container, MarkupResourceStream markupResourceStream, boolean enforceReload) {
        String cacheKey = markupResourceStream.getCacheKey();
        String locationString = markupResourceStream.locationAsString();
        if (locationString == null) {
            locationString = cacheKey;
        }
        try {
            Markup markup = this.getMarkupLoader().loadMarkup(container, markupResourceStream, null, enforceReload);
            if (cacheKey != null) {
                String temp = markup.locationAsString();
                if (temp != null) {
                    locationString = temp;
                }
                this.markupKeyCache.put(cacheKey, locationString);
                return this.putIntoCache(locationString, container, markup);
            }
            return markup;
        }
        catch (ResourceStreamNotFoundException e) {
            log.error("Unable to find markup from " + markupResourceStream, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to read markup from " + markupResourceStream, (Throwable)e);
        }
        if (cacheKey != null) {
            this.removeMarkup(cacheKey);
        }
        return Markup.NO_MARKUP;
    }

    private final Markup loadMarkupAndWatchForChanges(MarkupContainer container, final MarkupResourceStream markupResourceStream, boolean enforceReload) {
        final String cacheKey = markupResourceStream.getCacheKey();
        if (cacheKey != null) {
            Markup markup;
            String locationString = markupResourceStream.locationAsString();
            if (locationString == null) {
                locationString = cacheKey;
            }
            if ((markup = this.markupCache.get(locationString)) != null) {
                this.markupKeyCache.put(cacheKey, locationString);
                return markup;
            }
            final IModificationWatcher watcher = Application.get().getResourceSettings().getResourceWatcher(true);
            if (watcher != null) {
                watcher.add(markupResourceStream, new IChangeListener(){

                    public void onChange() {
                        if (log.isDebugEnabled()) {
                            log.debug("Remove markup from cache: " + markupResourceStream);
                        }
                        watcher.remove(markupResourceStream);
                        MarkupCache.this.removeMarkup(cacheKey);
                    }
                });
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading markup from " + markupResourceStream);
        }
        return this.loadMarkup(container, markupResourceStream, enforceReload);
    }

    public IMarkupCacheKeyProvider getMarkupCacheKeyProvider(MarkupContainer container) {
        if (container instanceof IMarkupCacheKeyProvider) {
            return (IMarkupCacheKeyProvider)((Object)container);
        }
        if (this.markupCacheKeyProvider == null) {
            this.markupCacheKeyProvider = new DefaultMarkupCacheKeyProvider();
        }
        return this.markupCacheKeyProvider;
    }

    protected IMarkupResourceStreamProvider getMarkupResourceStreamProvider(MarkupContainer container) {
        if (container instanceof IMarkupResourceStreamProvider) {
            return (IMarkupResourceStreamProvider)((Object)container);
        }
        if (this.markupResourceStreamProvider == null) {
            this.markupResourceStreamProvider = new DefaultMarkupResourceStreamProvider();
        }
        return this.markupResourceStreamProvider;
    }

    protected IMarkupLoader getMarkupLoader() {
        if (this.markupLoader == null) {
            this.markupLoader = new DefaultMarkupLoader();
        }
        return this.markupLoader;
    }

    protected <K, V> ICache<K, V> newCacheImplementation() {
        return new DefaultCacheImplementation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultCacheImplementation<K, V>
    implements ICache<K, V> {
        private static final long serialVersionUID = 1L;
        private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.cache.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                return null;
            }
            return this.cache.get(key);
        }

        @Override
        public Collection<K> getKeys() {
            return this.cache.keySet();
        }

        @Override
        public void put(K key, V value) {
            this.cache.put(key, value);
        }

        @Override
        public boolean remove(K key) {
            return this.cache.remove(key) == null;
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void shutdown() {
            this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICache<K, V> {
        public void clear();

        public boolean remove(K var1);

        public V get(K var1);

        public Collection<K> getKeys();

        public boolean containsKey(K var1);

        public int size();

        public void put(K var1, V var2);

        public void shutdown();
    }
}

