/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxFormSubmitBehavior
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private Form<?> __form;

    public AjaxFormSubmitBehavior(String event) {
        this(null, event);
    }

    public AjaxFormSubmitBehavior(Form<?> form, String event) {
        super(event);
        this.__form = form;
        if (form != null) {
            form.setOutputMarkupId(true);
        }
    }

    public final Form<?> getForm() {
        if (this.__form == null) {
            this.__form = this.findForm();
            if (this.__form == null) {
                throw new IllegalStateException("form was not specified in the constructor and cannot be found in the hierarchy of the component this behavior is attached to");
            }
        }
        return this.__form;
    }

    protected Form<?> findForm() {
        Component component = this.getComponent();
        return component.findParent(Form.class);
    }

    @Override
    protected CharSequence getEventHandler() {
        String formId = this.getForm().getMarkupId();
        CharSequence url = this.getCallbackUrl();
        AppendingStringBuffer call = new AppendingStringBuffer("wicketSubmitFormById('").append(formId).append("', '").append(url).append("', ");
        if (this.getComponent() instanceof IFormSubmittingComponent) {
            call.append("'").append(((IFormSubmittingComponent)((Object)this.getComponent())).getInputName()).append("' ");
        } else {
            call.append("null");
        }
        return this.generateCallbackScript(call) + ";";
    }

    @Override
    protected void onEvent(AjaxRequestTarget target) {
        this.getForm().getRootForm().onFormSubmitted();
        if (!this.getForm().isSubmitted()) {
            return;
        }
        if (!this.getForm().hasError()) {
            this.onSubmit(target);
        }
        if (this.getForm().findParent(Page.class) != null && this.getForm().hasError()) {
            this.onError(target);
        }
    }

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected abstract void onError(AjaxRequestTarget var1);

    @Override
    protected CharSequence getPreconditionScript() {
        return "return Wicket.$$(this)&&Wicket.$$('" + this.getForm().getMarkupId() + "')";
    }
}

