/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxFormComponentUpdatingBehavior
extends AjaxEventBehavior {
    private static final Logger log = LoggerFactory.getLogger(AjaxFormComponentUpdatingBehavior.class);
    private static final long serialVersionUID = 1L;

    public AjaxFormComponentUpdatingBehavior(String event) {
        super(event);
    }

    @Override
    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof FormComponent)) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a FormComponent");
        }
        if (Application.get().getConfigurationType().equals("development") && AjaxFormChoiceComponentUpdatingBehavior.appliesTo(this.getComponent())) {
            log.warn(String.format("AjaxFormComponentUpdatingBehavior is not suposed to be added in the form component at path: \"%s\". Use the AjaxFormChoiceComponentUpdatingBehavior instead, that is meant for choices/groups that are not one component in the html but many", this.getComponent().getPageRelativePath()));
        }
    }

    protected final FormComponent<?> getFormComponent() {
        return (FormComponent)this.getComponent();
    }

    @Override
    protected final CharSequence getEventHandler() {
        return this.generateCallbackScript(new AppendingStringBuffer("wicketAjaxPost('").append(this.getCallbackUrl(false)).append("', wicketSerialize(Wicket.$('" + this.getComponent().getMarkupId() + "'))"));
    }

    @Override
    protected void onCheckEvent(String event) {
        if ("href".equalsIgnoreCase(event)) {
            throw new IllegalArgumentException("this behavior cannot be attached to an 'href' event");
        }
    }

    @Override
    protected final void onEvent(AjaxRequestTarget target) {
        FormComponent<?> formComponent = this.getFormComponent();
        if (this.getEvent().toLowerCase().equals("onblur") && this.disableFocusOnBlur()) {
            target.focusComponent(null);
        }
        try {
            formComponent.inputChanged();
            formComponent.validate();
            if (formComponent.hasErrorMessage()) {
                formComponent.invalid();
                this.onError(target, null);
            } else {
                formComponent.valid();
                if (this.getUpdateModel()) {
                    formComponent.updateModel();
                }
                this.onUpdate(target);
            }
        }
        catch (RuntimeException e) {
            this.onError(target, e);
        }
    }

    protected boolean getUpdateModel() {
        return true;
    }

    protected boolean disableFocusOnBlur() {
        return true;
    }

    protected abstract void onUpdate(AjaxRequestTarget var1);

    protected void onError(AjaxRequestTarget target, RuntimeException e) {
        if (e != null) {
            throw e;
        }
    }
}

