/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxRequestTarget
implements IPageRequestTarget {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxRequestTarget.class);
    private final List<String> appendJavascripts = new ArrayList<String>();
    private final List<String> domReadyJavascripts = new ArrayList<String>();
    private final AjaxResponse encodingBodyResponse;
    private final AjaxResponse encodingHeaderResponse;
    private final Map<String, Component> markupIdToComponent = new LinkedHashMap<String, Component>();
    private final List<String> prependJavascripts = new ArrayList<String>();
    private List<IListener> listeners = null;
    private final Page page;
    private final Set<ITargetRespondListener> respondListeners = new HashSet<ITargetRespondListener>();
    private boolean headerRendering = false;
    private HtmlHeaderContainer header = null;
    private IHeaderResponse headerResponse;

    @Override
    public Page getPage() {
        return this.page;
    }

    public AjaxRequestTarget(Page page) {
        this.page = page;
        Response response = RequestCycle.get().getResponse();
        this.encodingBodyResponse = new AjaxResponse(response);
        this.encodingHeaderResponse = new AjaxResponse(response);
    }

    public void addListener(IListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument `listener` cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new LinkedList<IListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void addChildren(MarkupContainer parent, Class<?> childCriteria) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument `parent` cannot be null");
        }
        if (childCriteria == null) {
            throw new IllegalArgumentException("Argument `childCriteria` cannot be null. If you want to traverse all components use `" + Component.class.getName() + ".class` as the value for this argument");
        }
        parent.visitChildren(childCriteria, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                AjaxRequestTarget.this.addComponent(component);
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    public void addComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (!component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        this.addComponent(component, component.getMarkupId());
    }

    public final void addComponent(Component component, String markupId) {
        if (Strings.isEmpty(markupId)) {
            throw new IllegalArgumentException("markupId cannot be empty");
        }
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (component instanceof Page) {
            if (component != this.page) {
                throw new IllegalArgumentException("component cannot be a page");
            }
        } else if (component instanceof AbstractRepeater) {
            throw new IllegalArgumentException("Component " + component.getClass().getName() + " has been added to the target. This component is a repeater and cannot be repainted via ajax directly. Instead add its parent or another markup container higher in the hierarchy.");
        }
        component.setMarkupId(markupId);
        this.markupIdToComponent.put(markupId, component);
    }

    public final Collection<? extends Component> getComponents() {
        return Collections.unmodifiableCollection(this.markupIdToComponent.values());
    }

    @Deprecated
    public final void addJavascript(String javascript) {
        this.appendJavascript(javascript);
    }

    public final void focusComponent(Component component) {
        if (component != null && !component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        String id = component != null ? "'" + component.getMarkupId() + "'" : "null";
        this.appendJavascript("Wicket.Focus.setFocusOnId(" + id + ");");
    }

    public final void appendJavascript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        this.appendJavascripts.add(javascript);
    }

    @Override
    public void detach(RequestCycle requestCycle) {
        Component component;
        Page page;
        if (this.markupIdToComponent.size() > 0 && (page = (component = this.markupIdToComponent.values().iterator().next()).findParent(Page.class)) != null) {
            page.detach();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AjaxRequestTarget) {
            AjaxRequestTarget that = (AjaxRequestTarget)obj;
            return ((Object)this.markupIdToComponent).equals(that.markupIdToComponent) && ((Object)this.prependJavascripts).equals(that.prependJavascripts) && ((Object)this.appendJavascripts).equals(that.appendJavascripts);
        }
        return false;
    }

    public int hashCode() {
        int result = "AjaxRequestTarget".hashCode();
        result += ((Object)this.markupIdToComponent).hashCode() * 17;
        result += ((Object)this.prependJavascripts).hashCode() * 17;
        return result += ((Object)this.appendJavascripts).hashCode() * 17;
    }

    public final void prependJavascript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        this.prependJavascripts.add(javascript);
    }

    public void registerRespondListener(ITargetRespondListener listener) {
        this.respondListeners.add(listener);
    }

    @Override
    public final void respond(RequestCycle requestCycle) {
        WebResponse response = (WebResponse)requestCycle.getResponse();
        if (this.markupIdToComponent.values().contains(this.page)) {
            String url = ((Object)requestCycle.urlFor(this.page)).toString();
            response.redirect(url);
            return;
        }
        for (ITargetRespondListener listener : this.respondListeners) {
            listener.onTargetRespond(this);
        }
        Application app = Application.get();
        String encoding = app.getRequestCycleSettings().getResponseRequestEncoding();
        response.setCharacterEncoding(encoding);
        response.setContentType("text/xml; charset=" + encoding);
        response.setHeader("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.write("<?xml version=\"1.0\" encoding=\"");
        response.write(encoding);
        response.write("\"?>");
        response.write("<ajax-response>");
        this.fireOnBeforeRespondListeners();
        for (String js : this.prependJavascripts) {
            this.respondInvocation(response, js);
        }
        this.respondComponents(response);
        this.fireOnAfterRespondListeners(response);
        for (String js : this.domReadyJavascripts) {
            this.respondInvocation(response, js);
        }
        for (String js : this.appendJavascripts) {
            this.respondInvocation(response, js);
        }
        response.write("</ajax-response>");
    }

    private void fireOnBeforeRespondListeners() {
        if (this.listeners != null) {
            Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
            Iterator<IListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().onBeforeRespond(components, this);
            }
        }
    }

    private void fireOnAfterRespondListeners(final WebResponse response) {
        if (this.listeners != null) {
            Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
            IJavascriptResponse jsresponse = new IJavascriptResponse(){

                public void addJavascript(String script) {
                    AjaxRequestTarget.this.respondInvocation(response, script);
                }
            };
            Iterator<IListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().onAfterRespond(components, jsresponse);
            }
        }
    }

    private void respondComponents(WebResponse response) {
        for (Map.Entry<String, Component> entry : this.markupIdToComponent.entrySet()) {
            Component component = entry.getValue();
            String markupId = entry.getKey();
            if (this.containsAncestorFor(component)) continue;
            this.respondComponent(response, component.getAjaxRegionMarkupId(), component);
        }
        if (this.header != null) {
            this.headerRendering = true;
            Response oldResponse = RequestCycle.get().setResponse(this.encodingHeaderResponse);
            this.encodingHeaderResponse.reset();
            this.header.getHeaderResponse().close();
            RequestCycle.get().setResponse(oldResponse);
            this.writeHeaderContribution(response);
            this.headerRendering = false;
        }
    }

    private void writeHeaderContribution(Response response) {
        if (this.encodingHeaderResponse.getContents().length() != 0) {
            response.write("<header-contribution");
            if (this.encodingHeaderResponse.isContentsEncoded()) {
                response.write(" encoding=\"");
                response.write(this.getEncodingName());
                response.write("\" ");
            }
            response.write("><![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encodingHeaderResponse.getContents());
            response.write("</head>]]>");
            response.write("</header-contribution>");
        }
    }

    private boolean containsAncestorFor(Component component) {
        for (MarkupContainer cursor = component.getParent(); cursor != null; cursor = cursor.getParent()) {
            if (!this.markupIdToComponent.containsValue(cursor)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[AjaxRequestTarget@" + this.hashCode() + " markupIdToComponent [" + this.markupIdToComponent + "], prependJavascript [" + this.prependJavascripts + "], appendJavascript [" + this.appendJavascripts + "]";
    }

    protected String encode(String str) {
        if (str == null) {
            return null;
        }
        return ((Object)Strings.replaceAll(str, "]", "]^")).toString();
    }

    protected String getEncodingName() {
        return "wicket1";
    }

    protected boolean needsEncoding(String str) {
        return str.indexOf(93) >= 0;
    }

    private void respondComponent(Response response, String markupId, Component component) {
        if (component.getRenderBodyOnly()) {
            throw new IllegalStateException("Ajax render cannot be called on component that has setRenderBodyOnly enabled. Component: " + component.toString());
        }
        component.setOutputMarkupId(true);
        Response originalResponse = response;
        this.encodingBodyResponse.reset();
        RequestCycle.get().setResponse(this.encodingBodyResponse);
        Page page = component.findParent(Page.class);
        if (page == null) {
            LOG.debug("component: " + component + " with markupid: " + markupId + " not rendered because it was already removed from page");
            return;
        }
        page.startComponentRender(component);
        try {
            component.prepareForRender();
            this.respondHeaderContribution(response, component);
        }
        catch (RuntimeException e) {
            try {
                component.afterRender();
            }
            catch (RuntimeException e2) {
                // empty catch block
            }
            RequestCycle.get().setResponse(originalResponse);
            this.encodingBodyResponse.reset();
            throw e;
        }
        try {
            component.renderComponent();
        }
        catch (RuntimeException e) {
            RequestCycle.get().setResponse(originalResponse);
            this.encodingBodyResponse.reset();
            throw e;
        }
        page.endComponentRender(component);
        RequestCycle.get().setResponse(originalResponse);
        response.write("<component id=\"");
        response.write(markupId);
        response.write("\" ");
        if (this.encodingBodyResponse.isContentsEncoded()) {
            response.write(" encoding=\"");
            response.write(this.getEncodingName());
            response.write("\" ");
        }
        response.write("><![CDATA[");
        response.write(this.encodingBodyResponse.getContents());
        response.write("]]></component>");
        this.encodingBodyResponse.reset();
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = new AjaxHeaderResponse();
        }
        return this.headerResponse;
    }

    private void respondHeaderContribution(Response response, Component component) {
        this.headerRendering = true;
        if (this.header == null) {
            this.header = new AjaxHtmlHeaderContainer("_header_", this);
            Page page = component.getPage();
            page.addOrReplace(this.header);
        }
        Response oldResponse = RequestCycle.get().setResponse(this.encodingHeaderResponse);
        this.encodingHeaderResponse.reset();
        component.renderHead(this.header);
        if (component instanceof MarkupContainer) {
            ((MarkupContainer)component).visitChildren(new Component.IVisitor<Component>(){

                @Override
                public Object component(Component component) {
                    if (component.isVisibleInHierarchy()) {
                        component.renderHead(AjaxRequestTarget.this.header);
                        return CONTINUE_TRAVERSAL;
                    }
                    return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
            });
        }
        RequestCycle.get().setResponse(oldResponse);
        this.writeHeaderContribution(response);
        this.headerRendering = false;
    }

    private void respondInvocation(Response response, String js) {
        boolean encoded = false;
        String javascript = js;
        if (this.needsEncoding(js)) {
            encoded = true;
            javascript = this.encode(js);
        }
        response.write("<evaluate");
        if (encoded) {
            response.write(" encoding=\"");
            response.write(this.getEncodingName());
            response.write("\"");
        }
        response.write(">");
        response.write("<![CDATA[");
        response.write(javascript);
        response.write("]]>");
        response.write("</evaluate>");
        this.encodingBodyResponse.reset();
    }

    public static AjaxRequestTarget get() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null && requestCycle.getRequestTarget() instanceof AjaxRequestTarget) {
            return (AjaxRequestTarget)requestCycle.getRequestTarget();
        }
        return null;
    }

    public String getLastFocusedElementId() {
        String id = ((WebRequestCycle)RequestCycle.get()).getWebRequest().getHttpServletRequest().getHeader("Wicket-FocusedElementId");
        return Strings.isEmpty(id) ? null : id;
    }

    private static class AjaxHtmlHeaderContainer
    extends HtmlHeaderContainer {
        private static final long serialVersionUID = 1L;
        private final transient AjaxRequestTarget target;

        public AjaxHtmlHeaderContainer(String id, AjaxRequestTarget target) {
            super(id);
            this.target = target;
        }

        protected IHeaderResponse newHeaderResponse() {
            return this.target.getHeaderResponse();
        }
    }

    private class AjaxHeaderResponse
    extends HeaderResponse {
        private static final long serialVersionUID = 1L;

        private boolean checkHeaderRendering() {
            if (!AjaxRequestTarget.this.headerRendering) {
                LOG.debug("Only methods that can be called on IHeaderResponse outside renderHead() are renderOnLoadJavascript and renderOnDomReadyJavascript");
            }
            return AjaxRequestTarget.this.headerRendering;
        }

        public void renderCSSReference(ResourceReference reference, String media) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(reference, media);
            }
        }

        public void renderCSSReference(String url) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(url);
            }
        }

        public void renderCSSReference(String url, String media) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(url, media);
            }
        }

        public void renderJavascript(CharSequence javascript, String id) {
            if (this.checkHeaderRendering()) {
                super.renderJavascript(javascript, id);
            }
        }

        public void renderCSSReference(ResourceReference reference) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(reference);
            }
        }

        public void renderJavascriptReference(ResourceReference reference) {
            if (this.checkHeaderRendering()) {
                super.renderJavascriptReference(reference);
            }
        }

        public void renderJavascriptReference(ResourceReference reference, String id) {
            if (this.checkHeaderRendering()) {
                super.renderJavascriptReference(reference, id);
            }
        }

        public void renderJavascriptReference(String url) {
            if (this.checkHeaderRendering()) {
                super.renderJavascriptReference(url);
            }
        }

        public void renderJavascriptReference(String url, String id) {
            if (this.checkHeaderRendering()) {
                super.renderJavascriptReference(url, id);
            }
        }

        public void renderString(CharSequence string) {
            if (this.checkHeaderRendering()) {
                super.renderString(string);
            }
        }

        public void renderOnDomReadyJavascript(String javascript) {
            List<String> token = Arrays.asList("javascript-event", "window", "domready", javascript);
            if (!this.wasRendered(token)) {
                AjaxRequestTarget.this.domReadyJavascripts.add(javascript);
                this.markRendered(token);
            }
        }

        public void renderOnLoadJavascript(String javascript) {
            List<String> token = Arrays.asList("javascript-event", "window", "load", javascript);
            if (!this.wasRendered(token)) {
                AjaxRequestTarget.this.appendJavascripts.add(javascript);
                this.markRendered(token);
            }
        }

        protected Response getRealResponse() {
            return RequestCycle.get().getResponse();
        }
    }

    public static interface ITargetRespondListener {
        public void onTargetRespond(AjaxRequestTarget var1);
    }

    private final class AjaxResponse
    extends WebResponse {
        private final AppendingStringBuffer buffer;
        private boolean escaped;
        private final Response originalResponse;

        public AjaxResponse(Response originalResponse) {
            super(((WebResponse)originalResponse).getHttpServletResponse());
            this.buffer = new AppendingStringBuffer(256);
            this.escaped = false;
            this.originalResponse = originalResponse;
            this.setAjax(true);
        }

        public CharSequence encodeURL(CharSequence url) {
            return this.originalResponse.encodeURL(url);
        }

        public CharSequence getContents() {
            return this.buffer;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("Cannot get output stream on StringResponse");
        }

        public boolean isContentsEncoded() {
            return this.escaped;
        }

        public void reset() {
            this.buffer.clear();
            this.escaped = false;
        }

        public void write(CharSequence cs) {
            String string = ((Object)cs).toString();
            if (AjaxRequestTarget.this.needsEncoding(string)) {
                string = AjaxRequestTarget.this.encode(string);
                this.escaped = true;
                this.buffer.append(string);
            } else {
                this.buffer.append(cs);
            }
        }
    }

    public static interface IJavascriptResponse {
        public void addJavascript(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IListener {
        public void onBeforeRespond(Map<String, Component> var1, AjaxRequestTarget var2);

        public void onAfterRespond(Map<String, Component> var1, IJavascriptResponse var2);
    }
}

