/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Resource;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedResources {
    private static final Logger log = LoggerFactory.getLogger(SharedResources.class);
    private final Map<Class<?>, String> classAliasMap = new WeakHashMap();
    private final Map<String, WeakReference<Class<?>>> aliasClassMap = new HashMap();
    private final ConcurrentHashMap<String, Resource> resourceMap = new ConcurrentHashMap();
    private boolean throwExceptionIfNotMapped = false;

    public static String resourceKey(String path, Locale locale, String style) {
        boolean parentEscape;
        CharSequence parentEscapeSequence = Application.get().getResourceSettings().getParentFolderPlaceholder();
        String extension = Files.extension(path);
        String basePath = Files.basePath(path, extension);
        boolean bl = parentEscape = !Strings.isEmpty(parentEscapeSequence);
        if (!parentEscape && "development".equals(Application.get().getConfigurationType()) && basePath.contains("../")) {
            log.error("----------------------------------------------------------------------------------------");
            log.error("Your path looks like: " + path);
            log.error("For security reasons moving up '../' is disabled by default. Please see");
            log.error("IResourceSettings.getParentFolderPlaceholder() and PackageResourceGuard for more details");
            log.error("----------------------------------------------------------------------------------------");
        }
        if (parentEscape) {
            basePath = basePath.replace("../", parentEscapeSequence + "/");
        }
        AppendingStringBuffer buffer = new AppendingStringBuffer(basePath.length() + 16);
        buffer.append(basePath);
        if (style != null) {
            buffer.append('_');
            buffer.append(style);
        }
        if (locale != null) {
            buffer.append('_');
            boolean l = locale.getLanguage().length() != 0;
            boolean c = locale.getCountry().length() != 0;
            boolean v = locale.getVariant().length() != 0;
            buffer.append(locale.getLanguage());
            if (c || l && v) {
                buffer.append('_').append(locale.getCountry());
            }
            if (v && (l || c)) {
                buffer.append('_').append(locale.getVariant());
            }
        }
        if (extension != null) {
            buffer.append('.');
            buffer.append(extension);
        }
        return buffer.toString();
    }

    SharedResources() {
    }

    public final void add(Class<?> scope, String name, Locale locale, String style, Resource resource) {
        String key = this.resourceKey(scope, name, locale, style);
        if (this.resourceMap.putIfAbsent(key, resource) == null && log.isDebugEnabled()) {
            log.debug("added shared resource " + key);
        }
    }

    public final void add(String name, Locale locale, Resource resource) {
        this.add(Application.class, name, locale, null, resource);
    }

    public final void add(String name, Resource resource) {
        this.add(Application.class, name, null, null, resource);
    }

    public final Resource get(Class<?> scope, String name, Locale locale, String style, boolean exact) {
        String key;
        String resourceKey;
        Resource resource;
        if (exact) {
            String resourceKey2 = this.resourceKey(scope, name, locale, style);
            return this.get(resourceKey2);
        }
        if (locale != null && style != null && (resource = this.get(resourceKey = this.resourceKey(scope, name, locale, style))) != null) {
            return resource;
        }
        if (locale != null && (resource = this.get(key = this.resourceKey(scope, name, locale, null))) != null) {
            return resource;
        }
        if (style != null && (resource = this.get(key = this.resourceKey(scope, name, null, style))) != null) {
            return resource;
        }
        key = this.resourceKey(scope, name, null, null);
        return this.get(key);
    }

    public final Resource get(String key) {
        return this.resourceMap.get(key);
    }

    public final void putClassAlias(Class<?> clz, String alias) {
        this.classAliasMap.put(clz, alias);
        this.aliasClassMap.put(alias, new WeakReference(clz));
    }

    public final Class<?> getAliasClass(String alias) {
        WeakReference<Class<?>> classRef = this.aliasClassMap.get(alias);
        if (classRef == null) {
            return null;
        }
        return (Class)classRef.get();
    }

    public final void remove(String key) {
        this.resourceMap.remove(key);
    }

    public String resourceKey(Class<?> scope, String path, Locale locale, String style) {
        String alias = this.classAliasMap.get(scope);
        if (alias == null) {
            if (this.isThrowExceptionIfNotMapped()) {
                throw new WicketRuntimeException("FQN will be exposed in the URL. See Application.get().getSharedResources().putClassAlias(): class: " + scope.getName());
            }
            alias = scope.getName();
        }
        return alias + '/' + SharedResources.resourceKey(path, locale, style);
    }

    public boolean isThrowExceptionIfNotMapped() {
        return this.throwExceptionIfNotMapped;
    }

    public void setThrowExceptionIfNotMapped(boolean throwExceptionIfNotMapped) {
        this.throwExceptionIfNotMapped = throwExceptionIfNotMapped;
    }
}

