/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.IPageMap;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.protocol.http.IgnoreAjaxRequestException;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session
implements IClusterable {
    private int sequence = 1;
    public static final MetaDataKey<PageMapAccessMetaData> PAGEMAP_ACCESS_MDK = new MetaDataKey<PageMapAccessMetaData>(){
        private static final long serialVersionUID = 1L;
    };
    public static final String SESSION_ATTRIBUTE_NAME = "session";
    private static final ThreadLocal<Session> current = new ThreadLocal();
    private static final ThreadLocal<List<IClusterable>> dirtyObjects = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private static final String pageMapAttributePrefix = "m:";
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<List<Page>> touchedPages = new ThreadLocal();
    static final String pageMapEntryAttributePrefix = "p:";
    private int pageIdCounter = 0;
    private int autoCreatePageMapCounter = 0;
    private ClientInfo clientInfo;
    private transient boolean dirty = false;
    private final FeedbackMessages feedbackMessages = new FeedbackMessages();
    private String id = null;
    private Locale locale;
    private MetaDataEntry<?>[] metaData;
    private transient Map<IPageMap, PageMapsUsedInRequestEntry> pageMapsUsedInRequest;
    private transient boolean sessionInvalidated = false;
    private transient ISessionStore sessionStore;
    private String style;
    private transient Map<String, Object> temporarySessionAttributes;
    private final LinkedList<String> usedPageMapNames = new LinkedList();

    public static boolean exists() {
        return current.get() != null;
    }

    public static final Session findOrCreate() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("you can only locate or create sessions in the context of a request cycle");
        }
        Response response = requestCycle.getResponse();
        Request request = requestCycle.getRequest();
        return Session.findOrCreate(request, response);
    }

    public static Session findOrCreate(Request request, Response response) {
        Application application = Application.get();
        ISessionStore sessionStore = application.getSessionStore();
        Session session = sessionStore.lookup(request);
        if (session == null) {
            session = application.newSession(request, response);
            dirtyObjects.set(null);
            touchedPages.set(null);
        }
        Session.set(session);
        return session;
    }

    public static Session get() {
        Session session = current.get();
        if (session == null) {
            session = Session.findOrCreate();
        }
        return session;
    }

    public static void set(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument session can not be null");
        }
        current.set(session);
        try {
            session.attach();
        }
        catch (RuntimeException e) {
            current.set(null);
        }
    }

    public static void unset() {
        current.set(null);
    }

    public Session(Request request) {
        this.locale = request.getLocale();
        if (this.locale == null) {
            throw new IllegalStateException("Request#getLocale() cannot return null, request has to have a locale set on it");
        }
    }

    @Deprecated
    protected Session(Application application, Request request) {
        this(request);
    }

    public final void bind() {
        Request request;
        if (RequestCycle.get() == null) {
            return;
        }
        ISessionStore store = this.getSessionStore();
        if (store.lookup(request = RequestCycle.get().getRequest()) == null) {
            this.id = store.getSessionId(request, true);
            store.bind(request, this);
            if (this.temporarySessionAttributes != null) {
                for (Map.Entry<String, Object> entry : this.temporarySessionAttributes.entrySet()) {
                    store.setAttribute(request, String.valueOf(entry.getKey()), entry.getValue());
                }
                this.temporarySessionAttributes = null;
            }
        }
    }

    public abstract void cleanupFeedbackMessages();

    public final void clear() {
        this.visitPageMaps(new IPageMapVisitor(){

            public void pageMap(IPageMap pageMap) {
                pageMap.clear();
            }
        });
    }

    public final IPageMap createAutoPageMap() {
        return this.newPageMap(this.createAutoPageMapName());
    }

    protected int currentCreateAutoPageMapCounter() {
        return this.autoCreatePageMapCounter;
    }

    protected void incrementCreateAutoPageMapCounter() {
        ++this.autoCreatePageMapCounter;
    }

    public final synchronized String createAutoPageMapName() {
        String name = this.getAutoPageMapNamePrefix() + this.currentCreateAutoPageMapCounter() + this.getAutoPageMapNameSuffix();
        IPageMap pm = this.pageMapForName(name, false);
        while (pm != null) {
            this.incrementCreateAutoPageMapCounter();
            name = this.getAutoPageMapNamePrefix() + this.currentCreateAutoPageMapCounter() + this.getAutoPageMapNameSuffix();
            pm = this.pageMapForName(name, false);
        }
        return name;
    }

    protected String getAutoPageMapNamePrefix() {
        return "wicket-";
    }

    protected String getAutoPageMapNameSuffix() {
        return "";
    }

    public final void error(String message) {
        this.addFeedbackMessage(message, 400);
    }

    public final Application getApplication() {
        return Application.get();
    }

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.getApplication().getSecuritySettings().getAuthorizationStrategy();
    }

    public final IClassResolver getClassResolver() {
        return this.getApplication().getApplicationSettings().getClassResolver();
    }

    public ClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            this.clientInfo = RequestCycle.get().newClientInfo();
        }
        return this.clientInfo;
    }

    public final IPageMap getDefaultPageMap() {
        return this.pageMapForName(PageMap.DEFAULT_NAME, true);
    }

    public final FeedbackMessages getFeedbackMessages() {
        return this.feedbackMessages;
    }

    public final String getId() {
        if (this.id == null) {
            this.id = this.getSessionStore().getSessionId(RequestCycle.get().getRequest(), false);
            if (this.id != null) {
                this.dirty();
            }
        }
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final synchronized <M extends Serializable> M getMetaData(MetaDataKey<M> key) {
        return (M)((Serializable)key.get(this.metaData));
    }

    protected boolean isCurrentRequestValid(RequestCycle lockedRequestCycle) {
        return true;
    }

    public final Page getPage(int pageId, int versionNumber) {
        if (!Application.get().getSessionSettings().isPageIdUniquePerSession()) {
            throw new IllegalStateException("To call this method ISessionSettings.setPageIdUniquePerSession must be set to true");
        }
        List<IPageMap> pageMaps = this.getPageMaps();
        for (IPageMap pageMap : pageMaps) {
            if (!pageMap.containsPage(pageId, versionNumber)) continue;
            return this.getPage(pageMap.getName(), "" + pageId, versionNumber);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Page getPage(String pageMapName, String componentPath, int versionNumber) {
        IPageMap pageMap;
        if (log.isDebugEnabled()) {
            log.debug("Getting page [path = " + componentPath + ", versionNumber = " + versionNumber + "]");
        }
        if ((pageMap = this.pageMapForName(pageMapName, pageMapName == PageMap.DEFAULT_NAME)) != null) {
            Object object = this.usedPageMapNames;
            synchronized (object) {
                if (this.pageMapsUsedInRequest == null) {
                    this.pageMapsUsedInRequest = new HashMap<IPageMap, PageMapsUsedInRequestEntry>(3);
                }
            }
            object = this.pageMapsUsedInRequest;
            synchronized (object) {
                Thread t;
                long startTime = System.currentTimeMillis();
                Duration timeout = Application.get().getRequestCycleSettings().getTimeout();
                PageMapsUsedInRequestEntry entry = this.pageMapsUsedInRequest.get(pageMap);
                Thread thread = t = entry != null ? entry.thread : null;
                while (t != null && t != Thread.currentThread()) {
                    if (!this.isCurrentRequestValid(entry.requestCycle)) {
                        throw new IgnoreAjaxRequestException();
                    }
                    try {
                        this.pageMapsUsedInRequest.wait(timeout.getMilliseconds());
                    }
                    catch (InterruptedException ex) {
                        throw new WicketRuntimeException(ex);
                    }
                    entry = this.pageMapsUsedInRequest.get(pageMap);
                    t = entry != null ? entry.thread : null;
                    if (t == null || t == Thread.currentThread() || startTime + timeout.getMilliseconds() >= System.currentTimeMillis()) continue;
                    AppendingStringBuffer asb = new AppendingStringBuffer(100);
                    asb.append("After " + timeout + " the Pagemap " + pageMapName + " is still locked by: " + t + ", giving up trying to get the page for path: " + componentPath);
                    WicketRuntimeException ex = new WicketRuntimeException(asb.toString());
                    ex.setStackTrace(t.getStackTrace());
                    throw ex;
                }
                PageMapsUsedInRequestEntry newEntry = new PageMapsUsedInRequestEntry();
                newEntry.thread = Thread.currentThread();
                newEntry.requestCycle = RequestCycle.get();
                this.pageMapsUsedInRequest.put(pageMap, newEntry);
                String id = Strings.firstPathComponent(componentPath, ':');
                Page page = pageMap.get(Integer.parseInt(id), versionNumber);
                if (page == null) {
                    this.pageMapsUsedInRequest.remove(pageMap);
                    this.pageMapsUsedInRequest.notifyAll();
                } else {
                    page.onPageAttached();
                    this.touch(page);
                }
                return page;
            }
        }
        return null;
    }

    public final IPageFactory getPageFactory() {
        return this.getApplication().getSessionSettings().getPageFactory();
    }

    public final List<IPageMap> getPageMaps() {
        ArrayList<IPageMap> list = new ArrayList<IPageMap>();
        for (String attribute : this.getAttributeNames()) {
            if (!attribute.startsWith(pageMapAttributePrefix)) continue;
            list.add((IPageMap)this.getAttribute(attribute));
        }
        Iterator maps = list.iterator();
        while (maps.hasNext()) {
            if (maps.next() != null) continue;
            maps.remove();
        }
        Collections.sort(list, new LruComparator());
        return list;
    }

    public final long getSizeInBytes() {
        long size = Objects.sizeof(this);
        for (IPageMap pageMap : this.getPageMaps()) {
            size += pageMap.getSizeInBytes();
        }
        return size;
    }

    public final String getStyle() {
        return this.style;
    }

    public final void info(String message) {
        this.addFeedbackMessage(message, 200);
    }

    public void invalidate() {
        this.sessionInvalidated = true;
    }

    public void invalidateNow() {
        this.sessionInvalidated = true;
        this.getSessionStore().invalidate(RequestCycle.get().getRequest());
    }

    public void replaceSession() {
        this.getSessionStore().invalidate(RequestCycle.get().getRequest());
        this.bind();
    }

    public final boolean isSessionInvalidated() {
        return this.sessionInvalidated;
    }

    public final boolean isTemporary() {
        return this.getId() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IPageMap newPageMap(String name) {
        int maxPageMaps = this.getApplication().getSessionSettings().getMaxPageMaps();
        LinkedList<String> linkedList = this.usedPageMapNames;
        synchronized (linkedList) {
            List<IPageMap> usedPageMaps = this.getPageMaps();
            int excessPagemaps = usedPageMaps.size() + 1 - maxPageMaps;
            if (excessPagemaps > 0) {
                for (int i = 0; i < excessPagemaps; ++i) {
                    usedPageMaps.get(i).remove();
                }
            }
        }
        IPageMap pageMap = this.getSessionStore().createPageMap(name);
        this.setAttribute(Session.attributeForPageMapName(name), pageMap);
        this.dirtyPageMap(pageMap);
        this.dirty();
        return pageMap;
    }

    public final IPageMap pageMapForName(String pageMapName, boolean autoCreate) {
        IPageMap pageMap = (IPageMap)this.getAttribute(Session.attributeForPageMapName(pageMapName));
        if (pageMap == null && autoCreate) {
            pageMap = this.newPageMap(pageMapName);
        }
        return pageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePageMap(IPageMap pageMap) {
        PageMapAccessMetaData pagemapMetaData = this.getMetaData(PAGEMAP_ACCESS_MDK);
        if (pagemapMetaData != null) {
            pagemapMetaData.pageMapNames.remove(pageMap.getName());
        }
        LinkedList<String> linkedList = this.usedPageMapNames;
        synchronized (linkedList) {
            this.usedPageMapNames.remove(pageMap.getName());
        }
        this.getDirtyObjectsList().remove(pageMap);
        this.removeAttribute(Session.attributeForPageMapName(pageMap.getName()));
        this.dirty();
    }

    public final void setApplication(Application application) {
    }

    public final void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        this.dirty();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Argument 'locale' must not be null");
        }
        if (!Objects.equal(this.locale, locale)) {
            this.dirty();
        }
        this.locale = locale;
    }

    public final synchronized void setMetaData(MetaDataKey<?> key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
        this.dirty();
    }

    public final Session setStyle(String style) {
        this.style = style;
        this.dirty();
        return this;
    }

    public final void touch(Page page) {
        List<Page> lst = touchedPages.get();
        if (lst == null) {
            lst = new ArrayList<Page>();
            touchedPages.set(lst);
            lst.add(page);
        } else if (!lst.contains(page)) {
            lst.add(page);
        }
    }

    public final void untouch(Page page) {
        List<Page> lst = touchedPages.get();
        if (lst != null) {
            lst.remove(page);
        }
    }

    public final void visitPageMaps(IPageMapVisitor visitor) {
        for (String attribute : this.getAttributeNames()) {
            if (!attribute.startsWith(pageMapAttributePrefix)) continue;
            visitor.pageMap((IPageMap)this.getAttribute(attribute));
        }
    }

    public final void warn(String message) {
        this.addFeedbackMessage(message, 300);
    }

    private void addFeedbackMessage(String message, int level) {
        this.getFeedbackMessages().add(null, message, level);
        this.dirty();
    }

    private static final String attributeForPageMapName(String pageMapName) {
        return pageMapAttributePrefix + pageMapName;
    }

    @Deprecated
    protected void attach() {
    }

    protected void detach() {
        if (this.sessionInvalidated) {
            this.invalidateNow();
        }
    }

    public final void dirty() {
        this.dirty = true;
    }

    protected final Object getAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return this.getSessionStore().getAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            return this.temporarySessionAttributes.get(name);
        }
        return null;
    }

    protected final List<String> getAttributeNames() {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return this.getSessionStore().getAttributeNames(cycle.getRequest());
            }
        } else if (this.temporarySessionAttributes != null) {
            return new ArrayList<String>(this.temporarySessionAttributes.keySet());
        }
        return Collections.emptyList();
    }

    protected ISessionStore getSessionStore() {
        if (this.sessionStore == null) {
            this.sessionStore = this.getApplication().getSessionStore();
        }
        return this.sessionStore;
    }

    protected final void removeAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                this.getSessionStore().removeAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            this.temporarySessionAttributes.remove(name);
        }
    }

    protected final void setAttribute(String name, Object value) {
        if (!this.isTemporary()) {
            String id;
            Object current;
            RequestCycle cycle = RequestCycle.get();
            if (cycle == null) {
                throw new IllegalStateException("Cannot set the attribute: no RequestCycle available.  If you get this error when using WicketTester.startPage(Page), make sure to call WicketTester.createRequestCycle() beforehand.");
            }
            ISessionStore store = this.getSessionStore();
            Request request = cycle.getRequest();
            if (value == this && (current = store.getAttribute(request, name)) == null && (id = store.getSessionId(request, false)) != null) {
                store.bind(request, (Session)value);
            }
            store.setAttribute(request, name, value);
        } else {
            if (this.temporarySessionAttributes == null) {
                this.temporarySessionAttributes = new HashMap<String, Object>(3);
            }
            this.temporarySessionAttributes.put(name, value);
        }
    }

    @Deprecated
    protected final void update() {
        throw new UnsupportedOperationException();
    }

    void dirtyPage(Page page) {
        List<IClusterable> dirtyObjects = this.getDirtyObjectsList();
        if (!dirtyObjects.contains(page)) {
            dirtyObjects.add(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dirtyPageMap(IPageMap map) {
        if (!this.getPageMaps().contains(map)) {
            return;
        }
        LinkedList<String> linkedList = this.usedPageMapNames;
        synchronized (linkedList) {
            this.usedPageMapNames.remove(map.getName());
            this.usedPageMapNames.addLast(map.getName());
        }
        List<IClusterable> dirtyObjects = this.getDirtyObjectsList();
        if (!dirtyObjects.contains(map)) {
            dirtyObjects.add(map);
        }
    }

    List<IClusterable> getDirtyObjectsList() {
        List<IClusterable> list = dirtyObjects.get();
        if (list == null) {
            list = new ArrayList<IClusterable>(4);
            dirtyObjects.set(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final void requestDetached() {
        List<Page> touchedPages = Session.touchedPages.get();
        Session.touchedPages.set(null);
        if (touchedPages != null) {
            for (int i = 0; i < touchedPages.size(); ++i) {
                try {
                    Page page = touchedPages.get(i);
                    page.detach();
                    page.getPageMap().put(page);
                }
                catch (Throwable t) {
                    log.error("Exception when detaching/serializing page", t);
                }
                this.dirty = true;
            }
        }
        try {
            if (this.dirty) {
                this.dirty = false;
                this.setAttribute(SESSION_ATTRIBUTE_NAME, this);
            } else if (log.isDebugEnabled()) {
                log.debug("update: Session not dirty.");
            }
            List<IClusterable> dirtyObjects = Session.dirtyObjects.get();
            Session.dirtyObjects.set(null);
            HashMap<void, IClusterable> tempMap = new HashMap<void, IClusterable>();
            if (dirtyObjects != null) {
                Iterator<IClusterable> iterator = dirtyObjects.iterator();
                while (iterator.hasNext()) {
                    void var5_7;
                    Object var5_8 = null;
                    IClusterable object = iterator.next();
                    if (object instanceof Page) {
                        String string;
                        Page page = (Page)object;
                        if (page.isPageStateless() || this.getAttribute(string = page.getPageMap().attributeForId(page.getNumericId())) == null) continue;
                        object = page.getPageMapEntry();
                    } else if (object instanceof IPageMap) {
                        String string = Session.attributeForPageMapName(((IPageMap)object).getName());
                    }
                    tempMap.put(var5_7, object);
                }
            }
            if (!tempMap.isEmpty()) {
                for (Map.Entry entry : tempMap.entrySet()) {
                    this.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            if (this.pageMapsUsedInRequest != null) {
                Map<IPageMap, PageMapsUsedInRequestEntry> map = this.pageMapsUsedInRequest;
                synchronized (map) {
                    Thread t = Thread.currentThread();
                    Iterator<Map.Entry<IPageMap, PageMapsUsedInRequestEntry>> it = this.pageMapsUsedInRequest.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<IPageMap, PageMapsUsedInRequestEntry> entry = it.next();
                        if (entry.getValue().thread != t) continue;
                        it.remove();
                    }
                    this.pageMapsUsedInRequest.notifyAll();
                }
            }
        }
    }

    protected synchronized int nextPageId() {
        return this.pageIdCounter++;
    }

    public synchronized int nextSequenceValue() {
        return this.sequence++;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LruComparator
    implements Comparator<IPageMap> {
        private LruComparator() {
        }

        @Override
        public int compare(IPageMap pg1, IPageMap pg2) {
            Integer pg1Index = Session.this.usedPageMapNames.indexOf(pg1.getName());
            Integer pg2Index = Session.this.usedPageMapNames.indexOf(pg2.getName());
            return pg1Index.compareTo(pg2Index);
        }
    }

    private static class PageMapsUsedInRequestEntry {
        Thread thread;
        RequestCycle requestCycle;

        private PageMapsUsedInRequestEntry() {
        }
    }

    public static final class PageMapAccessMetaData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        Set<String> pageMapNames = new HashSet<String>(2);

        public boolean add(IPageMap pagemap) {
            return this.pageMapNames.add(pagemap.getName());
        }
    }

    public static interface IPageMapVisitor {
        public void pageMap(IPageMap var1);
    }
}

