/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.AbortException;
import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IComponentBorder;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.MarkupFragmentFinder;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.IAjaxRegionMarkupIdProvider;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.IComponentConfigurationBehavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IModelComparator;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Component
implements IClusterable,
IConverterLocator {
    private static final Logger log = LoggerFactory.getLogger(Component.class);
    private static final long serialVersionUID = 1L;
    public static final Action ENABLE = new Action("ENABLE");
    public static final char PATH_SEPARATOR = ':';
    public static final String PARENT_PATH = "..";
    public static final Action RENDER = new Action("RENDER");
    private static final MetaDataKey<IComponentBorder> BORDER_KEY = new MetaDataKey<IComponentBorder>(){
        private static final long serialVersionUID = 1L;
    };
    private static final MetaDataKey<String> MARKUP_ID_KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    private static final IModelComparator defaultModelComparator = new IModelComparator(){
        private static final long serialVersionUID = 1L;

        public boolean compare(Component component, Object b) {
            Object a = component.getDefaultModelObject();
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equals(b);
        }
    };
    private static final int FLAG_AUTO = 1;
    private static final int FLAG_ESCAPE_MODEL_STRINGS = 2;
    static final int FLAG_INHERITABLE_MODEL = 4;
    private static final int FLAG_VERSIONED = 8;
    private static final int FLAG_VISIBLE = 16;
    private static final int FLAG_RENDER_BODY_ONLY = 32;
    private static final int FLAG_IGNORE_ATTRIBUTE_MODIFIER = 64;
    private static final int FLAG_ENABLED = 128;
    protected static final int FLAG_RESERVED1 = 256;
    protected static final int FLAG_RESERVED2 = 512;
    protected static final int FLAG_RESERVED3 = 1024;
    protected static final int FLAG_RESERVED4 = 2048;
    private static final int FLAG_HAS_BEEN_RENDERED = 4096;
    private static final int FLAG_IS_RENDER_ALLOWED = 8192;
    private static final int FLAG_OUTPUT_MARKUP_ID = 16384;
    private static final int FLAG_PLACEHOLDER = 32768;
    protected static final int FLAG_RESERVED5 = 65536;
    protected static final int FLAG_RESERVED6 = 131072;
    protected static final int FLAG_RESERVED7 = 262144;
    protected static final int FLAG_RESERVED8 = 524288;
    private static final int FLAG_MODEL_SET = 0x100000;
    protected static final int FLAG_REMOVING_FROM_HIERARCHY = 0x200000;
    protected static final int FLAG_INITIALIZED = 0x400000;
    protected static final int FLAG_CONFIGURED = 0x800000;
    private static final int FLAG_INITIALIZE_SUPER_CALL_VERIFIED = 0x10000000;
    private static final int FLAG_BEFORE_RENDER_SUPER_CALL_VERIFIED = 0x1000000;
    private static final int FLAG_PREPARED_FOR_RENDER = 0x4000000;
    private static final int FLAG_RENDERING = 0x2000000;
    private static final int FLAG_AFTER_RENDERING = 0x8000000;
    private static final int FLAG_VISIBILITY_ALLOWED = 0x40000000;
    private static final int FLAG_ATTACHED = 0x20000000;
    private static final int FLAG_DETACHING = Integer.MIN_VALUE;
    private static final String MARKUP_ID_ATTR_NAME = "id";
    static final MetaDataKey<String> ADDED_AT_KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    static final MetaDataKey<String> CONSTRUCTED_AT_KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    private static final MetaDataKey<Boolean> ENABLED_IN_HIERARCHY_CACHE_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    private int flags = 1073750170;
    private String id;
    private MarkupContainer parent;
    int markupIndex = -1;
    int generatedMarkupId = -1;
    Object data = null;
    private static final MetaDataKey<List<Component>> FEEDBACK_LIST = new MetaDataKey<List<Component>>(){
        private static final long serialVersionUID = 1L;
    };

    private final int data_length() {
        if (this.data == null) {
            return 0;
        }
        if (this.data instanceof Object[] && !(this.data instanceof MetaDataEntry[])) {
            return ((Object[])this.data).length;
        }
        return 1;
    }

    private final Object data_get(int index) {
        if (this.data == null) {
            return null;
        }
        if (this.data instanceof Object[] && !(this.data instanceof MetaDataEntry[])) {
            Object[] array = (Object[])this.data;
            return index < array.length ? array[index] : null;
        }
        if (index == 0) {
            return this.data;
        }
        return null;
    }

    private final void data_set(int index, Object object) {
        if (index > this.data_length() - 1) {
            throw new IndexOutOfBoundsException("can not set data at " + index + " when data_length() is " + this.data_length());
        }
        if (index == 0 && (!(this.data instanceof Object[]) || this.data instanceof MetaDataEntry[])) {
            this.data = object;
        } else {
            Object[] array = (Object[])this.data;
            array[index] = object;
        }
    }

    private final void data_add(Object object) {
        this.data_insert(-1, object);
    }

    private final void data_insert(int position, Object object) {
        int currentLength = this.data_length();
        if (position == -1) {
            position = currentLength;
        }
        if (position > currentLength) {
            throw new IndexOutOfBoundsException("can not insert data at " + position + " when data_length() is " + currentLength);
        }
        if (currentLength == 0) {
            this.data = object;
        } else if (currentLength == 1) {
            Object[] array = new Object[2];
            if (position == 0) {
                array[0] = object;
                array[1] = this.data;
            } else {
                array[0] = this.data;
                array[1] = object;
            }
            this.data = array;
        } else {
            Object[] array = new Object[currentLength + 1];
            Object[] current = (Object[])this.data;
            int before = position;
            int after = currentLength - position;
            if (before > 0) {
                System.arraycopy(current, 0, array, 0, before);
            }
            array[position] = object;
            if (after > 0) {
                System.arraycopy(current, position, array, position + 1, after);
            }
            this.data = array;
        }
    }

    private final void data_remove(int position) {
        int currentLength = this.data_length();
        if (position > currentLength - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (currentLength == 1) {
            this.data = null;
        } else if (currentLength == 2) {
            Object[] current = (Object[])this.data;
            this.data = position == 0 ? current[1] : current[0];
        } else {
            Object[] current = (Object[])this.data;
            this.data = new Object[currentLength - 1];
            if (position > 0) {
                System.arraycopy(current, 0, this.data, 0, position);
            }
            if (position != currentLength - 1) {
                int left = currentLength - position - 1;
                System.arraycopy(current, position + 1, this.data, position, left);
            }
        }
    }

    public Component(String id) {
        this(id, null);
    }

    public Component(String id, IModel<?> model) {
        this.setId(id);
        this.getApplication().notifyComponentInstantiationListeners(this);
        IDebugSettings debugSettings = Application.get().getDebugSettings();
        if (debugSettings.isLinePreciseReportingOnNewComponentEnabled()) {
            this.setMetaData(CONSTRUCTED_AT_KEY, Strings.toString(this, new MarkupException("constructed")));
        }
        if (model != null) {
            this.setModelImpl(this.wrap(model));
        }
    }

    public Component add(IBehavior ... behaviors) {
        if (behaviors == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        for (IBehavior behavior : behaviors) {
            if (behavior == null) {
                throw new IllegalArgumentException("Argument may not be null");
            }
            this.addBehavior(behavior);
            if (!behavior.isTemporary()) {
                this.addStateChange(new AddedBehaviorChange(behavior));
            }
            behavior.bind(this);
        }
        return this;
    }

    private void addBehavior(IBehavior behavior) {
        this.data_add(behavior);
    }

    public final List<IBehavior> getBehaviorsRawList() {
        if (this.data != null) {
            int startIndex = this.getFlag(0x100000) ? 1 : 0;
            int length = this.data_length();
            if (length > startIndex) {
                ArrayList<IBehavior> result = new ArrayList<IBehavior>();
                for (int i = startIndex; i < length; ++i) {
                    Object o = this.data_get(i);
                    if (o != null && !(o instanceof IBehavior)) continue;
                    result.add((IBehavior)o);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterRender() {
        try {
            this.setFlag(0x8000000, true);
            this.onAfterRender();
            this.getApplication().notifyComponentOnAfterRenderListeners(this);
            if (this.getFlag(0x8000000)) {
                throw new IllegalStateException(Component.class.getName() + " has not been properly detached. Something in the hierarchy of " + this.getClass().getName() + " has not called super.onAfterRender() in the override of onAfterRender() method");
            }
            this.onAfterRenderChildren();
        }
        finally {
            this.setFlag(0x2000000, false);
        }
    }

    private final void internalBeforeRender() {
        this.configure();
        if ((this.determineVisibility() || this.callOnBeforeRenderIfNotVisible()) && !this.getFlag(0x2000000) && !this.getFlag(0x4000000)) {
            this.setFlag(0x1000000, false);
            this.getApplication().notifyPreComponentOnBeforeRenderListeners(this);
            this.clearEnabledInHierarchyCache();
            this.onBeforeRender();
            this.getApplication().notifyPostComponentOnBeforeRenderListeners(this);
            if (!this.getFlag(0x1000000)) {
                throw new IllegalStateException(Component.class.getName() + " has not been properly rendered. Something in the hierarchy of " + this.getClass().getName() + " has not called super.onBeforeRender() in the override of onBeforeRender() method");
            }
        }
    }

    public final void beforeRender() {
        if (!(this instanceof IFeedback)) {
            this.internalBeforeRender();
        } else {
            List<Component> feedbacks = this.getRequestCycle().getMetaData(FEEDBACK_LIST);
            if (feedbacks == null) {
                feedbacks = new ArrayList<Component>();
                this.getRequestCycle().setMetaData(FEEDBACK_LIST, feedbacks);
            }
            if (this instanceof MarkupContainer) {
                ((MarkupContainer)this).visitChildren(IFeedback.class, new IVisitor<Component>(){

                    @Override
                    public Object component(Component component) {
                        component.beforeRender();
                        return IVisitor.CONTINUE_TRAVERSAL;
                    }
                });
            }
            if (!feedbacks.contains(this)) {
                feedbacks.add(this);
            }
        }
    }

    public final void configure() {
        if (!this.getFlag(0x800000)) {
            this.onConfigure();
            List<IComponentConfigurationBehavior> behaviors = this.getBehaviors(IComponentConfigurationBehavior.class);
            for (IComponentConfigurationBehavior behavior : behaviors) {
                if (!this.isBehaviorAccepted(behavior)) continue;
                behavior.onConfigure(this);
            }
            this.setFlag(0x800000, true);
        }
    }

    public final boolean continueToOriginalDestination() {
        return this.getPage().getPageMap().continueToOriginalDestination();
    }

    public final void debug(String message) {
        Session.get().getFeedbackMessages().debug(this, message);
        Session.get().dirty();
    }

    final void internalOnRemove() {
        this.setFlag(0x200000, true);
        this.onRemove();
        if (this.getFlag(0x200000)) {
            throw new IllegalStateException(Component.class.getName() + " has not been properly removed from hierachy. Something in the hierarchy of " + this.getClass().getName() + " has not called super.onRemovalFromHierarchy() in the override of onRemovalFromHierarchy() method");
        }
        this.removeChildren();
    }

    public final void detach() {
        this.setFlag(Integer.MIN_VALUE, true);
        this.onDetach();
        if (this.getFlag(Integer.MIN_VALUE)) {
            throw new IllegalStateException(Component.class.getName() + " has not been properly detached. Something in the hierarchy of " + this.getClass().getName() + " has not called super.onDetach() in the override of onDetach() method");
        }
        this.setFlag(0x20000000, false);
        this.setFlag(0x800000, false);
        this.detachModels();
        this.detachBehaviors();
        this.detachChildren();
        if (this.getFlag(4)) {
            this.setModelImpl(null);
            this.setFlag(4, false);
        }
        this.clearEnabledInHierarchyCache();
        IDetachListener detachListener = this.getApplication().getFrameworkSettings().getDetachListener();
        if (detachListener != null) {
            detachListener.onDetach(this);
        }
    }

    public final void detachBehaviors() {
        for (IBehavior behavior : this.getBehaviors()) {
            behavior.detach(this);
            if (!behavior.isTemporary()) continue;
            this.removeBehavior(behavior);
        }
    }

    public void detachModels() {
        this.detachModel();
    }

    public final void error(Serializable message) {
        Session.get().getFeedbackMessages().error(this, message);
        Session.get().dirty();
    }

    public final void fatal(String message) {
        Session.get().getFeedbackMessages().fatal(this, message);
        Session.get().dirty();
    }

    public final <Z> Z findParent(Class<Z> c) {
        for (MarkupContainer current = this.parent; current != null; current = current.getParent()) {
            if (!c.isInstance(current)) continue;
            return c.cast(current);
        }
        return null;
    }

    public final MarkupContainer findParentWithAssociatedMarkup() {
        for (MarkupContainer container = this.parent; container != null; container = container.getParent()) {
            if (!container.hasAssociatedMarkup()) continue;
            return container;
        }
        throw new WicketRuntimeException("Unable to find parent with associated markup");
    }

    public final Application getApplication() {
        return Application.get();
    }

    public final List<IBehavior> getBehaviors() {
        return this.getBehaviors(IBehavior.class);
    }

    public final String getClassRelativePath() {
        return this.getClass().getName() + ':' + this.getPageRelativePath();
    }

    @Deprecated
    public final IComponentBorder getComponentBorder() {
        return this.getMetaData(BORDER_KEY);
    }

    @Deprecated
    public final IConverter getConverter() {
        throw new UnsupportedOperationException("use #getConverter(Class) instead");
    }

    @Override
    public IConverter getConverter(Class<?> type) {
        return this.getApplication().getConverterLocator().getConverter(type);
    }

    public final boolean getEscapeModelStrings() {
        return this.getFlag(2);
    }

    public final FeedbackMessage getFeedbackMessage() {
        return Session.get().getFeedbackMessages().messageForComponent(this);
    }

    public String getId() {
        return this.id;
    }

    public final IModel<?> getInnermostModel() {
        return this.getInnermostModel(this.getDefaultModel());
    }

    public Locale getLocale() {
        if (this.parent != null) {
            return this.parent.getLocale();
        }
        return this.getSession().getLocale();
    }

    public final Localizer getLocalizer() {
        return this.getApplication().getResourceSettings().getLocalizer();
    }

    public final ValueMap getMarkupAttributes() {
        MarkupStream markupStream = this.locateMarkupStream();
        ValueMap attrs = new ValueMap(markupStream.getTag().getAttributes());
        attrs.makeImmutable();
        return attrs;
    }

    public final Object getMarkupIdImpl() {
        if (this.generatedMarkupId != -1) {
            return new Integer(this.generatedMarkupId);
        }
        return this.getMetaData(MARKUP_ID_KEY);
    }

    private final int nextAutoIndex() {
        Page page = this.findPage();
        if (page == null) {
            throw new WicketRuntimeException("This component is not (yet) coupled to a page. It has to be able to find the page it is supposed to operate in before you can call this method (Component#getMarkupId)");
        }
        return page.getAutoIndex();
    }

    public String getMarkupId(boolean createIfDoesNotExist) {
        int generatedMarkupId;
        Object storedMarkupId = this.getMarkupIdImpl();
        if (storedMarkupId instanceof String) {
            return (String)storedMarkupId;
        }
        if (storedMarkupId == null && !createIfDoesNotExist) {
            return null;
        }
        int n = generatedMarkupId = storedMarkupId instanceof Integer ? ((Integer)storedMarkupId).intValue() : Session.get().nextSequenceValue();
        if (storedMarkupId == null) {
            this.setMarkupIdImpl(new Integer(generatedMarkupId));
        }
        String markupIdPrefix = MARKUP_ID_ATTR_NAME;
        if (!Application.get().getConfigurationType().equals("deployment")) {
            markupIdPrefix = this.getId();
        }
        String markupIdPostfix = Integer.toHexString(generatedMarkupId).toLowerCase();
        markupIdPostfix = RequestContext.get().encodeMarkupId(markupIdPostfix);
        String markupId = markupIdPrefix + markupIdPostfix;
        char c = markupId.charAt(0);
        if (!Character.isLetter(c)) {
            markupId = MARKUP_ID_ATTR_NAME + markupId;
        }
        markupId = ((Object)Strings.replaceAll(markupId, "_", "__")).toString();
        markupId = markupId.replace('.', '_');
        markupId = markupId.replace('-', '_');
        markupId = markupId.replace(' ', '_');
        return markupId;
    }

    public String getMarkupId() {
        return this.getMarkupId(true);
    }

    public final <M extends Serializable> M getMetaData(MetaDataKey<M> key) {
        return (M)((Serializable)key.get(this.getMetaData()));
    }

    private MetaDataEntry<?>[] getMetaData() {
        int length;
        MetaDataEntry[] metaData = null;
        int index = this.getFlag(0x100000) ? 1 : 0;
        if (index < (length = this.data_length())) {
            Object object = this.data_get(index);
            if (object instanceof MetaDataEntry[]) {
                metaData = (MetaDataEntry[])object;
            } else if (object instanceof MetaDataEntry) {
                metaData = new MetaDataEntry[]{(MetaDataEntry)object};
            }
        }
        return metaData;
    }

    public final IModel<?> getDefaultModel() {
        IModel<?> model = this.getModelImpl();
        if (model == null) {
            model = this.initModel();
            this.setModelImpl(model);
        }
        return model;
    }

    public final Object getDefaultModelObject() {
        IModel<?> model = this.getDefaultModel();
        if (model != null) {
            return model.getObject();
        }
        return null;
    }

    public final String getDefaultModelObjectAsString() {
        return this.getDefaultModelObjectAsString(this.getDefaultModelObject());
    }

    public final String getDefaultModelObjectAsString(Object modelObject) {
        Class<?> objectClass;
        IConverter converter;
        String modelString;
        if (modelObject != null && (modelString = (converter = this.getConverter(objectClass = modelObject.getClass())).convertToString(modelObject, this.getLocale())) != null) {
            if (this.getFlag(2)) {
                return ((Object)Strings.escapeMarkup(modelString, false, false)).toString();
            }
            return modelString;
        }
        return "";
    }

    public final boolean getOutputMarkupId() {
        return this.getFlag(16384);
    }

    public final boolean getOutputMarkupPlaceholderTag() {
        return this.getFlag(32768);
    }

    public final Page getPage() {
        Page page = this.findPage();
        if (page == null) {
            throw new IllegalStateException("No Page found for component " + this);
        }
        return page;
    }

    public final String getPageRelativePath() {
        return Strings.afterFirstPathComponent(this.getPath(), ':');
    }

    public final MarkupContainer getParent() {
        return this.parent;
    }

    public final String getPath() {
        PrependingStringBuffer buffer = new PrependingStringBuffer(32);
        for (Component c = this; c != null; c = c.getParent()) {
            if (buffer.length() > 0) {
                buffer.prepend(':');
            }
            buffer.prepend(c.getId());
        }
        return buffer.toString();
    }

    public final boolean getRenderBodyOnly() {
        return this.getFlag(32);
    }

    public final Request getRequest() {
        RequestCycle requestCycle = this.getRequestCycle();
        if (requestCycle == null) {
            throw new WicketRuntimeException("No RequestCycle is currently set!");
        }
        return requestCycle.getRequest();
    }

    public final RequestCycle getRequestCycle() {
        return RequestCycle.get();
    }

    public final Response getResponse() {
        return this.getRequestCycle().getResponse();
    }

    public Session getSession() {
        return Session.get();
    }

    public long getSizeInBytes() {
        MarkupContainer originalParent = this.parent;
        this.parent = null;
        long size = -1L;
        try {
            size = Objects.sizeof(this);
        }
        catch (Exception e) {
            log.error("Exception getting size for component " + this, (Throwable)e);
        }
        this.parent = originalParent;
        return size;
    }

    public final String getString(String key) {
        return this.getString(key, null);
    }

    public final String getString(String key, IModel<?> model) {
        return this.getLocalizer().getString(key, this, model);
    }

    public final String getString(String key, IModel<?> model, String defaultValue) {
        return this.getLocalizer().getString(key, this, model, defaultValue);
    }

    public final String getStyle() {
        String variation = this.getVariation();
        String style = this.getSession().getStyle();
        if (variation != null && !"".equals(variation)) {
            style = style != null && !"".equals(style) ? variation + "_" + style : variation;
        }
        return style;
    }

    public String getVariation() {
        if (this.parent != null) {
            return this.parent.getVariation();
        }
        return null;
    }

    public final boolean hasBeenRendered() {
        return this.getFlag(4096);
    }

    public final boolean hasErrorMessage() {
        return Session.get().getFeedbackMessages().hasErrorMessageFor(this);
    }

    public final boolean hasFeedbackMessage() {
        return Session.get().getFeedbackMessages().hasMessageFor(this);
    }

    public final void info(String message) {
        Session.get().getFeedbackMessages().info(this, message);
        Session.get().dirty();
    }

    @Deprecated
    public final void internalAttach() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void internalDetach() {
        throw new UnsupportedOperationException();
    }

    public final boolean isActionAuthorized(Action action) {
        IAuthorizationStrategy authorizationStrategy = this.getSession().getAuthorizationStrategy();
        if (authorizationStrategy != null) {
            return authorizationStrategy.isActionAuthorized(this, action);
        }
        return true;
    }

    @Deprecated
    public final boolean isAncestorOf(Component component) {
        return this.getParent().contains(component, false);
    }

    public final boolean isEnableAllowed() {
        return this.isActionAuthorized(ENABLE);
    }

    public boolean isEnabled() {
        return this.getFlag(128);
    }

    public final boolean isRenderAllowed() {
        return this.getFlag(8192);
    }

    public final boolean isStateless() {
        if (!this.getStatelessHint()) {
            return false;
        }
        for (IBehavior behavior : this.getBehaviors()) {
            if (behavior.getStatelessHint(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isVersioned() {
        if (!this.getFlag(8)) {
            return false;
        }
        return this.parent == null || this.parent.isVersioned();
    }

    public boolean isVisible() {
        return this.getFlag(16);
    }

    public final boolean isVisibleInHierarchy() {
        MarkupContainer parent = this.getParent();
        if (parent != null && !parent.isVisibleInHierarchy()) {
            return false;
        }
        return this.determineVisibility();
    }

    public final void markRendering(boolean setRenderingFlag) {
        this.internalMarkRendering(setRenderingFlag);
    }

    public final void modelChanged() {
        this.internalOnModelChanged();
        this.onModelChanged();
    }

    public final void modelChanging() {
        this.checkHierarchyChange(this);
        this.onModelChanging();
        Page page = this.findPage();
        if (page != null) {
            page.componentModelChanging(this);
        }
    }

    public void prepareForRender(boolean setRenderingFlag) {
        this.beforeRender();
        if (setRenderingFlag) {
            List<Component> feedbacks = this.getRequestCycle().getMetaData(FEEDBACK_LIST);
            if (feedbacks != null) {
                for (int i = 0; i < feedbacks.size(); ++i) {
                    feedbacks.get(i).internalBeforeRender();
                }
            }
            this.getRequestCycle().setMetaData(FEEDBACK_LIST, null);
        }
        this.markRendering(setRenderingFlag);
        this.setRenderAllowed();
    }

    public final void prepareForRender() {
        this.prepareForRender(true);
    }

    public final void redirectToInterceptPage(Page page) {
        this.getPage().getPageMap().redirectToInterceptPage(page);
    }

    public final void remove() {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot remove " + this + " from null parent!");
        }
        this.parent.remove(this);
    }

    public Component remove(IBehavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("Argument `behavior` cannot be null");
        }
        if (this.removeBehavior(behavior)) {
            if (!behavior.isTemporary()) {
                this.addStateChange(new RemovedBehaviorChange(behavior));
            }
        } else {
            throw new IllegalStateException("Tried to remove a behavior that was not added to the component. Behavior: " + behavior.toString());
        }
        return this;
    }

    private boolean removeBehavior(IBehavior behavior) {
        int start = this.getFlag(0x100000) ? 1 : 0;
        int len = this.data_length();
        for (int i = start; i < len; ++i) {
            int j;
            Object o = this.data_get(i);
            if (o == null || !o.equals(behavior)) continue;
            boolean anyListenersAfter = false;
            for (j = i + 1; j < len; ++j) {
                if (!(this.data_get(j) instanceof IRequestListener)) continue;
                anyListenersAfter = true;
                break;
            }
            if (anyListenersAfter) {
                this.data_set(i, null);
            } else {
                this.data_remove(i);
                if (o instanceof IRequestListener) {
                    for (j = i - 1; j >= start && this.data_get(j) == null; --j) {
                        this.data_remove(j);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public final void render() {
        MarkupStream markupStream = null;
        if (this.getParent() != null) {
            markupStream = this.findMarkupStream();
        }
        this.render(markupStream);
    }

    public final void render(MarkupStream markupStream) {
        if (markupStream != null) {
            this.markupIndex = markupStream.getCurrentIndex();
        }
        this.markRendering(true);
        this.setMarkupStream(markupStream);
        if (markupStream != null) {
            markupStream.getTag().onBeforeRender(this, markupStream);
        }
        if (this.determineVisibility()) {
            this.setFlag(4096, true);
            if (log.isDebugEnabled()) {
                log.debug("Begin render " + this);
            }
            try {
                IComponentBorder border = this.getComponentBorder();
                if (border != null) {
                    border.renderBefore(this);
                }
                this.notifyBehaviorsComponentBeforeRender();
                this.onRender(markupStream);
                this.notifyBehaviorsComponentRendered();
                if (border != null) {
                    border.renderAfter(this);
                }
                this.rendered();
            }
            catch (RuntimeException ex) {
                for (IBehavior behavior : this.getBehaviors()) {
                    if (!this.isBehaviorAccepted(behavior)) continue;
                    try {
                        behavior.exception(this, ex);
                    }
                    catch (Throwable ex2) {
                        log.error("Error while cleaning up after exception", ex2);
                    }
                }
                throw ex;
            }
            if (log.isDebugEnabled()) {
                log.debug("End render " + this);
            }
        } else if (markupStream != null) {
            if (this.getFlag(32768)) {
                ComponentTag tag = markupStream.getTag();
                this.renderPlaceholderTag(tag, this.getResponse());
            }
            markupStream.skipComponent();
        }
    }

    protected void renderPlaceholderTag(ComponentTag tag, Response response) {
        String ns = Strings.isEmpty(tag.getNamespace()) ? null : tag.getNamespace() + ":";
        response.write("<");
        if (ns != null) {
            response.write(ns);
        }
        response.write(tag.getName());
        response.write(" id=\"");
        response.write(this.getAjaxRegionMarkupId());
        response.write("\" style=\"display:none\"></");
        if (ns != null) {
            response.write(ns);
        }
        response.write(tag.getName());
        response.write(">");
    }

    public final String getAjaxRegionMarkupId() {
        String markupId = null;
        for (IBehavior behavior : this.getBehaviors()) {
            if (!(behavior instanceof IAjaxRegionMarkupIdProvider)) continue;
            markupId = ((IAjaxRegionMarkupIdProvider)((Object)behavior)).getAjaxRegionMarkupId(this);
        }
        if (markupId == null && this instanceof IAjaxRegionMarkupIdProvider) {
            markupId = ((IAjaxRegionMarkupIdProvider)((Object)this)).getAjaxRegionMarkupId(this);
        }
        if (markupId == null) {
            markupId = this.getMarkupId();
        }
        return markupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderComponent() {
        if (this instanceof Page) {
            ((Page)this).renderPage();
        } else {
            MarkupContainer parent = this.getParent();
            MarkupStream originalMarkupStream = parent.getMarkupStream();
            MarkupStream markupStream = this.locateMarkupStream();
            try {
                parent.setMarkupStream(markupStream);
                this.prepareForRender();
                this.render(markupStream);
            }
            finally {
                parent.setMarkupStream(originalMarkupStream);
                this.afterRender();
            }
        }
    }

    public final void renderComponent(MarkupStream markupStream) {
        this.markupIndex = markupStream.getCurrentIndex();
        ComponentTag openTag = markupStream.getTag();
        ComponentTag tag = openTag.mutable();
        this.onComponentTag(tag);
        if (!tag.isOpenClose() && !tag.isOpen()) {
            markupStream.throwMarkupException("Method renderComponent called on bad markup element: " + tag);
        }
        if (tag.isOpenClose() && openTag.isOpen()) {
            markupStream.throwMarkupException("You can not modify a open tag to open-close: " + tag);
        }
        try {
            if (!this.getRenderBodyOnly()) {
                this.renderComponentTag(tag);
            }
            markupStream.next();
            if (tag.isOpen()) {
                this.onComponentTagBody(markupStream, tag);
            }
            if (tag.isOpen()) {
                if (openTag.isOpen()) {
                    this.renderClosingComponentTag(markupStream, tag, this.getRenderBodyOnly());
                } else if (!this.getRenderBodyOnly()) {
                    boolean stripWicketTags;
                    boolean ajaxRequest = this.getRequest() instanceof WebRequest && ((WebRequest)this.getRequest()).isAjax();
                    boolean bl = stripWicketTags = ajaxRequest || Application.get().getMarkupSettings().getStripWicketTags();
                    if (!(openTag instanceof WicketTag) || !stripWicketTags) {
                        this.getResponse().write(tag.syntheticCloseTagString());
                    }
                }
            }
        }
        catch (RuntimeException re) {
            if (re instanceof WicketRuntimeException || re instanceof AbortException) {
                throw re;
            }
            throw new WicketRuntimeException("Exception in rendering component: " + this, re);
        }
    }

    public final void rendered() {
        this.getPage().componentRendered(this);
    }

    public void renderHead(HtmlHeaderContainer container) {
        if (this.isVisibleInHierarchy() && this.isRenderAllowed()) {
            if (this instanceof IHeaderContributor) {
                ((IHeaderContributor)((Object)this)).renderHead(container.getHeaderResponse());
            }
            for (IBehavior behavior : this.getBehaviors()) {
                if (!(behavior instanceof IHeaderContributor) || !this.isBehaviorAccepted(behavior)) continue;
                ((IHeaderContributor)((Object)behavior)).renderHead(container.getHeaderResponse());
            }
        }
    }

    public void replaceWith(Component replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException("Argument [[replacement]] cannot be null.");
        }
        if (!this.getId().equals(replacement.getId())) {
            throw new IllegalArgumentException("Replacement component must have the same id as the component it will replace. Replacement id [[" + replacement.getId() + "]], replaced id [[" + this.getId() + "]].");
        }
        if (this.parent == null) {
            throw new IllegalStateException("This method can only be called on a component that has already been added to its parent.");
        }
        this.parent.replace(replacement);
    }

    public final boolean sameInnermostModel(Component component) {
        return this.sameInnermostModel(component.getDefaultModel());
    }

    public final boolean sameInnermostModel(IModel<?> model) {
        IModel<?> thisModel = this.getDefaultModel();
        IModel<?> thatModel = model;
        if (thisModel != null && thatModel != null) {
            return this.getInnermostModel(thisModel) == this.getInnermostModel(thatModel);
        }
        return false;
    }

    @Deprecated
    public final Component setComponentBorder(IComponentBorder border) {
        if (!Objects.equal(this.getComponentBorder(), border)) {
            this.addStateChange(new ComponentBorderChange());
        }
        this.setMetaData(BORDER_KEY, border);
        return this;
    }

    public final Component setEnabled(boolean enabled) {
        if (enabled != this.getFlag(128)) {
            Page page;
            if (this.isVersioned() && (page = this.findPage()) != null) {
                this.addStateChange(new EnabledChange(this));
            }
            this.setFlag(128, enabled);
            this.onEnabledStateChanged();
        }
        return this;
    }

    void clearEnabledInHierarchyCache() {
        this.setMetaData(ENABLED_IN_HIERARCHY_CACHE_KEY, null);
    }

    void onEnabledStateChanged() {
        this.clearEnabledInHierarchyCache();
    }

    public final Component setEscapeModelStrings(boolean escapeMarkup) {
        this.setFlag(2, escapeMarkup);
        return this;
    }

    public final void setMarkupIdImpl(Object markupId) {
        if (markupId != null && !(markupId instanceof String) && !(markupId instanceof Integer)) {
            throw new IllegalArgumentException("markupId must be String or Integer");
        }
        if (markupId instanceof Integer) {
            this.generatedMarkupId = (Integer)markupId;
            this.setMetaData(MARKUP_ID_KEY, null);
            return;
        }
        this.generatedMarkupId = -1;
        this.setMetaData(MARKUP_ID_KEY, (String)markupId);
    }

    public Component setMarkupId(String markupId) {
        if (markupId != null && Strings.isEmpty(markupId)) {
            throw new IllegalArgumentException("Markup id cannot be an empty string");
        }
        this.setMarkupIdImpl(markupId);
        return this;
    }

    public final <M> void setMetaData(MetaDataKey<M> key, M object) {
        int index;
        MetaDataEntry<?>[] old = this.getMetaData();
        MetaDataEntry<?>[] metaData = null;
        MetaDataEntry<?>[] metaDataArray = key.set(this.getMetaData(), object);
        if (metaDataArray != null && metaDataArray.length > 0) {
            metaData = metaDataArray.length > 1 ? metaDataArray : metaDataArray[0];
        }
        int n = index = this.getFlag(0x100000) ? 1 : 0;
        if (old == null && metaData != null) {
            this.data_insert(index, metaData);
        } else if (old != null && metaData != null) {
            this.data_set(index, metaData);
        } else if (old != null && metaData == null) {
            this.data_remove(index);
        }
    }

    public Component setDefaultModel(IModel<?> model) {
        IModel<?> prevModel = this.getModelImpl();
        if (prevModel != null) {
            prevModel.detach();
        }
        IModel<?> wrappedModel = prevModel;
        if (prevModel instanceof IWrapModel) {
            wrappedModel = ((IWrapModel)prevModel).getWrappedModel();
        }
        if (wrappedModel != model) {
            if (wrappedModel != null) {
                this.addStateChange(new ComponentModelChange(wrappedModel));
            }
            this.setModelImpl(this.wrap(model));
        }
        this.modelChanged();
        return this;
    }

    IModel<?> getModelImpl() {
        if (this.getFlag(0x100000)) {
            return (IModel)this.data_get(0);
        }
        return null;
    }

    void setModelImpl(IModel<?> model) {
        if (this.getFlag(0x100000)) {
            if (model != null) {
                this.data_set(0, model);
                if (this.getFlag(4) && !(model instanceof IComponentInheritedModel)) {
                    this.setFlag(4, false);
                }
            } else {
                this.data_remove(0);
                this.setFlag(0x100000, false);
            }
        } else if (model != null) {
            this.data_insert(0, model);
            this.setFlag(0x100000, true);
        }
    }

    public final Component setDefaultModelObject(Object object) {
        IModel<?> model = this.getDefaultModel();
        if (model == null) {
            throw new IllegalStateException("Attempt to set model object on null model of component: " + this.getPageRelativePath());
        }
        if (!this.isActionAuthorized(ENABLE)) {
            throw new UnauthorizedActionException(this, ENABLE);
        }
        if (!this.getModelComparator().compare(this, object)) {
            this.modelChanging();
            model.setObject(object);
            this.modelChanged();
        }
        return this;
    }

    public final Component setOutputMarkupId(boolean output) {
        this.setFlag(16384, output);
        return this;
    }

    public final Component setOutputMarkupPlaceholderTag(boolean outputTag) {
        if (outputTag != this.getFlag(32768)) {
            if (outputTag) {
                this.setOutputMarkupId(true);
                this.setFlag(32768, true);
            } else {
                this.setFlag(32768, false);
            }
        }
        return this;
    }

    public final void setRedirect(boolean redirect) {
        this.getRequestCycle().setRedirect(redirect);
    }

    public final Component setRenderBodyOnly(boolean renderTag) {
        this.setFlag(32, renderTag);
        return this;
    }

    public final <C extends Page> void setResponsePage(Class<C> cls) {
        this.getRequestCycle().setResponsePage(cls);
    }

    public final <C extends Page> void setResponsePage(Class<C> cls, PageParameters parameters) {
        this.getRequestCycle().setResponsePage(cls, parameters);
    }

    public final void setResponsePage(Page page) {
        this.getRequestCycle().setResponsePage(page);
    }

    public Component setVersioned(boolean versioned) {
        this.setFlag(8, versioned);
        return this;
    }

    public final Component setVisible(boolean visible) {
        if (visible != this.getFlag(16)) {
            this.addStateChange(new VisibilityChange(this));
            this.setFlag(16, visible);
        }
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        try {
            if (detailed) {
                Page page = this.findPage();
                if (page == null) {
                    return new StringBuffer("[Component id = ").append(this.getId()).append(", page = <No Page>, path = ").append(this.getPath()).append(".").append(Classes.simpleName(this.getClass())).append("]").toString();
                }
                return new StringBuffer("[Component id = ").append(this.getId()).append(", page = ").append(this.getPage().getClass().getName()).append(", path = ").append(this.getPath()).append(".").append(Classes.simpleName(this.getClass())).append(", isVisible = ").append(this.determineVisibility()).append(", isVersioned = ").append(this.isVersioned()).append("]").toString();
            }
            return "[Component id = " + this.getId() + "]";
        }
        catch (Exception e) {
            log.warn("Error while building toString()", (Throwable)e);
            return String.format("[Component id = %s <attributes are not available because exception %s was thrown during toString()>]", this.getId(), e.getClass().getName());
        }
    }

    public final <C extends Page> CharSequence urlFor(Class<C> pageClass, PageParameters parameters) {
        return this.getRequestCycle().urlFor(this.getPage().getPageMap(), pageClass, parameters);
    }

    public final CharSequence urlFor(IBehavior behaviour, RequestListenerInterface listener) {
        return this.getRequestCycle().urlFor(this, behaviour, listener);
    }

    public final <C extends Page> CharSequence urlFor(IPageMap pageMap, Class<C> pageClass, PageParameters parameters) {
        return this.getRequestCycle().urlFor(pageMap, pageClass, parameters);
    }

    public final CharSequence urlFor(IRequestTarget requestTarget) {
        return this.getRequestCycle().urlFor(requestTarget);
    }

    public final CharSequence urlFor(RequestListenerInterface listener) {
        return this.getRequestCycle().urlFor(this, listener);
    }

    public final CharSequence urlFor(ResourceReference resourceReference) {
        return this.getRequestCycle().urlFor(resourceReference);
    }

    public final Object visitParents(Class<?> c, IVisitor<Component> visitor) {
        for (MarkupContainer current = this.getParent(); current != null; current = current.getParent()) {
            Object object;
            if (!c.isInstance(current) || (object = visitor.component(current)) == IVisitor.CONTINUE_TRAVERSAL) continue;
            return object;
        }
        return null;
    }

    public final void warn(String message) {
        Session.get().getFeedbackMessages().warn(this, message);
        Session.get().dirty();
    }

    private void notifyBehaviorsComponentBeforeRender() {
        for (IBehavior behavior : this.getBehaviors()) {
            if (!this.isBehaviorAccepted(behavior)) continue;
            behavior.beforeRender(this);
        }
    }

    private void notifyBehaviorsComponentRendered() {
        for (IBehavior behavior : this.getBehaviors()) {
            if (!this.isBehaviorAccepted(behavior)) continue;
            behavior.afterRender(this);
        }
    }

    protected final void addStateChange(Change change) {
        this.checkHierarchyChange(this);
        Page page = this.findPage();
        if (page != null) {
            page.componentStateChanging(this, change);
        }
    }

    protected final void checkComponentTag(ComponentTag tag, String name) {
        if (!tag.getName().equalsIgnoreCase(name)) {
            String msg = String.format("Component [%s] (path = [%s]) must be applied to a tag of type [%s], not: %s", this.getId(), this.getPath(), name, tag.toUserDebugString());
            this.findMarkupStream().throwMarkupException(msg);
        }
    }

    protected final void checkComponentTagAttribute(ComponentTag tag, String key, String value) {
        String tagAttributeValue;
        if (!(key == null || (tagAttributeValue = tag.getAttributes().getString(key)) != null && value.equalsIgnoreCase(tagAttributeValue))) {
            String msg = String.format("Component [%s] (path = [%s]) must be applied to a tag with [%s] attribute matching [%s], not [%s]", this.getId(), this.getPath(), key, value, tagAttributeValue);
            this.findMarkupStream().throwMarkupException(msg);
        }
    }

    protected void checkHierarchyChange(Component component) {
        if (!component.isAuto() && this.getFlag(0x2000000)) {
            throw new WicketRuntimeException("Cannot modify component hierarchy after render phase has started (page version cant change then anymore)");
        }
    }

    protected void detachModel() {
        IModel<?> model = this.getModelImpl();
        if (model != null) {
            model.detach();
        }
        if (model instanceof IWrapModel && !this.getFlag(4)) {
            ((IWrapModel)model).getWrappedModel().detach();
        }
    }

    protected final String exceptionMessage(String message) {
        return message + ":\n" + this.toString();
    }

    protected MarkupStream findMarkupStream() {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot find markupstream for " + this + " as there is no parent");
        }
        return this.parent.findMarkupStream();
    }

    protected final Page findPage() {
        return (Page)(this instanceof Page ? this : (Component)this.findParent(Page.class));
    }

    protected <M extends IBehavior> List<M> getBehaviors(Class<M> type) {
        List<IBehavior> behaviors = this.getBehaviorsRawList();
        if (behaviors == null) {
            return Collections.emptyList();
        }
        ArrayList<IBehavior> subset = new ArrayList<IBehavior>(behaviors.size());
        for (IBehavior behavior : behaviors) {
            if (behavior == null) continue;
            if (type == null) {
                subset.add(behavior);
                continue;
            }
            if (!type.isAssignableFrom(behavior.getClass())) continue;
            subset.add((IBehavior)type.cast(behavior));
        }
        return Collections.unmodifiableList(subset);
    }

    protected final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    protected final boolean getFlag(short flag) {
        return this.getFlag((int)flag);
    }

    protected final IModel<?> getInnermostModel(IModel<?> model) {
        IModel<?> nested = model;
        while (nested != null && nested instanceof IWrapModel) {
            IModel<?> next = ((IWrapModel)nested).getWrappedModel();
            if (nested == next) {
                throw new WicketRuntimeException("Model for " + nested + " is self-referential");
            }
            nested = next;
        }
        return nested;
    }

    public IModelComparator getModelComparator() {
        return defaultModelComparator;
    }

    protected boolean getStatelessHint() {
        return true;
    }

    protected IModel<?> initModel() {
        IWrapModel foundModel = null;
        for (MarkupContainer current = this.getParent(); current != null; current = current.getParent()) {
            IModel<?> model = current.getModelImpl();
            if (model instanceof IWrapModel && !(model instanceof IComponentInheritedModel)) {
                model = ((IWrapModel)model).getWrappedModel();
            }
            if (!(model instanceof IComponentInheritedModel)) continue;
            foundModel = ((IComponentInheritedModel)model).wrapOnInheritance(this);
            this.setFlag(4, true);
            break;
        }
        return foundModel;
    }

    protected final void internalOnAttach() {
    }

    protected final void internalOnDetach() {
    }

    protected void internalOnModelChanged() {
    }

    protected final void markAttached(boolean attached) {
        this.setFlag(0x20000000, attached);
    }

    protected final boolean isAttached() {
        return this.getFlag(0x20000000);
    }

    protected boolean isBehaviorAccepted(IBehavior behavior) {
        if (behavior instanceof AttributeModifier && this.getFlag(64)) {
            return false;
        }
        return behavior.isEnabled(this);
    }

    protected final boolean isIgnoreAttributeModifier() {
        return this.getFlag(64);
    }

    protected MarkupStream locateMarkupStream() {
        return new MarkupFragmentFinder().find(this);
    }

    protected void onAfterRender() {
        this.setFlag(0x8000000, false);
    }

    @Deprecated
    protected final void onAttach() {
    }

    protected void onBeforeRender() {
        this.setFlag(0x4000000, true);
        this.onBeforeRenderChildren();
        this.setFlag(0x1000000, true);
    }

    @Deprecated
    protected boolean callOnBeforeRenderIfNotVisible() {
        return false;
    }

    @Deprecated
    protected final void onBeginRequest() {
        throw new UnsupportedOperationException();
    }

    protected void onComponentTag(ComponentTag tag) {
        if (this.getFlag(16384)) {
            tag.put(MARKUP_ID_ATTR_NAME, this.getMarkupId());
        }
        if (this.getApplication().getDebugSettings().isOutputComponentPath()) {
            String path = this.getPageRelativePath();
            path = path.replace("_", "__");
            path = path.replace(":", "_");
            tag.put("wicketpath", path);
        }
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
    }

    protected void onDetach() {
        this.setFlag(Integer.MIN_VALUE, false);
    }

    void initialize() {
        this.fireInitialize();
    }

    final void fireInitialize() {
        if (!this.getFlag(0x400000)) {
            this.setFlag(0x400000, true);
            this.setFlag(0x10000000, false);
            this.onInitialize();
            if (!this.getFlag(0x10000000)) {
                throw new IllegalStateException(Component.class.getName() + " has not been properly initialized. Something in the hierarchy of " + this.getClass().getName() + " has not called super.onInitialize() in the override of onInitialize() method");
            }
            this.setFlag(0x10000000, false);
            this.getApplication().fireComponentInitializationListeners(this);
        }
    }

    protected void onConfigure() {
    }

    protected void onInitialize() {
        this.setFlag(0x10000000, true);
    }

    protected void onRemove() {
        this.setFlag(0x200000, false);
    }

    @Deprecated
    protected final void onEndRequest() {
        throw new UnsupportedOperationException();
    }

    protected void onModelChanged() {
    }

    protected void onModelChanging() {
    }

    protected abstract void onRender(MarkupStream var1);

    protected final void renderComponentTag(ComponentTag tag) {
        boolean stripWicketTags;
        boolean ajaxRequest = this.getRequest() instanceof WebRequest && ((WebRequest)this.getRequest()).isAjax();
        boolean bl = stripWicketTags = ajaxRequest || Application.get().getMarkupSettings().getStripWicketTags();
        if (tag instanceof WicketTag && !tag.isClose() && !this.getFlag(64)) {
            if (this.getFlag(16384)) {
                log.warn(String.format("Markup id set on a component that is usually not rendered into markup. Markup id: %s, component id: %s, component tag: %s.", this.getMarkupId(), this.getId(), tag.getName()));
            }
            if (this.getFlag(32768)) {
                log.warn(String.format("Placeholder tag set on a component that is usually not rendered into markup. Component id: %s, component tag: %s.", this.getId(), tag.getName()));
            }
        }
        if (!(tag instanceof WicketTag) || !stripWicketTags) {
            List<IBehavior> behaviors = this.getBehaviors();
            if (!(behaviors == null || behaviors.isEmpty() || tag.isClose() || this.isIgnoreAttributeModifier())) {
                tag = tag.mutable();
                for (IBehavior behavior : behaviors) {
                    if (!this.isBehaviorAccepted(behavior)) continue;
                    behavior.onComponentTag(this, tag);
                }
            }
            if (tag.hasBehaviors()) {
                Iterator<? extends IBehavior> tagBehaviors = tag.getBehaviors();
                while (tagBehaviors.hasNext()) {
                    IBehavior behavior;
                    behavior = tagBehaviors.next();
                    if (behavior.isEnabled(this)) {
                        behavior.onComponentTag(this, tag);
                    }
                    behavior.detach(this);
                }
            }
            tag.writeOutput(this.getResponse(), stripWicketTags, this.findMarkupStream().getWicketNamespace());
        }
    }

    protected final void replaceComponentTagBody(MarkupStream markupStream, ComponentTag tag, CharSequence body) {
        ComponentTag markupOpenTag = null;
        if (tag.isOpen()) {
            markupStream.setCurrentIndex(markupStream.getCurrentIndex() - 1);
            markupOpenTag = markupStream.getTag();
            markupStream.next();
            if (markupOpenTag.isOpen()) {
                markupStream.skipRawMarkup();
            }
        }
        if (body != null) {
            this.getResponse().write(body);
        }
        if (tag.isOpen() && markupOpenTag != null && markupOpenTag.isOpen() && !markupStream.atCloseTag()) {
            markupStream.throwMarkupException("Expected close tag for '" + markupOpenTag + "' Possible attempt to embed component(s) '" + markupStream.get() + "' in the body of this component which discards its body");
        }
    }

    protected final void setAuto(boolean auto) {
        this.setFlag(1, auto);
    }

    protected final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    protected final void setFlag(short flag, boolean set) {
        this.setFlag((int)flag, set);
    }

    protected final Component setIgnoreAttributeModifier(boolean ignore) {
        this.setFlag(64, ignore);
        return this;
    }

    protected void setMarkupStream(MarkupStream markupStream) {
    }

    protected final <V> IModel<V> wrap(IModel<V> model) {
        if (model instanceof IComponentAssignedModel) {
            return ((IComponentAssignedModel)model).wrapOnAssignment(this);
        }
        return model;
    }

    void detachChildren() {
    }

    void removeChildren() {
    }

    Component get(String path) {
        if (path.equals("")) {
            return this;
        }
        throw new IllegalArgumentException(this.exceptionMessage("Component is not a container and so does not contain the path " + path));
    }

    final boolean hasMarkupIdMetaData() {
        return this.getMarkupId() != null;
    }

    void internalMarkRendering(boolean setRenderingFlag) {
        if (setRenderingFlag) {
            this.setFlag(0x4000000, false);
            this.setFlag(0x2000000, true);
        }
    }

    final boolean isAuto() {
        for (Component current = this; current != null; current = current.getParent()) {
            if (!current.getFlag(1)) continue;
            return true;
        }
        return false;
    }

    boolean isPreparedForRender() {
        return this.getFlag(0x4000000);
    }

    void onAfterRenderChildren() {
    }

    void onBeforeRenderChildren() {
    }

    final void renderClosingComponentTag(MarkupStream markupStream, ComponentTag openTag, boolean renderTagOnly) {
        if (openTag.isOpen()) {
            if (markupStream.atCloseTag() && markupStream.getTag().closes(openTag)) {
                ComponentTag closeTag = markupStream.getTag();
                if (openTag.getNameChanged()) {
                    closeTag = closeTag.mutable();
                    closeTag.setName(openTag.getName());
                    closeTag.setNamespace(openTag.getNamespace());
                }
                if (!renderTagOnly) {
                    this.renderComponentTag(closeTag);
                }
                markupStream.next();
            } else if (openTag.requiresCloseTag()) {
                markupStream.throwMarkupException("Expected close tag for " + openTag);
            }
        }
    }

    final void setId(String id) {
        if (!(this instanceof Page) && Strings.isEmpty(id)) {
            throw new WicketRuntimeException("Null or empty component ID's are not allowed.");
        }
        if (id != null && id.indexOf(58) != -1) {
            throw new WicketRuntimeException("The component ID must not contain ':' chars.");
        }
        this.id = id;
    }

    final void setParent(MarkupContainer parent) {
        if (this.parent != null && log.isDebugEnabled()) {
            log.debug("Replacing parent " + this.parent + " with " + parent);
        }
        this.parent = parent;
    }

    final void setRenderAllowed(boolean renderAllowed) {
        this.setFlag(8192, renderAllowed);
    }

    void setRenderAllowed() {
        this.setRenderAllowed(this.isActionAuthorized(RENDER));
    }

    public final Component setVisibilityAllowed(boolean allowed) {
        this.setFlag(0x40000000, allowed);
        return this;
    }

    public final boolean isVisibilityAllowed() {
        return this.getFlag(0x40000000);
    }

    public final boolean determineVisibility() {
        return this.isVisible() && this.isRenderAllowed() && this.isVisibilityAllowed();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this instanceof Page) {
            ((Page)this).writePageObject(s);
        } else {
            s.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this instanceof Page) {
            ((Page)this).readPageObject(s);
        } else {
            s.defaultReadObject();
        }
    }

    public final boolean isEnabledInHierarchy() {
        Boolean state = this.getMetaData(ENABLED_IN_HIERARCHY_CACHE_KEY);
        if (state == null) {
            MarkupContainer parent = this.getParent();
            state = parent != null && !parent.isEnabledInHierarchy() ? Boolean.valueOf(false) : Boolean.valueOf(this.isEnabled() && this.isEnableAllowed());
            this.setMetaData(ENABLED_IN_HIERARCHY_CACHE_KEY, state);
        }
        return state;
    }

    protected static final class VisibilityChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final Component component;
        private final boolean visible;

        VisibilityChange(Component component) {
            this.component = component;
            this.visible = component.getFlag(16);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[component: " + this.component.getPath() + ",visible: " + this.visible + "]";
        }

        public void undo() {
            this.component.setVisible(this.visible);
        }
    }

    protected static final class EnabledChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final Component component;
        private final boolean enabled;

        EnabledChange(Component component) {
            this.component = component;
            this.enabled = component.getFlag(128);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[component: " + this.component.getPath() + ",enabled: " + this.enabled + "]";
        }

        public void undo() {
            this.component.setEnabled(this.enabled);
        }
    }

    private final class RemovedBehaviorChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IBehavior behavior;

        public RemovedBehaviorChange(IBehavior behavior) {
            this.behavior = behavior;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " behavior=" + this.behavior.toString() + "]";
        }

        public void undo() {
            Component.this.addBehavior(this.behavior);
        }
    }

    private class ComponentBorderChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IComponentBorder old;

        private ComponentBorderChange() {
            this.old = Component.this.getComponentBorder();
        }

        public void undo() {
            Component.this.setComponentBorder(this.old);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[component: " + Component.this.getPath() + ",border:" + this.old + "]";
        }
    }

    private final class AddedBehaviorChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IBehavior behavior;

        public AddedBehaviorChange(IBehavior behavior) {
            this.behavior = behavior;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " behavior=" + this.behavior.toString() + "]";
        }

        public void undo() {
            Component.this.removeBehavior(this.behavior);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IVisitor<T extends Component> {
        public static final Object CONTINUE_TRAVERSAL = null;
        public static final Object CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER = new Object();
        public static final Object STOP_TRAVERSAL = new Object();

        public Object component(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ComponentModelChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IModel<?> model;

        public ComponentModelChange(IModel<?> model) {
            this.model = model;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[component: " + Component.this.getPath() + ",model:" + this.model + "]";
        }

        @Override
        public void undo() {
            Component.this.setDefaultModel(this.model);
        }
    }
}

