/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import gplazma.authz.AuthorizationController;
import gplazma.authz.AuthorizationException;
import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.dcache.gplazma.plugins.RecordConvert;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GplazmaLegacy
implements GPlazmaAuthenticationPlugin,
GPlazmaMappingPlugin,
GPlazmaSessionPlugin {
    private static final Logger _log = LoggerFactory.getLogger(GplazmaLegacy.class);
    private static final String GPLAZMA1_POLICY_OPTION = "gplazma.legacy.config";
    private static final List<String> NO_ROLES = Collections.emptyList();
    private final String _policyFile;

    public GplazmaLegacy(Properties properties) {
        this._policyFile = properties.getProperty(GPLAZMA1_POLICY_OPTION);
        Preconditions.checkArgument((this._policyFile != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.legacy.config");
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        try {
            AuthorizationController gplazma = new AuthorizationController(this._policyFile);
            Principal userPrincipal = (Principal)Iterables.getFirst((Iterable)Iterables.filter(identifiedPrincipals, LoginNamePrincipal.class), null);
            String user = userPrincipal == null ? null : userPrincipal.getName();
            X509Certificate[] chain = (X509Certificate[])Iterables.getFirst((Iterable)Iterables.filter(publicCredentials, X509Certificate[].class), null);
            if (chain != null) {
                AuthorizationRecord authrec = RecordConvert.gPlazmaToAuthorizationRecord(gplazma.authorize(chain, user, null, null));
                _log.debug("Authenticating by chain: {}", (Object)authrec);
                identifiedPrincipals.add(new AuthorizationRecordPrincipal(authrec));
                return;
            }
            GlobusPrincipal dn = (GlobusPrincipal)Iterables.getFirst((Iterable)Iterables.filter(identifiedPrincipals, GlobusPrincipal.class), null);
            if (dn != null) {
                HashSet fqanPrincipals = Sets.newHashSet((Iterable)Iterables.filter(publicCredentials, FQANPrincipal.class));
                ArrayList<String> fqans = new ArrayList<String>();
                for (FQANPrincipal principal : fqanPrincipals) {
                    fqans.add(principal.getName());
                }
                AuthorizationRecord authrec = RecordConvert.gPlazmaToAuthorizationRecord(gplazma.authorize(dn.getName(), fqans, null, user, null, null));
                _log.debug("Authenticating by DN+FQAN: {}", (Object)authrec);
                identifiedPrincipals.add(new AuthorizationRecordPrincipal(authrec));
                return;
            }
            KerberosPrincipal principal = (KerberosPrincipal)Iterables.getFirst((Iterable)Iterables.filter(privateCredentials, KerberosPrincipal.class), null);
            if (principal != null) {
                AuthorizationRecord authrec = RecordConvert.gPlazmaToAuthorizationRecord(gplazma.authorize(principal.getName(), NO_ROLES, null, user, null, null));
                _log.debug("Authenticating by Kerberos principal: {}", (Object)authrec);
                identifiedPrincipals.add(new AuthorizationRecordPrincipal(authrec));
                return;
            }
        }
        catch (AuthorizationException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        throw new AuthenticationException("no credentials or principals that gPlazma 1 understands");
    }

    public void map(Set<Principal> principals, Set<Principal> authorizedPrincipals) throws AuthenticationException {
        AuthorizationRecordPrincipal authrecPrincipal = (AuthorizationRecordPrincipal)Iterables.getFirst((Iterable)Iterables.filter(principals, AuthorizationRecordPrincipal.class), null);
        if (authrecPrincipal == null) {
            throw new AuthenticationException("not logged in via gPlazma 1");
        }
        authorizedPrincipals.addAll(authrecPrincipal.getAuthrec().toSubject().getPrincipals());
        authorizedPrincipals.add(authrecPrincipal);
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        AuthorizationRecordPrincipal authrecPrincipal = (AuthorizationRecordPrincipal)Iterables.getFirst((Iterable)Iterables.filter(authorizedPrincipals, AuthorizationRecordPrincipal.class), null);
        if (authrecPrincipal == null) {
            throw new AuthenticationException("not logged in via gPlazma 1");
        }
        AuthorizationRecord authrec = authrecPrincipal.getAuthrec();
        attrib.add(new HomeDirectory(authrec.getHome()));
        attrib.add(new RootDirectory(authrec.getRoot()));
        attrib.add(new ReadOnly(authrec.isReadOnly()));
    }

    private static class AuthorizationRecordPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = -4242349585261079837L;
        private final AuthorizationRecord _authrec;

        public AuthorizationRecordPrincipal(AuthorizationRecord authrec) {
            this._authrec = authrec;
        }

        @Override
        public String getName() {
            return this._authrec.getName();
        }

        public AuthorizationRecord getAuthrec() {
            return this._authrec;
        }
    }
}

