/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.ArgusPepRequestFactory;
import org.dcache.gplazma.plugins.GPlazmaAccountPlugin;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.pep.client.PEPClient;
import org.glite.authz.pep.client.PEPClientException;
import org.glite.authz.pep.client.config.PEPClientConfiguration;
import org.glite.authz.pep.client.config.PEPClientConfigurationException;
import org.glite.authz.pep.profile.AuthorizationProfile;
import org.glite.authz.pep.profile.GridWNAuthorizationProfile;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPlazmaArgusPlugin
implements GPlazmaAccountPlugin {
    private static final Logger _log = LoggerFactory.getLogger(GPlazmaArgusPlugin.class);
    private static final String CREATING_ARGUS_PLUGIN_WITH_PARAMETERS_params = "Creating Argus Plugin with parameters: {}";
    private static final String COULD_NOT_CREATE_PEP_CLIENT_exception = "Could not create PEP Client";
    private static final String INVALID_CONFIGURATION_FOR_ARGUS_PLUGIN = "Invalid configuration for ARGUS plugin.";
    private static final String G_PLAZMA_ARGUS_PLUGIN_ARGS_MUST_NOT_BE_NULL = "GPlazmaArgusPlugin: args must not be null.";
    private static final String INITIALISING_PEP_CLIENT_CONFIGURATION = "Initialising PEPClientConfiguration";
    private static final String CONFIGURATION_resourceid_actionid = "Configuration: [{}]; [{}]";
    private static final String AUTHORISING_SUBJECT_dn = "Authorising subject {}.";
    private static final String CREATED_REQUEST_request = "Created request: {}";
    private static final String RECEIVED_RESPONSE_response = "Received response: {}";
    private static final String BLACKLIST_CHECK_FOR_USER_dn_FAILED_DUE_TO_EXCEPTION_IN_PLUGIN = "Blacklist check for user '{}' failed due to exception in plugin.";
    private static final String DECISION_CODE_code = "Decision code: ";
    private static final String KEY_PASS = "gplazma.argus.hostkey.password";
    private static final String HOST_KEY = "gplazma.argus.hostkey";
    private static final String HOST_CERT = "gplazma.argus.hostcert";
    private static final String TRUST_MATERIAL = "gplazma.argus.ca";
    private static final String ACTION_ID = "gplazma.argus.action";
    private static final String RESOURCE_ID = "gplazma.argus.resource";
    private static final String PEP_ENDPOINT = "gplazma.argus.endpoint";
    private final PEPClient _pepClient;
    private String _resourceId;
    private String _actionId;

    public GPlazmaArgusPlugin(Properties properties) {
        _log.debug(CREATING_ARGUS_PLUGIN_WITH_PARAMETERS_params, (Object)properties);
        try {
            PEPClientConfiguration pepConfiguration = this.initPepConfiguration(properties);
            this._pepClient = new PEPClient(pepConfiguration);
        }
        catch (PEPClientException e) {
            _log.error(COULD_NOT_CREATE_PEP_CLIENT_exception, (Throwable)e);
            throw new IllegalArgumentException(INVALID_CONFIGURATION_FOR_ARGUS_PLUGIN, e);
        }
    }

    public GPlazmaArgusPlugin(PEPClient pepClient) {
        this._pepClient = pepClient;
    }

    private PEPClientConfiguration initPepConfiguration(Properties properties) throws PEPClientConfigurationException {
        Preconditions.checkNotNull((Object)properties, (Object)G_PLAZMA_ARGUS_PLUGIN_ARGS_MUST_NOT_BE_NULL);
        PEPClientConfiguration pepConfig = new PEPClientConfiguration();
        _log.debug(INITIALISING_PEP_CLIENT_CONFIGURATION);
        pepConfig.addPEPDaemonEndpoint(this.getProperty(properties, PEP_ENDPOINT));
        this._resourceId = this.getProperty(properties, RESOURCE_ID);
        this._actionId = this.getProperty(properties, ACTION_ID);
        String trustMaterial = this.getProperty(properties, TRUST_MATERIAL);
        String hostCert = this.getProperty(properties, HOST_CERT);
        String hostKey = this.getProperty(properties, HOST_KEY);
        String keyPass = this.getProperty(properties, KEY_PASS);
        pepConfig.setTrustMaterial(trustMaterial);
        pepConfig.setKeyMaterial(hostCert, hostKey, keyPass);
        _log.debug(CONFIGURATION_resourceid_actionid, (Object)this._resourceId, (Object)this._actionId);
        return pepConfig;
    }

    private String getProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("Undefined property: " + key));
        return value;
    }

    public void account(Set<Principal> authorizedPrincipals) throws AuthenticationException {
        int decision = 3;
        String dn = null;
        try {
            Collection<Object> globusPrincipals = Collections.emptySet();
            if (authorizedPrincipals != null) {
                globusPrincipals = Collections2.filter(authorizedPrincipals, (Predicate)Predicates.instanceOf(GlobusPrincipal.class));
            }
            for (Principal principal : globusPrincipals) {
                dn = principal.getName();
                _log.info(AUTHORISING_SUBJECT_dn, (Object)dn);
                Request request = ArgusPepRequestFactory.create(dn, this._resourceId, this._actionId, (AuthorizationProfile)GridWNAuthorizationProfile.getInstance());
                _log.debug(CREATED_REQUEST_request, (Object)request);
                Response response = this._pepClient.authorize(request);
                _log.debug(RECEIVED_RESPONSE_response, (Object)response);
                for (Result result : response.getResults()) {
                    decision = result.getDecision();
                    switch (decision) {
                        case 0: {
                            throw new AuthenticationException("user banned");
                        }
                        case 2: {
                            throw new AuthenticationException("indeterminate result");
                        }
                    }
                }
            }
        }
        catch (PEPClientException e) {
            decision = 0;
            _log.warn(BLACKLIST_CHECK_FOR_USER_dn_FAILED_DUE_TO_EXCEPTION_IN_PLUGIN, dn, (Object)e);
            throw new AuthenticationException("check failed", (Throwable)e);
        }
        finally {
            _log.info(DECISION_CODE_code, (Object)decision);
        }
    }
}

