/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITuple;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.xml.AidaXMLStore;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AidaObjectProxy {
    public static IManagedObject createProxy(AidaXMLStore store, String path, String type) {
        Class proxyClass = AidaObjectProxy.getClassForType(type);
        Class[] interfaces = new Class[]{IManagedObject.class, ObjectProvider.class, proxyClass};
        AidaProxyInvocationHandler handler = new AidaProxyInvocationHandler(store, path);
        Object proxyObject = Proxy.newProxyInstance(AidaObjectProxy.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        return (IManagedObject)proxyObject;
    }

    private static Class getClassForType(String nodeType) {
        Class clazz;
        Class clazz2 = clazz = IManagedObject.class;
        if (nodeType.toLowerCase().indexOf("icloud1d") >= 0) {
            clazz = ICloud1D.class;
        } else if (nodeType.toLowerCase().indexOf("icloud2d") >= 0) {
            clazz = ICloud2D.class;
        } else if (nodeType.toLowerCase().indexOf("icloud3d") >= 0) {
            clazz = ICloud3D.class;
        } else if (nodeType.toLowerCase().indexOf("idatapointset") >= 0) {
            clazz = IDataPointSet.class;
        } else if (nodeType.toLowerCase().indexOf("ifunction") >= 0) {
            clazz = IFunction.class;
        } else if (nodeType.toLowerCase().indexOf("ihistogram1d") >= 0) {
            clazz = IHistogram1D.class;
        } else if (nodeType.toLowerCase().indexOf("ihistogram2d") >= 0) {
            clazz = IHistogram2D.class;
        } else if (nodeType.toLowerCase().indexOf("ihistogram3d") >= 0) {
            clazz = IHistogram3D.class;
        } else if (nodeType.toLowerCase().indexOf("iprofile1d") >= 0) {
            clazz = IProfile1D.class;
        } else if (nodeType.toLowerCase().indexOf("iprofile2d") >= 0) {
            clazz = IProfile2D.class;
        } else if (nodeType.toLowerCase().indexOf("ituple") >= 0) {
            clazz = ITuple.class;
        }
        return clazz;
    }

    private static class AidaProxyInvocationHandler
    implements InvocationHandler {
        private String name;
        private String path;
        private AidaXMLStore store;
        private SoftReference backend;

        AidaProxyInvocationHandler(AidaXMLStore store, String path) {
            this.path = path;
            this.store = store;
            String tmpPath = path;
            int index = tmpPath.lastIndexOf(".");
            if (index >= 0) {
                tmpPath = tmpPath.substring(0, index);
            }
            this.name = AidaUtils.parseName(tmpPath);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int nArgs;
            String methodName = method.getName();
            int n = nArgs = args == null ? 0 : args.length;
            if (nArgs == 0) {
                if ("name".equals(methodName)) {
                    return this.name;
                }
                if ("hashCode".equals(methodName)) {
                    return new Integer(this.path.hashCode());
                }
                if ("toString".equals(methodName)) {
                    return this.name;
                }
                if ("type".equals(methodName)) {
                    return ManagedObject.typeForClass(proxy.getClass());
                }
            } else if (nArgs == 1 && "equals".equals(methodName)) {
                return proxy == args[0];
            }
            if (this.backend == null || this.backend.get() == null) {
                IManagedObject mo = this.store.readManagedObject(this.path);
                this.backend = new SoftReference<IManagedObject>(mo);
            }
            if ("getManagedObject".equals(methodName)) {
                return (IManagedObject)this.backend.get();
            }
            return method.invoke((Object)((IManagedObject)this.backend.get()), args);
        }
    }

    public static interface ObjectProvider {
        public IManagedObject getManagedObject();
    }
}

