/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.ref.plotter.style.registry.AddStyleStoreEntryPanel;
import hep.aida.ref.plotter.style.registry.BaseStyleStore;
import hep.aida.ref.plotter.style.registry.CreateStyleStorePanel;
import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.OpenStyleStorePanel;
import hep.aida.ref.plotter.style.registry.StoreEntryEditorPanel;
import hep.aida.ref.plotter.style.registry.StoreEntryNode;
import hep.aida.ref.plotter.style.registry.StyleStoreEntry;
import hep.aida.ref.plotter.style.registry.WriteStyleStorePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StyleStoreEditor
extends JSplitPane {
    private JTabbedPane tabbedPanel;
    private JTree tree;
    private JPopupMenu entryMenu;
    private JPopupMenu storeMenu;
    private CreateStyleStorePanel createPanel;
    private OpenStyleStorePanel openPanel;
    private AddStyleStoreEntryPanel addStyleStoreEntryPanel;
    private WriteStyleStorePanel writeStyleStorePanel;

    public StyleStoreEditor() {
        super(1);
        this.init();
    }

    private void init() {
        ActionListener aL = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String command = ev.getActionCommand();
                if (command == null || command.trim().equals("")) {
                    return;
                }
                if (command.equals("Move Up")) {
                    StyleStoreEditor.this.moveStoreEntryUpAction();
                } else if (command.equals("Move Down")) {
                    StyleStoreEditor.this.moveStoreEntryDownAction();
                } else if (command.equals("Remove This Entry")) {
                    StyleStoreEditor.this.removeStoreEntryAction();
                } else if (command.equals("Save IPlotterStyle to XML...")) {
                    StyleStoreEditor.this.savePlotterStyleAction();
                } else if (command.equals("Add Store Entry...")) {
                    StyleStoreEditor.this.addStoreEntryAction();
                } else if (command.equals("Save As...")) {
                    StyleStoreEditor.this.saveStoreAsAction();
                } else if (command.equals("Commit Store")) {
                    StyleStoreEditor.this.commitStoreAction();
                } else if (command.equals("Close Store")) {
                    StyleStoreEditor.this.closeStoreAction();
                }
            }
        };
        JMenuItem item = null;
        this.entryMenu = new JPopupMenu("Store Entry Menu");
        item = new JMenuItem("Edit this Entry");
        item.addActionListener(aL);
        this.entryMenu.add(item);
        item = new JMenuItem("Move Up");
        item.addActionListener(aL);
        this.entryMenu.add(item);
        item = new JMenuItem("Move Down");
        item.addActionListener(aL);
        this.entryMenu.add(item);
        item = new JMenuItem("Remove This Entry");
        item.addActionListener(aL);
        this.entryMenu.add(item);
        item = new JMenuItem("Save IPlotterStyle to XML...");
        item.addActionListener(aL);
        this.entryMenu.add(item);
        this.storeMenu = new JPopupMenu("Store Menu");
        item = new JMenuItem("Add Store Entry...");
        item.addActionListener(aL);
        this.storeMenu.add(item);
        item = new JMenuItem("Save As...");
        item.addActionListener(aL);
        this.storeMenu.add(item);
        item = new JMenuItem("Commit Store");
        item.addActionListener(aL);
        this.storeMenu.add(item);
        item = new JMenuItem("Close Store");
        item.addActionListener(aL);
        this.storeMenu.add(item);
        this.tabbedPanel = new JTabbedPane();
        this.setRightComponent(new JScrollPane(this.tabbedPanel));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setExpandsSelectedPaths(true);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StyleStoreEditor.this.popupAction(e);
                } else if (e.getClickCount() == 2) {
                    StyleStoreEditor.this.doubleClickAction(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StyleStoreEditor.this.popupAction(e);
                }
            }
        };
        this.tree.addMouseListener(ml);
        this.setLeftComponent(new JScrollPane(this.tree));
        this.setDividerLocation(150);
    }

    private void addMenus(JMenuBar menuBar) {
        JMenu fileMenu = new JMenu("File");
        JMenuItem item = new JMenuItem("Create Style Store...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleStoreEditor.this.newStoreAction();
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Open Style Store...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleStoreEditor.this.openStoreAction();
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Save As...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleStoreEditor.this.saveStoreAsAction();
            }
        });
        item.setEnabled(false);
        item = new JMenuItem("Close Store");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleStoreEditor.this.closeStoreAction();
            }
        });
        item.setEnabled(false);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleStoreEditor.this.exitAction();
            }
        });
        fileMenu.add(item);
        menuBar.add(fileMenu);
    }

    void newStoreAction() {
        if (this.createPanel == null) {
            this.createPanel = new CreateStyleStorePanel(this);
        }
        try {
            IStyleStore store = this.createPanel.createStore();
            if (store != null) {
                this.addStoreNode(store);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void openStoreAction() {
        if (this.openPanel == null) {
            this.openPanel = new OpenStyleStorePanel(this);
        } else {
            this.openPanel.updateAction();
        }
        try {
            IStyleStore store = this.openPanel.openStore();
            if (store != null) {
                this.addStoreNode(store);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addStoreNode(IStyleStore store) {
        DefaultMutableTreeNode storeNode = new DefaultMutableTreeNode(store, true);
        String[] names = store.getAllStyleNames();
        StyleStoreEntry entry = null;
        StoreEntryNode node = null;
        for (int i = 0; i < names.length; ++i) {
            entry = store instanceof BaseStyleStore ? ((BaseStyleStore)store).getStoreEntry(names[i]) : new StyleStoreEntry(names[i], store.getStyle(names[i]), store.getRuleForStyle(names[i]));
            node = new StoreEntryNode(entry);
            storeNode.add(node);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(storeNode, root, root.getChildCount());
        this.tree.setSelectionPath(new TreePath(((DefaultTreeModel)this.tree.getModel()).getPathToRoot(storeNode)));
    }

    void commitStoreAction() {
        try {
            IStyleStore store = this.getSelectedStore();
            store.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void saveStoreAsAction() {
        if (this.writeStyleStorePanel == null) {
            this.writeStyleStorePanel = new WriteStyleStorePanel(this);
        }
        try {
            IStyleStore store = this.getSelectedStore();
            this.writeStyleStorePanel.writeStore(store);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void closeStoreAction() {
        IStyleStore store = this.getSelectedStore();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        int index = this.findInNode(root, store.getStoreName());
        DefaultMutableTreeNode storeNode = (DefaultMutableTreeNode)root.getChildAt(index);
        for (int i = 0; i < storeNode.getChildCount(); ++i) {
            JComponent page;
            TreeNode child = storeNode.getChildAt(i);
            if (!(child instanceof StoreEntryNode) || (page = ((StoreEntryNode)child).getPage()) == null) continue;
            this.tabbedPanel.remove(page);
        }
        storeNode.removeAllChildren();
        root.remove(index);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(root);
        store.close();
    }

    void addStoreEntryAction() {
        if (this.addStyleStoreEntryPanel == null) {
            this.addStyleStoreEntryPanel = new AddStyleStoreEntryPanel(this);
        }
        try {
            StyleStoreEntry entry = this.addStyleStoreEntryPanel.createStoreEntry();
            if (entry == null) {
                return;
            }
            IStyleStore store = this.getSelectedStore();
            String styleName = entry.getName();
            String fullStyleName = store.getStoreName() + "." + styleName;
            entry.getStyle().setParameter("plotterStyleName", fullStyleName);
            if (store instanceof BaseStyleStore) {
                ((BaseStyleStore)store).addStoreEntry(entry);
            } else {
                store.addStyle(styleName, entry.getStyle(), entry.getRule());
            }
            StoreEntryNode node = new StoreEntryNode(entry);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            int index = this.findInNode(root, store.getStoreName());
            DefaultMutableTreeNode storeNode = (DefaultMutableTreeNode)root.getChildAt(index);
            storeNode.add(node);
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(storeNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void removeStoreEntryAction() {
        StyleStoreEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return;
        }
        String nodeName = entry.getName();
        IStyleStore store = this.getSelectedStore();
        store.removeStyle(nodeName);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        int index = this.findInNode(root, store.getStoreName());
        DefaultMutableTreeNode storeNode = (DefaultMutableTreeNode)root.getChildAt(index);
        index = this.findInNode(storeNode, nodeName);
        if (index < 0) {
            return;
        }
        storeNode.remove(index);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(storeNode);
    }

    void moveStoreEntryUpAction() {
        StyleStoreEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return;
        }
        String nodeName = entry.getName();
        IStyleStore store = this.getSelectedStore();
        store.moveUp(nodeName);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        int index = this.findInNode(root, store.getStoreName());
        DefaultMutableTreeNode storeNode = (DefaultMutableTreeNode)root.getChildAt(index);
        index = this.findInNode(storeNode, nodeName);
        if (index <= 0) {
            return;
        }
        DefaultMutableTreeNode entryNode = (DefaultMutableTreeNode)storeNode.getChildAt(index);
        storeNode.remove(index);
        storeNode.insert(entryNode, index - 1);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(storeNode);
    }

    void moveStoreEntryDownAction() {
        StyleStoreEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return;
        }
        String nodeName = entry.getName();
        IStyleStore store = this.getSelectedStore();
        store.moveDown(nodeName);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        int index = this.findInNode(root, store.getStoreName());
        DefaultMutableTreeNode storeNode = (DefaultMutableTreeNode)root.getChildAt(index);
        index = this.findInNode(storeNode, nodeName);
        if (index >= storeNode.getChildCount() - 1) {
            return;
        }
        DefaultMutableTreeNode entryNode = (DefaultMutableTreeNode)storeNode.getChildAt(index);
        storeNode.remove(index);
        storeNode.insert(entryNode, index + 1);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(storeNode);
    }

    void savePlotterStyleAction() {
    }

    void editStoreEntry() {
        StoreEntryNode node = null;
        Object obj = this.tree.getLastSelectedPathComponent();
        if (!(obj instanceof StoreEntryNode)) {
            return;
        }
        node = (StoreEntryNode)obj;
        this.showEntryPage(node);
    }

    void exitAction() {
        int n = this.tabbedPanel.getTabCount();
        for (int i = n - 1; i >= 0; --i) {
            Component comp = this.tabbedPanel.getComponentAt(i);
            if (comp instanceof StoreEntryEditorPanel) {
                ((StoreEntryEditorPanel)comp).close();
            }
            this.tabbedPanel.removeTabAt(i);
        }
        System.exit(0);
    }

    void doubleClickAction(MouseEvent e) {
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selRow == -1) {
            return;
        }
        StoreEntryNode node = null;
        Object obj = this.tree.getLastSelectedPathComponent();
        if (!(obj instanceof StoreEntryNode)) {
            return;
        }
        node = (StoreEntryNode)obj;
        this.showEntryPage(node);
    }

    void popupAction(MouseEvent e) {
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selRow == -1) {
            return;
        }
        this.tree.setSelectionPath(selPath);
        Object obj = this.tree.getLastSelectedPathComponent();
        this.enableMenus();
        if (obj instanceof StoreEntryNode) {
            this.entryMenu.show(this.tree, e.getX(), e.getY());
        } else if (obj instanceof DefaultMutableTreeNode) {
            this.storeMenu.show(this.tree, e.getX(), e.getY());
        }
    }

    private void enableMenus() {
    }

    private void showEntryPage(StoreEntryNode node) {
        int index;
        JComponent page = node.getPage();
        if (page == null) {
            page = new StoreEntryEditorPanel(node.getStoreEntry());
            node.setPage(page);
        }
        if ((index = this.tabbedPanel.indexOfComponent(page)) >= 0) {
            this.tabbedPanel.setSelectedIndex(index);
        } else {
            this.tabbedPanel.addTab(node.getName(), page);
            this.tabbedPanel.setSelectedComponent(page);
        }
    }

    private StyleStoreEntry getSelectedEntry() {
        StyleStoreEntry entry = null;
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj instanceof StoreEntryNode) {
            entry = ((StoreEntryNode)obj).getStoreEntry();
        }
        return entry;
    }

    private IStyleStore getSelectedStore() {
        Object obj;
        IStyleStore store = null;
        Object node = this.tree.getLastSelectedPathComponent();
        if (node instanceof StoreEntryNode) {
            store = (IStyleStore)((DefaultMutableTreeNode)((StoreEntryNode)node).getParent()).getUserObject();
        } else if (node instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof IStyleStore) {
            store = (IStyleStore)obj;
        }
        return store;
    }

    private int findInNode(DefaultMutableTreeNode node, String childName) {
        int index = -1;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            String tmpName = null;
            if (child instanceof StoreEntryNode) {
                tmpName = ((StoreEntryNode)child).getName();
            } else if (child != null) {
                tmpName = child.toString();
            }
            if (!childName.equals(tmpName)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void main(String[] args) {
        StyleStoreEditor editor = new StyleStoreEditor();
        JFrame frame = new JFrame("Style Store Editor");
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        editor.addMenus(menuBar);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", editor);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setSize(700, 600);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
}

