/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSet;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.style.registry.JELRule;
import hep.aida.ref.plotter.style.registry.StyleStoreEntry;
import hep.aida.ref.xml.AidaStyleXMLReader;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.freehep.application.RecentItemTextField;
import org.freehep.application.studio.Studio;
import org.jdom.JDOMException;

public class AddStyleStoreEntryPanel
extends JPanel {
    private Component parent;
    private String title;
    private JPanel thisPanel;
    private JTextField styleName = new JTextField(15);
    private RecentItemTextField inputFile = new RecentItemTextField("hep.aida.ref.plotter.style.registry.AddStyleStoreEntryPanel.InputFile", 15, false);
    private JFileChooser inputChooser = new JFileChooser();
    private JButton browse;
    private JRadioButton createNew;
    private JRadioButton createFromFile;
    private JComboBox previewType;

    public AddStyleStoreEntryPanel() {
        this(null, "Add Style Store Entry");
    }

    public AddStyleStoreEntryPanel(Component parent) {
        this(parent, "Add Style Store Entry");
    }

    public AddStyleStoreEntryPanel(String title) {
        this(null, title);
    }

    public AddStyleStoreEntryPanel(Component parent, String title) {
        this.parent = parent;
        this.title = title;
        this.thisPanel = this;
        this.initComponents();
    }

    private void initComponents() {
        Class[] types = new Class[]{IHistogram1D.class, IHistogram2D.class, IDataPointSet.class};
        this.previewType = new JComboBox<Class>(types);
        this.previewType.setSelectedIndex(0);
        this.browse = new JButton("Browse...");
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String fileName = AddStyleStoreEntryPanel.this.inputFile.getText();
                int returnVal = AddStyleStoreEntryPanel.this.inputChooser.showOpenDialog(AddStyleStoreEntryPanel.this.thisPanel);
                if (returnVal == 0) {
                    File file = AddStyleStoreEntryPanel.this.inputChooser.getSelectedFile();
                    fileName = file.getAbsolutePath();
                    AddStyleStoreEntryPanel.this.inputFile.setText(fileName);
                }
            }
        });
        this.createNew = new JRadioButton("Create New Style ");
        this.createNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() instanceof JRadioButton) {
                    boolean selected = ((JRadioButton)ev.getSource()).isSelected();
                    AddStyleStoreEntryPanel.this.inputFile.setEnabled(!selected);
                    AddStyleStoreEntryPanel.this.browse.setEnabled(!selected);
                }
            }
        });
        this.createFromFile = new JRadioButton("Read Style from File ");
        this.createFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() instanceof JRadioButton) {
                    boolean selected = ((JRadioButton)ev.getSource()).isSelected();
                    AddStyleStoreEntryPanel.this.inputFile.setEnabled(selected);
                    AddStyleStoreEntryPanel.this.browse.setEnabled(selected);
                }
            }
        });
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this.createNew);
        rbg.add(this.createFromFile);
        this.createNew.setSelected(true);
        this.inputFile.setEnabled(false);
        this.browse.setEnabled(false);
        this.setBorder(new TitledBorder(new EtchedBorder(), this.title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Style Name: "), gbc);
        gbc.gridx = 1;
        this.add((Component)this.styleName, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.add((Component)this.createNew, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        this.add((Component)this.createFromFile, gbc);
        gbc.gridx = 1;
        this.add((Component)this.inputFile, gbc);
        gbc.gridx = 2;
        this.add((Component)this.browse, gbc);
        gbc.gridy = 3;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Style Preview: "), gbc);
        gbc.gridx = 1;
        this.add((Component)this.previewType, gbc);
    }

    IPlotterStyle createStyleAction() {
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        return style;
    }

    IPlotterStyle readStyleAction() throws IOException, JDOMException {
        IPlotterStyle style = null;
        Object file = null;
        String fileName = this.inputFile.getText();
        style = AidaStyleXMLReader.restoreFromFile(fileName);
        return style;
    }

    public StyleStoreEntry createStoreEntry() throws IOException, JDOMException {
        StyleStoreEntry entry = null;
        Component comp = this.parent;
        if (comp == null) {
            comp = SwingUtilities.getAncestorOfClass(Frame.class, this);
        }
        boolean wrongInput = true;
        while (wrongInput) {
            int reply = JOptionPane.showOptionDialog(comp, this, this.title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
            try {
                if (reply == 0) {
                    String sn = this.styleName.getText();
                    if (sn == null || sn.trim().equals("")) {
                        throw new IllegalArgumentException("Style Name can not be Empty, please correct");
                    }
                    String fileName = this.inputFile.getText();
                    IPlotterStyle style = null;
                    if (this.createNew.isSelected()) {
                        style = this.createStyleAction();
                    } else {
                        this.readStyleAction();
                    }
                    entry = new StyleStoreEntry(this.styleName.getText(), style, new JELRule());
                    Class preview = (Class)this.previewType.getSelectedItem();
                    if (preview != null) {
                        entry.setPreviewType(preview);
                    }
                    this.inputFile.saveState();
                }
                wrongInput = false;
            }
            catch (Exception e) {
                String message = "Error: " + e.getMessage();
                if (this.parent != null && this.parent instanceof Studio) {
                    Studio cfr_ignored_0 = (Studio)this.parent;
                    Studio.error((Component)this, (String)message, (Throwable)e);
                }
                e.printStackTrace();
            }
        }
        return entry;
    }
}

