/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import hep.aida.ref.AidaUtils;
import hep.aida.ref.plotter.RevolvingColorStyleParameter;
import hep.aida.ref.plotter.RevolvingStyleParameter;
import hep.aida.ref.plotter.style.editor.StylePropertyState;
import hep.aida.ref.plotter.style.editor.StylePropertyTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import org.freehep.application.studio.Studio;
import org.freehep.swing.ColorConverter;

public class StylePropertyEditColumnEditor
extends DefaultCellEditor {
    static int minTextFieldLength = 20;
    static int maxTextFieldLength = 80;
    protected Studio app = (Studio)Studio.getApplication();
    protected StylePropertyState oldValue;
    protected StylePropertyState currentValue;
    protected JButton button;
    protected JTextField valueField;
    protected JTextField defaultField;
    protected JTextField optionsField;
    protected JButton valColor;
    protected JButton defColor;
    private JColorChooser colorChooser;
    private JDialog colorChooserDialog;
    private OkListener okListener;
    private boolean addColor;
    protected JPanel panel;
    protected StylePropertyTable table;
    protected int row;
    protected int column;

    public StylePropertyEditColumnEditor(StylePropertyTable table, int row, int column) {
        super(new JCheckBox());
        this.table = table;
        this.row = row;
        this.column = column;
        this.currentValue = new StylePropertyState();
        this.setClickCountToStart(1);
        this.button = new JButton("Edit...");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StylePropertyEditColumnEditor.this.editValue();
                StylePropertyEditColumnEditor.this.fireEditingStopped();
            }
        });
        this.editorComponent = this.button;
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        return "Edit...";
    }

    protected void createPanel() {
        if (this.panel != null) {
            return;
        }
        this.defaultField = new JTextField(minTextFieldLength);
        this.valueField = new JTextField(minTextFieldLength);
        this.optionsField = new JTextField(2 * minTextFieldLength);
        this.valColor = new JButton("Color");
        this.valColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Class t = StylePropertyEditColumnEditor.this.currentValue.type;
                if (t == (class$hep$aida$ref$plotter$RevolvingStyleParameter == null ? (class$hep$aida$ref$plotter$RevolvingStyleParameter = StylePropertyEditColumnEditor.class$("hep.aida.ref.plotter.RevolvingStyleParameter")) : class$hep$aida$ref$plotter$RevolvingStyleParameter) || t == (class$hep$aida$ref$plotter$RevolvingColorStyleParameter == null ? (class$hep$aida$ref$plotter$RevolvingColorStyleParameter = StylePropertyEditColumnEditor.class$("hep.aida.ref.plotter.RevolvingColorStyleParameter")) : class$hep$aida$ref$plotter$RevolvingColorStyleParameter)) {
                    StylePropertyEditColumnEditor.this.addColor = true;
                    StylePropertyEditColumnEditor.this.chooseColor(StylePropertyEditColumnEditor.this.valueField);
                } else {
                    StylePropertyEditColumnEditor.this.addColor = false;
                    StylePropertyEditColumnEditor.this.chooseColor(StylePropertyEditColumnEditor.this.valueField);
                }
            }
        });
        this.defColor = new JButton("Color");
        this.defColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Class t = StylePropertyEditColumnEditor.this.currentValue.type;
                if (t == (class$hep$aida$ref$plotter$RevolvingStyleParameter == null ? (class$hep$aida$ref$plotter$RevolvingStyleParameter = StylePropertyEditColumnEditor.class$("hep.aida.ref.plotter.RevolvingStyleParameter")) : class$hep$aida$ref$plotter$RevolvingStyleParameter) || t == (class$hep$aida$ref$plotter$RevolvingColorStyleParameter == null ? (class$hep$aida$ref$plotter$RevolvingColorStyleParameter = StylePropertyEditColumnEditor.class$("hep.aida.ref.plotter.RevolvingColorStyleParameter")) : class$hep$aida$ref$plotter$RevolvingColorStyleParameter)) {
                    StylePropertyEditColumnEditor.this.addColor = true;
                    StylePropertyEditColumnEditor.this.chooseColor(StylePropertyEditColumnEditor.this.defaultField);
                } else {
                    StylePropertyEditColumnEditor.this.addColor = false;
                    StylePropertyEditColumnEditor.this.chooseColor(StylePropertyEditColumnEditor.this.defaultField);
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        panel1.add((Component)new JLabel("Current Value: "), gbc);
        gbc.gridx = 1;
        panel1.add((Component)this.valueField, gbc);
        gbc.gridx = 2;
        panel1.add((Component)this.valColor, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        panel1.add((Component)new JLabel("Default Value: "), gbc);
        gbc.gridx = 1;
        panel1.add((Component)this.defaultField, gbc);
        gbc.gridx = 2;
        panel1.add((Component)this.defColor, gbc);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        panel2.add((Component)new JLabel("Possible Values: "), gbc);
        gbc.gridx = 1;
        panel2.add((Component)this.optionsField, gbc);
        this.panel = new JPanel();
        this.panel.setBorder(new EtchedBorder());
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(panel1);
        this.panel.add(panel2);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return this.editorComponent;
    }

    public void getPropertyValue() {
        Object value = this.table.getValueAt(this.row, 1);
        String valueString = null;
        if (value instanceof StylePropertyState) {
            valueString = ((StylePropertyState)value).toString(true);
        } else if (value != null) {
            valueString = value.toString();
        }
        this.oldValue = new StylePropertyState(this.currentValue);
        if (value == null) {
            this.currentValue.clear();
        } else {
            this.currentValue = (StylePropertyState)value;
        }
        Class t = this.currentValue.type;
        if (t == Color.class || t == RevolvingColorStyleParameter.class) {
            this.valColor.setEnabled(true);
            this.valColor.setVisible(true);
            this.defColor.setEnabled(true);
            this.defColor.setVisible(true);
            this.currentValue.values = null;
            this.optionsField.setEditable(false);
        } else if (t == RevolvingStyleParameter.class) {
            this.valColor.setEnabled(false);
            this.valColor.setVisible(false);
            this.defColor.setEnabled(false);
            this.defColor.setVisible(false);
            this.currentValue.values = null;
            this.optionsField.setEditable(false);
        } else {
            this.valColor.setEnabled(false);
            this.valColor.setVisible(false);
            this.defColor.setEnabled(false);
            this.defColor.setVisible(false);
            this.optionsField.setEditable(true);
        }
    }

    public void setPropertyValue() {
        this.table.setValueAt(new StylePropertyState(this.currentValue), this.row, 1);
    }

    public void resetComponents() {
        Object tmp;
        String valueString = "";
        if (this.currentValue.values != null) {
            for (int i = 0; i < this.currentValue.values.length; ++i) {
                String val = "";
                tmp = this.currentValue.values[i];
                if (tmp instanceof String) {
                    val = (String)tmp;
                } else if (tmp instanceof Color) {
                    val = ColorConverter.get((Color)((Color)tmp));
                } else {
                    if (tmp == null) continue;
                    val = tmp.toString();
                }
                if (val == null || val.trim().equals("")) continue;
                valueString = valueString + "\"" + val + "\", ";
            }
        }
        this.optionsField.setText(valueString.trim());
        if (valueString.length() > minTextFieldLength && valueString.length() < maxTextFieldLength) {
            this.optionsField.setColumns(valueString.length() + 10);
        }
        String val = "";
        String def = "";
        if (this.currentValue != null) {
            tmp = this.currentValue.currentValue;
            if (tmp instanceof String) {
                val = (String)tmp;
            } else if (tmp instanceof Color) {
                val = ColorConverter.get((Color)((Color)tmp));
            } else if (tmp != null) {
                val = tmp.toString();
            }
            tmp = this.currentValue.defaultValue;
            if (tmp instanceof String) {
                def = (String)tmp;
            } else if (tmp instanceof Color) {
                def = ColorConverter.get((Color)((Color)tmp));
            } else if (tmp != null) {
                def = tmp.toString();
            }
        }
        this.valueField.setText(val);
        this.defaultField.setText(def);
        if (val.length() > minTextFieldLength && val.length() < maxTextFieldLength) {
            this.valueField.setColumns(val.length() + 10);
        }
        if (def.length() > minTextFieldLength && def.length() < maxTextFieldLength) {
            this.defaultField.setColumns(def.length() + 10);
        }
    }

    public void resetValue() throws Exception {
        String val = null;
        String def = null;
        String[] opt = null;
        String tmp = this.defaultField.getText().trim();
        if (tmp.equals("")) {
            tmp = null;
        }
        def = tmp;
        tmp = this.optionsField.getText().trim();
        String[] strArray = null;
        if (tmp != null && !tmp.equals("")) {
            strArray = AidaUtils.parseString(tmp);
        }
        opt = strArray;
        tmp = this.valueField.getText().trim();
        if (tmp.equals("")) {
            tmp = null;
        }
        val = tmp;
        this.checkInput(val, def, opt);
        this.currentValue.values = opt;
        this.currentValue.defaultValue = def;
        this.currentValue.currentValue = val;
    }

    protected void editValue() {
        if (this.panel == null) {
            this.createPanel();
        }
        this.getPropertyValue();
        this.resetComponents();
        String title = "Edit Style Property";
        boolean wrongInput = true;
        while (wrongInput) {
            int reply = JOptionPane.showOptionDialog(this.button, this.panel, title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
            try {
                if (reply == 0) {
                    this.oldValue = new StylePropertyState(this.currentValue);
                    this.resetValue();
                    this.resetComponents();
                    this.setPropertyValue();
                } else {
                    this.resetComponents();
                }
                wrongInput = false;
            }
            catch (Exception e) {
                if (this.app != null) {
                    this.app.error("Wrong input: \n\t" + e.getMessage(), (Throwable)e);
                }
                String message = "Error: " + e.getMessage();
                e.printStackTrace();
            }
        }
    }

    protected void checkInput(String val, String def, String[] opt) throws Exception {
        block16: {
            Class t;
            block18: {
                block17: {
                    block15: {
                        t = this.currentValue.type;
                        if (t == null || t == String.class || t == Boolean.TYPE) {
                            return;
                        }
                        if (t != Double.TYPE) break block15;
                        if (val != null) {
                            double d = Double.parseDouble(val);
                        }
                        if (def != null) {
                            double d = Double.parseDouble(def);
                        }
                        if (opt == null) break block16;
                        for (int i = 0; i < opt.length; ++i) {
                            double o = Double.parseDouble(opt[i]);
                        }
                        break block16;
                    }
                    if (t != Float.TYPE) break block17;
                    if (val != null) {
                        float f = Float.parseFloat(val);
                    }
                    if (def != null) {
                        float f = Float.parseFloat(def);
                    }
                    if (opt == null) break block16;
                    for (int i = 0; i < opt.length; ++i) {
                        float o = Float.parseFloat(opt[i]);
                    }
                    break block16;
                }
                if (t != Integer.TYPE) break block18;
                if (val != null) {
                    int n = Integer.parseInt(val);
                }
                if (def != null) {
                    int n = Integer.parseInt(def);
                }
                if (opt == null) break block16;
                for (int i = 0; i < opt.length; ++i) {
                    int o = Integer.parseInt(opt[i]);
                }
                break block16;
            }
            if (t == Color.class) {
                if (val != null) {
                    Color color = ColorConverter.get((String)val);
                }
                if (def != null) {
                    Color color = ColorConverter.get((String)def);
                }
                if (opt != null) {
                    for (int i = 0; i < opt.length; ++i) {
                        Color o = ColorConverter.get((String)opt[i]);
                    }
                }
            }
        }
    }

    protected void chooseColor(JTextField field) {
        String title = "Choose Color";
        Object initialColor = null;
        if (this.okListener == null) {
            this.okListener = new OkListener(field);
        } else {
            this.okListener.setField(field);
        }
        if (this.colorChooserDialog == null) {
            this.colorChooser = ColorConverter.getColorChooser();
            this.colorChooserDialog = JColorChooser.createDialog(this.panel, title, true, this.colorChooser, this.okListener, null);
            this.colorChooserDialog.pack();
        }
        this.colorChooserDialog.setVisible(true);
    }

    protected void okAction(JTextField field) {
        try {
            Color selectedColor = this.colorChooser.getColor();
            String colorString = ColorConverter.get((Color)selectedColor);
            if (colorString != null && !colorString.trim().equals("")) {
                if (this.addColor) {
                    String tmp = field.getText();
                    if (tmp == null) {
                        tmp = "";
                    }
                    tmp = tmp + ", \"" + colorString + "\"";
                    field.setText(tmp);
                } else {
                    field.setText(colorString);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class OkListener
    implements ActionListener {
        private JTextField field;

        OkListener(JTextField field) {
            this.field = field;
        }

        private void setField(JTextField field) {
            this.field = field;
        }

        public void actionPerformed(ActionEvent e) {
            StylePropertyEditColumnEditor.this.okAction(this.field);
        }
    }
}

