/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.ICloud;
import hep.aida.ICloud1D;
import hep.aida.IHistogram1D;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.plotter.adapter.AIDACloudAdapter;
import hep.aida.ref.plotter.adapter.AIDACloudStatistics1D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;

public class AIDACloudAdapter1D
extends AIDACloudAdapter
implements Rebinnable1DHistogramData,
HasStatistics {
    private ICloud1D cloud;
    private int nBins = 50;

    public AIDACloudAdapter1D(ICloud1D cloud) {
        super((ICloud)cloud);
        this.cloud = cloud;
        String tmp = null;
        try {
            tmp = cloud.annotation().value("xAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        IHistogram1D histo = null;
        this.setValid();
        if (this.isRebinnable()) {
            histo = HistUtils.toShowableHistogram(this.cloud, bins, min, max);
            this.nBins = bins;
        } else {
            histo = this.cloud.histogram();
        }
        double[][] data = new double[2][histo.axis().bins()];
        for (int i = 0; i < histo.axis().bins(); ++i) {
            data[0][i] = histo.binHeight(i);
            if (Double.isInfinite(data[0][i])) {
                data[0][i] = Double.NaN;
            }
            data[1][i] = histo.binError(i);
        }
        return data;
    }

    public double getMin() {
        if (this.isRebinnable()) {
            if (this.cloud instanceof Cloud1D) {
                return ((Cloud1D)this.cloud).lowerEdgeWithMargin();
            }
            double edge = this.cloud.lowerEdge();
            if (Double.isNaN(edge)) {
                return Double.NaN;
            }
            return edge - this.getMarginValue(edge, this.cloud.upperEdge());
        }
        return this.cloud.histogram().axis().lowerEdge();
    }

    public double getMax() {
        if (this.isRebinnable()) {
            if (this.cloud instanceof Cloud1D) {
                return ((Cloud1D)this.cloud).upperEdgeWithMargin();
            }
            double edge = this.cloud.upperEdge();
            if (Double.isNaN(edge)) {
                return Double.NaN;
            }
            return edge + this.getMarginValue(this.cloud.lowerEdge(), edge);
        }
        return this.cloud.histogram().axis().upperEdge();
    }

    public int getBins() {
        return this.isRebinnable() ? this.nBins : this.cloud.histogram().axis().bins();
    }

    public boolean isRebinnable() {
        return !this.cloud.isConverted();
    }

    public int getAxisType() {
        return this.xAxisType;
    }

    public void setAxisType(int type) {
        this.xAxisType = type;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.cloud.title();
    }

    public Statistics getStatistics() {
        return new AIDACloudStatistics1D(this.cloud);
    }
}

