/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IAnnotation;
import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.IBoxStyle;
import hep.aida.ICloud;
import hep.aida.IDataPointSet;
import hep.aida.IDataStyle;
import hep.aida.IFillStyle;
import hep.aida.IFunction;
import hep.aida.IHistogram;
import hep.aida.IInfo;
import hep.aida.ILineStyle;
import hep.aida.IMarkerStyle;
import hep.aida.IPlottable;
import hep.aida.IPlotter;
import hep.aida.IPlotterLayout;
import hep.aida.IPlotterRegion;
import hep.aida.IPlotterStyle;
import hep.aida.IProfile;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.function.RangeSet;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.BrushStyle;
import hep.aida.ref.plotter.DataPointSetPlotterStyle;
import hep.aida.ref.plotter.DummyPlotter;
import hep.aida.ref.plotter.Info;
import hep.aida.ref.plotter.LineStyle;
import hep.aida.ref.plotter.MarkerStyle;
import hep.aida.ref.plotter.PlotterFontUtil;
import hep.aida.ref.plotter.PlotterLayout;
import hep.aida.ref.plotter.PlotterStyle;
import hep.aida.ref.plotter.StyleListener;
import hep.aida.ref.plotter.adapter.AIDAAdapter;
import hep.aida.ref.plotter.adapter.AIDACloudAdapter1D;
import hep.aida.ref.plotter.adapter.AIDACloudAdapter2D;
import hep.aida.ref.plotter.adapter.AIDADataPointSetAdapter;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter1D;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter2D;
import hep.aida.ref.plotter.adapter.AIDAProfileAdapter;
import hep.aida.ref.plotter.adapter.CanSetData;
import hep.aida.ref.plotter.adapter.CanSetStyle;
import hep.aida.ref.plotter.style.registry.IGlobalIndexProvider;
import hep.aida.ref.plotter.style.registry.IPlotterState;
import hep.aida.ref.plotter.style.registry.IStyleRegistry;
import hep.aida.ref.plotter.style.registry.PlotterState;
import hep.aida.ref.plotter.style.registry.StyleRegistry;
import jas.hist.CustomOverlay;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.StatisticsBlock;
import jas.hist.normalization.AreaNormalizer;
import jas.hist.normalization.EntriesNormalizer;
import jas.hist.normalization.MaxBinNormalizer;
import jas.hist.normalization.Normalizer;
import jas.hist.normalization.RelativeNormalizer;
import jas.hist.normalization.SimpleNormalizer;
import jas.plot.EditableLabel;
import jas.plot.HasPopupItems;
import jas.plot.Legend;
import jas.plot.MovableObject;
import jas.plot.Title;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.PrintHelper;
import org.freehep.application.studio.Studio;
import org.freehep.swing.ColorConverter;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.export.ExportDialog;
import org.freehep.util.export.VectorGraphicsTransferable;

public class PlotterRegion
implements IPlotterRegion,
StyleListener {
    private static final String[] emptyArray = new String[0];
    private JASHist plot;
    private JPanel panel;
    private ArrayList dataStyleList = new ArrayList();
    private ArrayList dataList = new ArrayList();
    private IPlotterStyle plotterStyle = new PlotterStyle();
    private IPlotterLayout plotterLayout = new PlotterLayout();
    private IInfo info = new Info();
    private List queue = new ArrayList();
    private String regionTitle = null;
    static final String[] styleKeys = new String[]{"AxisLabel", "AxisScale", "AxisType"};
    static final String[] stylePars = new String[]{"label", "scale", "type"};
    static final String overlayKey = "customOverlay";
    static final String timeZoneKey = "timeZone";
    public final int REPLACE = 0;
    public final int OVERLAY = 1;
    public final int ADD = 2;
    public final int STACK = 3;
    public static final String USE_EXACT_STYLE = "USE_EXACT_STYLE";
    private int defaultMode = 1;
    private String[] parameters = new String[]{"xAxisLowerLimit", "xAxisUpperLimit", "yAxisLowerLimit", "yAxisUpperLimit"};
    private IPlotter plotter;
    private StyleListener styleListener;
    static /* synthetic */ Class class$java$awt$Component;

    public PlotterRegion(JPanel panel, IPlotter plotter) {
        this.panel = panel;
        panel.setLayout(new BorderLayout());
        panel.setOpaque(false);
        this.plotter = plotter;
        String styleName = "RegionStyle";
        if (plotter != null) {
            styleName = "RegionStyle.";
        }
        if (this.plotterStyle != null) {
            this.plotterStyle.setParameter("plotterStyleName", styleName);
        }
        this.styleListener = this;
        if (FreeHEPLookup.instance().lookup(StyleRegistry.class) == null) {
            FreeHEPLookup.instance().add((Object)StyleRegistry.getStyleRegistry());
        }
    }

    public PlotterRegion(IPlotter plotter) {
        this(new JPanel(), plotter);
    }

    public IPlotterStyle getStyleForNumber(int num) {
        return ((DataStyleEntry)this.dataStyleList.get(num)).style();
    }

    public IPlotterStyle getStyleForName(String name) {
        IPlotterStyle st = null;
        int n = this.dataStyleList.size();
        for (int i = 0; i < n; ++i) {
            if (!((DataStyleEntry)this.dataStyleList.get(i)).data().getTitle().equals(name)) continue;
            st = ((DataStyleEntry)this.dataStyleList.get(i)).style();
            break;
        }
        return st;
    }

    public JASHistData getDataForName(String name) {
        JASHistData st = null;
        int n = this.dataStyleList.size();
        for (int i = 0; i < n; ++i) {
            if (!((DataStyleEntry)this.dataStyleList.get(i)).data().getTitle().equals(name)) continue;
            st = ((DataStyleEntry)this.dataStyleList.get(i)).data();
            break;
        }
        return st;
    }

    public String[] getAllDataNames() {
        int n = this.dataStyleList.size();
        String[] tmp = new String[n];
        for (int i = 0; i < n; ++i) {
            tmp[i] = ((DataStyleEntry)this.dataStyleList.get(i)).data().getTitle();
        }
        return tmp;
    }

    JPanel getPanel() {
        return this.panel;
    }

    public String[] availableParameterOptions(String str) {
        return emptyArray;
    }

    public String[] availableParameters() {
        return this.parameters;
    }

    public void setParameter(String str) {
    }

    public void setParameter(String str, String str1) {
    }

    public String parameterValue(String str) {
        if (str.equals(this.parameters[0])) {
            return String.valueOf(this.getPlot().getXAxis().getMin());
        }
        if (str.equals(this.parameters[1])) {
            return String.valueOf(this.getPlot().getXAxis().getMax());
        }
        if (str.equals(this.parameters[2])) {
            return String.valueOf(this.getPlot().getYAxis().getMin());
        }
        if (str.equals(this.parameters[3])) {
            return String.valueOf(this.getPlot().getYAxis().getMax());
        }
        return null;
    }

    public void styleChanged(BaseStyle style) {
        for (int i = 0; i < this.dataStyleList.size(); ++i) {
            DataStyleEntry dse = (DataStyleEntry)this.dataStyleList.get(i);
            if (style != dse.style()) continue;
            PlotterRegion.invokeOnSwingThread(dse);
        }
    }

    public IPlotterStyle style() {
        String styleName = "RegionStyle";
        if (this.plotter != null) {
            styleName = "RegionStyle." + this.plotter.currentRegionNumber();
        }
        if (this.plotterStyle != null) {
            this.plotterStyle.setParameter("plotterStyleName", styleName);
        }
        return this.plotterStyle;
    }

    public void setStyle(IPlotterStyle style) {
        if (this.plotterStyle != null && style != this.plotterStyle) {
            this.plotterStyle.reset();
        }
        if (style != this.plotterStyle) {
            this.plotterStyle = style;
            String styleName = "RegionStyle";
            if (this.plotter != null) {
                styleName = "RegionStyle." + this.plotter.currentRegionNumber();
            }
            if (this.plotterStyle != null) {
                this.plotterStyle.setParameter("plotterStyleName", styleName);
            }
            this.refresh();
        }
    }

    public void applyStyle(IPlotterStyle style) {
        this.setStyle(style);
    }

    public void setTitle(String title) {
        PlotterRegion.invokeOnSwingThread(new TitleChanged(title));
    }

    public String title() {
        return this.regionTitle;
    }

    public void setXLimits() throws IllegalArgumentException {
        this.setXLimits(Double.NaN, Double.NaN);
    }

    public void setXLimits(double min) {
        this.setXLimits(min, Double.NaN);
    }

    public void setXLimits(double min, double max) throws IllegalArgumentException {
        LimitsChanged run = new LimitsChanged(0, min, max);
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            this.addToQueue(run);
        } else {
            PlotterRegion.invokeOnSwingThread(run);
        }
    }

    public void setYLimits() throws IllegalArgumentException {
        this.setYLimits(Double.NaN, Double.NaN);
    }

    public void setYLimits(double min) {
        this.setYLimits(min, Double.NaN);
    }

    public void setYLimits(double min, double max) throws IllegalArgumentException {
        this.setYLimits("Y0", min, max);
    }

    public void setYLimits(String axisString) {
        this.setYLimits(axisString, Double.NaN, Double.NaN);
    }

    public void setYLimits(String axisString, double min) {
        this.setYLimits(axisString, min, Double.NaN);
    }

    public void setYLimits(String axisString, double min, double max) throws IllegalArgumentException {
        int axis = 0;
        int limitsAxis = 1;
        if (axisString != null && axisString.trim().equalsIgnoreCase("Y1")) {
            axis = 1;
            limitsAxis = 11;
        }
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            throw new RuntimeException("No plot available");
        }
        if (this.getPlot().getYAxis(axis) == null) {
            throw new RuntimeException("Y Axis #" + axis + " has not been created yet");
        }
        LimitsChanged run = new LimitsChanged(limitsAxis, min, max);
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            this.addToQueue(run);
        } else {
            PlotterRegion.invokeOnSwingThread(run);
        }
    }

    public void setZLimits() throws IllegalArgumentException {
        this.setZLimits(Double.NaN, Double.NaN);
    }

    public void setZLimits(double min) {
        this.setZLimits(min, Double.NaN);
    }

    public void setZLimits(double min, double max) throws IllegalArgumentException {
        LimitsChanged run = new LimitsChanged(2, min, max);
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            this.addToQueue(run);
        } else {
            PlotterRegion.invokeOnSwingThread(run);
        }
    }

    public double xLimitMin() {
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            throw new RuntimeException("No plot available");
        }
        return this.getPlot().getXAxis().getMin();
    }

    public double xLimitMax() {
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            throw new RuntimeException("No plot available");
        }
        return this.getPlot().getXAxis().getMax();
    }

    public double yLimitMin() {
        return this.yLimitMin("Y0");
    }

    public double yLimitMin(String axisString) {
        int axis = 0;
        if (axisString != null && axisString.trim().equalsIgnoreCase("Y1")) {
            axis = 1;
        }
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            throw new RuntimeException("No plot available");
        }
        if (this.getPlot().getYAxis(axis) == null) {
            throw new RuntimeException("Y Axis #" + axis + " has not been created yet");
        }
        return this.getPlot().getYAxis(axis).getMin();
    }

    public double yLimitMax() {
        return this.yLimitMax("Y0");
    }

    public double yLimitMax(String axisString) {
        int axis = 0;
        if (axisString != null && axisString.trim().equalsIgnoreCase("Y1")) {
            axis = 1;
        }
        if (this.getPlot() == null || this.getPlot().getNumberOfDataSources() == 0) {
            throw new RuntimeException("No plot available");
        }
        if (this.getPlot().getYAxis(axis) == null) {
            throw new RuntimeException("Y Axis #" + axis + " has not been created yet");
        }
        return this.getPlot().getYAxis(axis).getMax();
    }

    public double zLimitMin() {
        throw new UnsupportedOperationException();
    }

    public double zLimitMax() {
        throw new UnsupportedOperationException();
    }

    private synchronized void addToQueue(Runnable run) {
        if (this.queue == null) {
            this.queue = new ArrayList();
        }
        this.queue.add(run);
    }

    public IInfo info() {
        return this.info;
    }

    public void setInfo(IInfo info) {
        this.info = info;
    }

    public void clear() {
        PlotterRegion.invokeOnSwingThread(new ClearRegion());
    }

    public void plot(IPlottable plottable) throws IllegalArgumentException {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, plottable));
    }

    public void plot(IPlottable plottable, String options) throws IllegalArgumentException {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, plottable, null, options));
    }

    public void plot(IPlottable plottable, IPlotterStyle style) throws IllegalArgumentException {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, plottable, style));
    }

    public void plot(IPlottable plottable, IPlotterStyle style, String options) throws IllegalArgumentException {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, plottable, style, options));
    }

    public void plot(IBaseHistogram iBaseHistogram) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram));
    }

    public void plot(IBaseHistogram iBaseHistogram, IPlotterStyle style) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram, style));
    }

    public void plot(IBaseHistogram iBaseHistogram, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram, null, options));
    }

    public void plot(IBaseHistogram iBaseHistogram, IPlotterStyle style, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram, style, options));
    }

    public void plot(IDataPointSet iDataPointSet) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet));
    }

    public void plot(IDataPointSet iDataPointSet, IPlotterStyle style) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet, style));
    }

    public void plot(IDataPointSet iDataPointSet, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet, null, options));
    }

    public void plot(IDataPointSet iDataPointSet, IPlotterStyle style, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet, style, options));
    }

    public void plot(IFunction iFunction) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction));
    }

    public void plot(IFunction iFunction, IPlotterStyle style) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction, style));
    }

    public void plot(IFunction iFunction, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction, null, options));
    }

    public void plot(IFunction iFunction, IPlotterStyle style, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction, style, options));
    }

    public void remove(IDataPointSet iDataPointSet) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, iDataPointSet));
    }

    public void remove(IFunction iFunction) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, iFunction));
    }

    public void remove(IBaseHistogram iBaseHistogram) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, iBaseHistogram));
    }

    public void remove(IPlottable plottable) throws IllegalArgumentException {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, plottable));
    }

    public void setPlot(JASHist plot) {
        this.plot = plot;
    }

    public JASHist getPlot() {
        return this.plot;
    }

    public void setLayout(IPlotterLayout iPlotterLayout) {
        this.plotterLayout = iPlotterLayout;
    }

    public IPlotterLayout layout() {
        return this.plotterLayout;
    }

    public void add(Object thing, IPlotterStyle style, int mode) {
        this.add(thing, style, mode, thing, null);
    }

    public void add(Object thing, IPlotterStyle style, String options) {
        int mode = this.getMode(options);
        this.add(thing, style, mode, thing, options);
    }

    public void add(Object thing, IPlotterStyle style, int mode, String options) {
        this.add(thing, style, mode, thing, options);
    }

    public void add(Object thing, IPlotterStyle style, int mode, Object data) {
        this.add(thing, style, mode, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object thing, IPlotterStyle userStyle, int mode, Object data, String options) {
        double yAxisUpperLimit;
        String yAxisUpperLimitStr;
        double xAxisUpperLimit;
        String xAxisUpperLimitStr;
        if (mode != 0 && mode != 1) {
            throw new UnsupportedOperationException();
        }
        if (mode != 1 && (this.getPlot() != null && this.getPlot().getNumberOfDataSources() > 0 || this.dataList != null && this.dataList.size() > 0 || this.dataStyleList != null && this.dataStyleList.size() > 0)) {
            this.removeAllObjectsFromRegion();
        }
        if (this.getPlot() == null) {
            this.createPlot();
        }
        DataSource ds = null;
        Object title = null;
        if (thing instanceof DataSource) {
            ds = (DataSource)thing;
        } else if (thing instanceof IHistogram) {
            ds = AIDAAdapter.create((IHistogram)thing);
        } else if (thing instanceof ICloud) {
            ds = AIDAAdapter.create((ICloud)thing);
        } else if (thing instanceof IFunction) {
            ds = AIDAAdapter.create((IFunction)thing);
        } else if (thing instanceof IProfile) {
            ds = AIDAAdapter.create((IProfile)thing);
        } else if (thing instanceof IDataPointSet) {
            ds = AIDAAdapter.create((IDataPointSet)thing);
        } else {
            throw new IllegalArgumentException("Cannot plot object " + thing);
        }
        boolean keepUserStyle = options != null && (options.indexOf(USE_EXACT_STYLE) >= 0 || options.toUpperCase().indexOf(USE_EXACT_STYLE) >= 0);
        PlotterStyle style = null;
        style = userStyle == null || userStyle == this.plotterStyle ? new PlotterStyle() : new PlotterStyle((PlotterStyle)userStyle);
        if (!style.parameter("globalIndex").isParameterValueSet()) {
            IGlobalIndexProvider ip = (IGlobalIndexProvider)FreeHEPLookup.instance().lookup(IGlobalIndexProvider.class);
            int globalIndex = ip.getIndex();
            style.setParameter("globalIndex", String.valueOf(globalIndex));
        }
        if (!keepUserStyle) {
            if (!style.parameter("plotterStyleName").isParameterValueSet()) {
                style.setParameter("plotterStyleName", ds.getTitle());
            }
            style = (PlotterStyle)this.applyDefaultStyles(data, style, options);
        }
        this.setDefaultsFromData(data, style);
        this.applyStyleBeforeAdding(style, ds);
        if (style != null && style != this.plotterStyle) {
            this.handleLabels(style);
        }
        JASHistData jasHistData = this.getPlot().addData(ds);
        String range = this.getRange(options);
        if (range != null) {
            RangeSet rangeSet = new RangeSet(range);
            jasHistData.setXBounds(rangeSet.lowerBounds()[0], rangeSet.upperBounds()[0]);
        }
        DataStyleEntry dataStyleEntry = new DataStyleEntry(jasHistData, style, mode);
        this.dataList.add(data);
        this.dataStyleList.add(dataStyleEntry);
        String xAxisLowerLimitStr = style.xAxisStyle().parameterValue("lowerLimit");
        if (xAxisLowerLimitStr == null) {
            xAxisLowerLimitStr = style.parameterValue("xAxisLowerLimit");
        }
        if ((xAxisUpperLimitStr = style.xAxisStyle().parameterValue("upperLimit")) == null) {
            xAxisUpperLimitStr = style.parameterValue("xAxisUpperLimit");
        }
        double xAxisLowerLimit = xAxisLowerLimitStr != null ? Double.valueOf(xAxisLowerLimitStr) : Double.NaN;
        double d = xAxisUpperLimit = xAxisUpperLimitStr != null ? Double.valueOf(xAxisUpperLimitStr) : Double.NaN;
        if (!Double.isNaN(xAxisLowerLimit) || !Double.isNaN(xAxisUpperLimit)) {
            this.getPlot().getXAxis().setRange(xAxisLowerLimit, xAxisUpperLimit);
        }
        String yAxisString = style.yAxisStyle().parameterValue("yAxis");
        int yAxisIndex = 0;
        if (yAxisString != null && yAxisString.trim().equalsIgnoreCase("Y1")) {
            yAxisIndex = 1;
        }
        if (this.getPlot().getYAxis(yAxisIndex) == null) {
            throw new RuntimeException("Y Axis #" + yAxisIndex + " has not been created yet");
        }
        String yAxisLowerLimitStr = style.yAxisStyle().parameterValue("lowerLimit");
        if (yAxisLowerLimitStr == null) {
            yAxisLowerLimitStr = style.parameterValue("yAxisLowerLimit");
        }
        if ((yAxisUpperLimitStr = style.yAxisStyle().parameterValue("upperLimit")) == null) {
            yAxisUpperLimitStr = style.parameterValue("yAxisUpperLimit");
        }
        double yAxisLowerLimit = yAxisLowerLimitStr != null ? Double.valueOf(yAxisLowerLimitStr) : Double.NaN;
        double d2 = yAxisUpperLimit = yAxisUpperLimitStr != null ? Double.valueOf(yAxisUpperLimitStr) : Double.NaN;
        if (!Double.isNaN(yAxisLowerLimit) || !Double.isNaN(yAxisUpperLimit)) {
            this.getPlot().getYAxis(yAxisIndex).setRange(yAxisLowerLimit, yAxisUpperLimit);
        }
        if (this.getPlot().getNumberOfDataSources() == 1 && this.queue != null) {
            Iterator iter;
            PlotterRegion plotterRegion = this;
            synchronized (plotterRegion) {
                iter = this.queue.iterator();
                this.queue = null;
            }
            while (iter.hasNext()) {
                Runnable run = (Runnable)iter.next();
                PlotterRegion.invokeOnSwingThread(run);
            }
        }
        if (this.regionTitle != null) {
            this.getPlot().setTitle(this.regionTitle);
        }
        if (this.getPlot().getTitle() == null) {
            this.getPlot().setTitle(ds.getTitle());
            this.regionTitle = ds.getTitle();
        }
        this.applyStyle(jasHistData, style);
        jasHistData.show(true);
        this.applyStyleAfterShow(jasHistData, style);
        if (mode == 1) {
            this.refreshStyles();
        } else {
            style.addStyleListener(this.styleListener);
        }
    }

    public IPlotterStyle setDefaultsFromData(Object thing, IPlotterStyle style) {
        int k;
        IAnnotation an = null;
        int dimension = 0;
        if (thing instanceof IBaseHistogram) {
            an = ((IBaseHistogram)thing).annotation();
            dimension = ((IBaseHistogram)thing).dimension();
        } else if (thing instanceof IDataPointSet) {
            an = ((IDataPointSet)thing).annotation();
            dimension = ((IDataPointSet)thing).dimension();
        } else {
            return style;
        }
        String prefix = "x";
        IAxisStyle xAxisStyle = style.xAxisStyle();
        int size = an.size();
        for (int k2 = 0; k2 < size; ++k2) {
            String key = an.key(k2);
            for (int i = 0; i < styleKeys.length; ++i) {
                if (!key.equalsIgnoreCase(prefix + styleKeys[i])) continue;
                try {
                    String val = an.value(key);
                    if (val == null || ((BaseStyle)xAxisStyle).isParameterSet(stylePars[i])) continue;
                    xAxisStyle.setParameter(stylePars[i], val);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        prefix = "y";
        IAxisStyle yAxisStyle = style.yAxisStyle();
        size = an.size();
        for (k = 0; k < size; ++k) {
            String key = an.key(k);
            for (int i = 0; i < styleKeys.length; ++i) {
                if (!key.equalsIgnoreCase(prefix + styleKeys[i])) continue;
                try {
                    String val = an.value(key);
                    if (val == null || ((BaseStyle)yAxisStyle).isParameterSet(stylePars[i])) continue;
                    yAxisStyle.setParameter(stylePars[i], val);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        size = an.size();
        for (k = 0; k < size; ++k) {
            String oldVal;
            String val;
            String key = an.key(k);
            if (key.equalsIgnoreCase(overlayKey)) {
                try {
                    val = an.value(key);
                    oldVal = null;
                    if (((BaseStyle)style.dataStyle()).isParameterSet(overlayKey)) {
                        oldVal = style.dataStyle().parameterValue(overlayKey);
                    }
                    if (val == null || oldVal != null) continue;
                    style.dataStyle().setParameter(overlayKey, val);
                }
                catch (IllegalArgumentException e) {}
                continue;
            }
            if (!key.equalsIgnoreCase(timeZoneKey)) continue;
            try {
                val = an.value(key);
                oldVal = null;
                if (((BaseStyle)style.dataStyle()).isParameterSet(timeZoneKey)) {
                    oldVal = style.dataStyle().parameterValue(timeZoneKey);
                }
                if (val == null || oldVal != null) continue;
                style.dataStyle().setParameter(timeZoneKey, val);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return style;
    }

    public void handleLabels(IPlotterStyle style) {
        boolean yLabelIsSet;
        boolean xLabelIsSet;
        JASHistAxis xHistAxis = this.getPlot().getXAxis();
        String oldXLabel = xHistAxis.getLabel();
        IAxisStyle xAxisStyle = style.xAxisStyle();
        String xAxisLabel = xAxisStyle.label();
        boolean bl = xLabelIsSet = xAxisLabel != null && !xAxisLabel.equals("") && ((BaseStyle)xAxisStyle).isParameterSet("label");
        if (!xLabelIsSet && oldXLabel != null && !oldXLabel.equals("")) {
            xAxisStyle.setLabel(oldXLabel);
        }
        JASHistAxis yHistAxis = this.getPlot().getYAxis();
        String oldYLabel = yHistAxis.getLabel();
        IAxisStyle yAxisStyle = style.yAxisStyle();
        String yAxisLabel = yAxisStyle.label();
        boolean bl2 = yLabelIsSet = yAxisLabel != null && !yAxisLabel.equals("") && ((BaseStyle)yAxisStyle).isParameterSet("label");
        if (!yLabelIsSet && oldYLabel != null && !oldYLabel.equals("")) {
            yAxisStyle.setLabel(oldYLabel);
        }
    }

    IPlotterStyle getImplicitStyle(Object thing) {
        IStyleRegistry registry;
        DataPointSetPlotterStyle implicitStyle = null;
        if (thing instanceof IDataPointSet) {
            implicitStyle = new DataPointSetPlotterStyle();
        } else if (thing instanceof IProfile) {
            implicitStyle = new DataPointSetPlotterStyle();
        } else if (thing instanceof IPlotterState && (registry = (IStyleRegistry)FreeHEPLookup.instance().lookup(IStyleRegistry.class)) != null) {
            implicitStyle = registry.getStyleForState((IPlotterState)thing);
        }
        return implicitStyle;
    }

    IPlotterState createAndFillPlotterState(Object data, String options) {
        String[] catKeys;
        IStyleRegistry registry;
        PlotterState state = new PlotterState();
        if (this.plotter != null) {
            state.setRegionIndex(this.plotter.currentRegionNumber());
        }
        if (this.plotter != null) {
            state.setRegionTotal(this.plotter.numberOfRegions());
        }
        state.setOverlayTotal(this.dataStyleList.size() + 1);
        state.setOverlayIndex(this.getPlot().getNumberOfDataSources());
        if (options != null && !options.trim().equals("")) {
            int index;
            Map optionsMap = AidaUtils.parseOptions(options);
            Object tmp = optionsMap.get("OverlayIndex");
            if (tmp != null) {
                try {
                    index = Integer.parseInt((String)tmp);
                    state.setOverlayIndex(index);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((tmp = optionsMap.get("OverlayTotal")) != null) {
                try {
                    index = Integer.parseInt((String)tmp);
                    state.setOverlayTotal(index);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        state.setObject(data);
        IAnnotation an = null;
        if (data instanceof IDataPointSet) {
            an = ((IDataPointSet)data).annotation();
        } else if (data instanceof IBaseHistogram) {
            an = ((IBaseHistogram)data).annotation();
        } else if (data instanceof IFunction) {
            an = ((IFunction)data).annotation();
        }
        if (an == null) {
            return state;
        }
        for (int i = 0; i < an.size(); ++i) {
            String key = an.key(i);
            if (!key.toLowerCase().startsWith("IPlotterState".toLowerCase())) continue;
            String value = an.value(key);
            int index = "IPlotterState".length();
            String stateKey = key.substring(index + 1);
            state.setAttribute(stateKey, value);
        }
        if (an.hasKey(Annotation.fullPathKey)) {
            state.setObjectPath(an.value(Annotation.fullPathKey));
        }
        if ((registry = (IStyleRegistry)FreeHEPLookup.instance().lookup(IStyleRegistry.class)) != null && (catKeys = registry.getAvailableCategoryKeys()) != null) {
            for (int i = 0; i < catKeys.length; ++i) {
                String value;
                String key = catKeys[i];
                if (key == null || key.trim().equals("") || (value = registry.getCategoryCurrentValue(key)) == null) continue;
                state.setAttribute(key, value);
            }
        }
        return state;
    }

    public IPlotterStyle applyDefaultStyles(Object data, IPlotterStyle style) {
        return this.applyDefaultStyles(data, style, null);
    }

    public IPlotterStyle applyDefaultStyles(Object data, IPlotterStyle style, String options) {
        ArrayList<Object> list = new ArrayList<Object>(3);
        if (this.style() != null) {
            list.add(this.style());
        }
        if (this.plotter != null && this.plotter.style() != null) {
            list.add(this.plotter.style());
        }
        IPlotterStyle implicitStyle = null;
        IStyleRegistry registry = (IStyleRegistry)FreeHEPLookup.instance().lookup(IStyleRegistry.class);
        if (registry == null) {
            implicitStyle = this.getImplicitStyle(data);
            if (implicitStyle != null) {
                list.add(implicitStyle);
            }
        } else {
            implicitStyle = this.getImplicitStyle(this.createAndFillPlotterState(data, options));
            if (implicitStyle == null) {
                implicitStyle = this.getImplicitStyle(data);
                if (implicitStyle != null) {
                    list.add(implicitStyle);
                }
            } else {
                List parents = ((PlotterStyle)implicitStyle).parentList();
                for (int k = 0; k < parents.size(); ++k) {
                    Object obj = parents.get(k);
                    if (obj == null) continue;
                    list.add(obj);
                }
                ((PlotterStyle)implicitStyle).reset();
            }
        }
        ((PlotterStyle)style).setParentList(list);
        return style;
    }

    public void applyStyleBeforeAdding(IPlotterStyle style, DataSource ds) {
        String yAxisType;
        String xAxisType = style.xAxisStyle().parameterValue("type");
        if (xAxisType != null && xAxisType.equalsIgnoreCase("date")) {
            if (ds instanceof AIDADataPointSetAdapter) {
                ((AIDADataPointSetAdapter)ds).setAxisType(3);
            }
            if (ds instanceof AIDACloudAdapter1D) {
                ((AIDACloudAdapter1D)ds).setAxisType(3);
            }
            if (ds instanceof AIDAHistogramAdapter1D) {
                ((AIDAHistogramAdapter1D)ds).setAxisType(3);
            }
            if (ds instanceof AIDACloudAdapter2D) {
                ((AIDACloudAdapter2D)ds).setXAxisType(3);
            }
            if (ds instanceof AIDAHistogramAdapter2D) {
                ((AIDAHistogramAdapter2D)ds).setXAxisType(3);
            }
        }
        if ((yAxisType = style.yAxisStyle().parameterValue("type")) != null && yAxisType.equals("date")) {
            if (ds instanceof AIDACloudAdapter2D) {
                ((AIDACloudAdapter2D)ds).setYAxisType(3);
            }
            if (ds instanceof AIDAHistogramAdapter2D) {
                ((AIDAHistogramAdapter2D)ds).setYAxisType(3);
            }
        }
    }

    public void applyStyleAfterShow(JASHistData jasHistData, IPlotterStyle style) {
        if (this.getPlot().getShowLegend() > 0) {
            Legend legend = this.getPlot().getLegend();
            this.placeMovableObject((MovableObject)legend, style.legendBoxStyle().boxStyle());
        }
        if (this.getPlot().getShowStatistics()) {
            StatisticsBlock stat = this.getPlot().getStats();
            this.placeMovableObject((MovableObject)stat, style.statisticsBoxStyle().boxStyle());
        }
    }

    public void applyStyle(JASHistData jasHistData, IPlotterStyle style) {
        String overlayClass;
        String timeZoneID;
        JASHistStyle histStyle;
        String yAxisValue;
        String yAxisTextColor;
        float yAxisLineWidth;
        String yAxisLineColor;
        String yAxisTickLabelColor;
        boolean setYLabel;
        String xAxisTextColor;
        float xAxisLineWidth;
        String xAxisLineColor;
        String xAxisTickLabelColor;
        boolean setXLabel;
        String dataAreaBorderType;
        String dataAreaColor;
        String foregroundColor;
        String backgroundColor;
        Color color;
        Title titleObj;
        StatisticsBlock stat;
        Legend legend;
        int overlayIndex = this.getOverlayIndex(style);
        int globalIndex = -1;
        if (style instanceof PlotterStyle) {
            try {
                globalIndex = Integer.parseInt(style.parameterValue("globalIndex"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DataSource ds = jasHistData.getDataSource();
        String profileErrors = style.dataStyle().parameterValue("profileErrors");
        if (profileErrors != null && ds instanceof AIDAProfileAdapter) {
            if (profileErrors.equals("errorOnMean") || profileErrors.equals("1")) {
                ((AIDAProfileAdapter)ds).setErrorMode(AIDAProfileAdapter.USE_ERROR_ON_MEAN);
            } else if (profileErrors.equals("spread") || profileErrors.equals("0")) {
                ((AIDAProfileAdapter)ds).setErrorMode(AIDAProfileAdapter.USE_SPREAD);
            }
        }
        String normString = style.dataStyle().parameterValue("normalization");
        int n = this.dataStyleList.size();
        if (n > 1 && overlayIndex != 0) {
            SimpleNormalizer normalizer = null;
            DataSource firstDS = ((DataStyleEntry)this.dataStyleList.get(0)).data().getDataSource();
            DataSource currentDS = jasHistData.getDataSource();
            if (firstDS instanceof Rebinnable1DHistogramData) {
                if (normString.toLowerCase().equals("none")) {
                    normalizer = new SimpleNormalizer(1.0);
                } else if (normString.toLowerCase().equals("entries")) {
                    normalizer = new RelativeNormalizer((Normalizer)new EntriesNormalizer(currentDS), (Normalizer)new EntriesNormalizer(firstDS));
                } else if (normString.toLowerCase().equals("maxbin")) {
                    normalizer = new RelativeNormalizer((Normalizer)new MaxBinNormalizer(currentDS), (Normalizer)new MaxBinNormalizer(firstDS));
                } else if (normString.toLowerCase().equals("area")) {
                    normalizer = new RelativeNormalizer((Normalizer)new AreaNormalizer(currentDS), (Normalizer)new AreaNormalizer(firstDS));
                }
                if (normalizer != null) {
                    jasHistData.setNormalization((Normalizer)normalizer);
                }
            }
        }
        boolean showLegendSet = true;
        if (style.legendBoxStyle() instanceof BaseStyle) {
            showLegendSet = ((BaseStyle)style.legendBoxStyle()).isParameterSet("isVisible");
        }
        boolean showLegend = style.legendBoxStyle().isVisible();
        if (!showLegendSet) {
            this.getPlot().setShowLegend(1);
        } else if (showLegend) {
            this.getPlot().setShowLegend(2);
        } else {
            this.getPlot().setShowLegend(0);
        }
        if (this.getPlot().getShowLegend() > 0 && (legend = this.getPlot().getLegend()) != null) {
            legend.setFont(PlotterFontUtil.getFont(style.legendBoxStyle().textStyle()));
        }
        jasHistData.setShowLegend(style.dataStyle().isShownInLegendBox());
        this.getPlot().setShowStatistics(style.statisticsBoxStyle().isVisible());
        if (this.getPlot().getShowStatistics() && (stat = this.getPlot().getStats()) != null) {
            stat.setFont(PlotterFontUtil.getFont(style.statisticsBoxStyle().textStyle()));
        }
        jasHistData.setShowStatistics(style.dataStyle().isShownInStatisticsBox());
        if (this.getPlot().getTitleObject() != null) {
            this.getPlot().getTitleObject().setVisible(style.titleStyle().isVisible());
        }
        if ((titleObj = this.getPlot().getTitleObject()) != null) {
            titleObj.setFont(PlotterFontUtil.getFont(style.titleStyle().textStyle()));
            String colorStr = style.titleStyle().textStyle().color();
            if (colorStr != null) {
                try {
                    color = ColorConverter.get((String)colorStr);
                    color = this.getTransparentColor(color, style.titleStyle().textStyle().opacity());
                    titleObj.setForeground(color);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if (titleObj.isShowing()) {
                this.getPlot().setTitleObject(titleObj);
            }
        }
        if ((backgroundColor = style.regionBoxStyle().backgroundStyle().color()) != null) {
            try {
                color = ColorConverter.get((String)backgroundColor);
                this.getPlot().setBackground(color);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((foregroundColor = style.regionBoxStyle().foregroundStyle().color()) != null) {
            try {
                Color color2 = ColorConverter.get((String)foregroundColor);
                this.getPlot().setForegroundColor(color2);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((dataAreaColor = style.dataBoxStyle().backgroundStyle().color()) != null) {
            try {
                Color color3 = ColorConverter.get((String)dataAreaColor);
                this.getPlot().setDataAreaColor(color3);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((dataAreaBorderType = style.dataBoxStyle().borderStyle().borderType()) != null) {
            if (dataAreaBorderType == "bevelIn" || dataAreaBorderType == "0") {
                this.getPlot().setDataAreaBorderType(1);
            } else if (dataAreaBorderType == "bevelOut" || dataAreaBorderType == "1") {
                this.getPlot().setDataAreaBorderType(2);
            } else if (dataAreaBorderType == "etched" || dataAreaBorderType == "2") {
                this.getPlot().setDataAreaBorderType(3);
            } else if (dataAreaBorderType == "line" || dataAreaBorderType == "3") {
                this.getPlot().setDataAreaBorderType(4);
            } else if (dataAreaBorderType == "shadow" || dataAreaBorderType == "4") {
                this.getPlot().setDataAreaBorderType(5);
            } else {
                this.getPlot().setDataAreaBorderType(0);
            }
        }
        JASHistAxis xAxis = this.getPlot().getXAxis();
        IAxisStyle xAxisStyle = style.xAxisStyle();
        String xAxisLabel = xAxisStyle.label();
        boolean bl = setXLabel = xAxisLabel != null && ((BaseStyle)xAxisStyle).isParameterSet("label");
        if (setXLabel) {
            xAxis.setLabel(xAxisLabel);
        }
        boolean xAllowZeroSuppression = Boolean.valueOf(xAxisStyle.parameterValue("allowZeroSuppression"));
        xAxis.setAllowSuppressedZero(xAllowZeroSuppression);
        EditableLabel xlabel = xAxis.getLabelObject();
        if (xlabel != null) {
            xlabel.setFont(PlotterFontUtil.getFont(xAxisStyle.labelStyle()));
            String xAxisLabelColor = xAxisStyle.labelStyle().color();
            if (xAxisLabelColor != null) {
                try {
                    Color color4 = ColorConverter.get((String)xAxisLabelColor);
                    color4 = this.getTransparentColor(color4, xAxisStyle.labelStyle().opacity());
                    xlabel.setForeground(color4);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if (xlabel.isShowing()) {
                xAxis.setLabelObject(xlabel);
            }
        }
        xAxis.setFont(PlotterFontUtil.getFont(xAxisStyle.tickLabelStyle()));
        String xAxisScale = xAxisStyle.scaling();
        if (xAxisScale != null) {
            xAxis.setLogarithmic(xAxisScale.startsWith("log"));
        }
        if ((xAxisTickLabelColor = xAxisStyle.tickLabelStyle().color()) != null) {
            try {
                Color color5 = ColorConverter.get((String)xAxisTickLabelColor);
                color5 = this.getTransparentColor(color5, xAxisStyle.tickLabelStyle().opacity());
                xAxis.setAxisColor(color5);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((xAxisLineColor = xAxisStyle.lineStyle().color()) != null) {
            try {
                Color color6 = ColorConverter.get((String)xAxisLineColor);
                color6 = this.getTransparentColor(color6, xAxisStyle.lineStyle().opacity());
                xAxis.setAxisColor(color6);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((xAxisLineWidth = this.lineThickness(xAxisStyle.lineStyle().thickness())) >= 0.0f) {
            try {
                xAxis.setAxisWidth(xAxisLineWidth);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((xAxisTextColor = xAxisStyle.labelStyle().color()) != null) {
            try {
                Color color7 = ColorConverter.get((String)xAxisTextColor);
                color7 = this.getTransparentColor(color7, xAxisStyle.labelStyle().opacity());
                xAxis.setTextColor(color7);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        IAxisStyle yAxisStyle = style.yAxisStyle();
        String yAxisString = yAxisStyle.parameterValue("yAxis");
        int yAxisIndex = 0;
        if (yAxisString != null && yAxisString.trim().equalsIgnoreCase("Y1")) {
            yAxisIndex = 1;
        }
        if (this.getPlot().getYAxis(yAxisIndex) == null) {
            throw new RuntimeException("Y Axis #" + yAxisIndex + " has not been created yet");
        }
        JASHistAxis yAxis = this.getPlot().getYAxis(yAxisIndex);
        String yAxisLabel = yAxisStyle.label();
        boolean bl2 = setYLabel = yAxisLabel != null && ((BaseStyle)yAxisStyle).isParameterSet("label");
        if (setYLabel) {
            yAxis.setLabel(yAxisLabel);
        }
        boolean yAllowZeroSuppression = Boolean.valueOf(yAxisStyle.parameterValue("allowZeroSuppression"));
        yAxis.setAllowSuppressedZero(yAllowZeroSuppression);
        EditableLabel ylabel = yAxis.getLabelObject();
        if (ylabel != null) {
            ylabel.setFont(PlotterFontUtil.getFont(yAxisStyle.labelStyle()));
            String yAxisLabelColor = yAxisStyle.labelStyle().color();
            if (yAxisLabelColor != null) {
                try {
                    Color color8 = ColorConverter.get((String)yAxisLabelColor);
                    color8 = this.getTransparentColor(color8, yAxisStyle.labelStyle().opacity());
                    ylabel.setForeground(color8);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if (ylabel.isShowing()) {
                yAxis.setLabelObject(ylabel);
            }
        }
        yAxis.setFont(PlotterFontUtil.getFont(yAxisStyle.tickLabelStyle()));
        String yAxisScale = yAxisStyle.scaling();
        if (yAxisScale != null) {
            yAxis.setLogarithmic(yAxisScale.startsWith("log"));
        }
        if ((yAxisTickLabelColor = yAxisStyle.tickLabelStyle().color()) != null) {
            try {
                Color color9 = ColorConverter.get((String)yAxisTickLabelColor);
                color9 = this.getTransparentColor(color9, yAxisStyle.tickLabelStyle().opacity());
                yAxis.setAxisColor(color9);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((yAxisLineColor = yAxisStyle.lineStyle().color()) != null) {
            try {
                Color color10 = ColorConverter.get((String)yAxisLineColor);
                color10 = this.getTransparentColor(color10, yAxisStyle.lineStyle().opacity());
                yAxis.setAxisColor(color10);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((yAxisLineWidth = this.lineThickness(yAxisStyle.lineStyle().thickness())) >= 0.0f) {
            try {
                yAxis.setAxisWidth(yAxisLineWidth);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((yAxisTextColor = yAxisStyle.labelStyle().color()) != null) {
            try {
                Color color11 = ColorConverter.get((String)yAxisTextColor);
                color11 = this.getTransparentColor(color11, yAxisStyle.labelStyle().opacity());
                yAxis.setTextColor(color11);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((yAxisValue = yAxisStyle.parameterValue("yAxis")) != null) {
            try {
                int yAxisID = yAxisValue.equalsIgnoreCase("Y1") ? 1 : 0;
                jasHistData.setYAxis(yAxisID);
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if ((histStyle = jasHistData.getStyle()) instanceof JASHist1DFunctionStyle) {
            JASHist1DFunctionStyle fs = (JASHist1DFunctionStyle)histStyle;
            IDataStyle dataStyle = style.dataStyle();
            String functionLineColor = dataStyle.outlineStyle().color();
            if (functionLineColor != null) {
                try {
                    Color color12 = ColorConverter.get((String)functionLineColor);
                    fs.setLineColor(color12);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            String lineType = dataStyle.outlineStyle().lineType();
            if (dataStyle.outlineStyle() instanceof LineStyle) {
                lineType = ((LineStyle)dataStyle.outlineStyle()).lineType(globalIndex, overlayIndex);
            }
            fs.setLineStyle(this.lineType(lineType));
            fs.setLineWidth(this.lineThickness(dataStyle.outlineStyle().thickness()));
            jasHistData.show(dataStyle.outlineStyle().isVisible());
        }
        if ((timeZoneID = style.dataStyle().parameterValue(timeZoneKey)) != null) {
            try {
                TimeZone tz = TimeZone.getTimeZone(timeZoneID);
                if (tz != null) {
                    histStyle.setTimeZone(tz);
                }
            }
            catch (Exception tze) {
                tze.printStackTrace();
            }
        }
        if ((overlayClass = style.dataStyle().parameterValue(overlayKey)) == null) {
            // empty if block
        }
        CustomOverlay customOverlay = null;
        if (overlayClass != null) {
            try {
                Class<?> coClass = Class.forName(overlayClass);
                customOverlay = (CustomOverlay)coClass.newInstance();
                if (customOverlay instanceof CanSetData) {
                    ((CanSetData)customOverlay).setData(jasHistData);
                }
                histStyle.setCustomOverlay(customOverlay);
            }
            catch (Exception coe) {
                coe.printStackTrace();
            }
        }
        if (histStyle instanceof JASHist1DHistogramStyle) {
            Color color13;
            JASHist1DHistogramStyle hs = (JASHist1DHistogramStyle)histStyle;
            if (customOverlay != null && customOverlay instanceof CanSetStyle) {
                ((CanSetStyle)customOverlay).setStyle((JASHistStyle)hs);
            }
            IDataStyle dataStyle = style.dataStyle();
            boolean vis = dataStyle.fillStyle().isVisible();
            boolean set = ((BaseStyle)dataStyle.fillStyle()).isParameterSet("isVisible");
            hs.setShowHistogramBars(dataStyle.lineStyle().isVisible());
            hs.setHistogramFill(dataStyle.fillStyle().isVisible());
            hs.setShowErrorBars(dataStyle.errorBarStyle().isVisible());
            hs.setShowDataPoints(dataStyle.markerStyle().isVisible());
            hs.setShowLinesBetweenPoints(dataStyle.outlineStyle().isVisible());
            IFillStyle dataFillStyle = dataStyle.fillStyle();
            ILineStyle dataLineStyle = dataStyle.lineStyle();
            IMarkerStyle dataMarkerStyle = dataStyle.markerStyle();
            String dataLineColor = dataLineStyle.color();
            String dataFillColor = dataFillStyle.color();
            String dataLineBetweenPointsColor = dataStyle.outlineStyle().color();
            String dataMarkerColor = dataMarkerStyle.color();
            String errorBarsColor = dataStyle.errorBarStyle().color();
            if (dataFillStyle instanceof BrushStyle) {
                dataFillColor = ((BrushStyle)dataFillStyle).color(globalIndex, overlayIndex);
                if (dataMarkerColor == null || !((BrushStyle)dataMarkerStyle).isParameterSet("color", true)) {
                    dataMarkerColor = dataFillColor;
                }
                if (dataLineBetweenPointsColor == null || !((BrushStyle)dataStyle.outlineStyle()).isParameterSet("color", true)) {
                    dataLineBetweenPointsColor = dataFillColor;
                }
                if (dataLineColor == null || !((BrushStyle)dataLineStyle).isParameterSet("color", true)) {
                    dataLineColor = null;
                }
                if (errorBarsColor == null || !((BrushStyle)dataStyle.errorBarStyle()).isParameterSet("color", true)) {
                    errorBarsColor = dataLineColor;
                }
            }
            if (dataFillColor != null) {
                try {
                    color13 = ColorConverter.get((String)dataFillColor);
                    color13 = this.getTransparentColor(color13, dataFillStyle.opacity());
                    hs.setHistogramBarColor(color13);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if (dataLineColor != null) {
                try {
                    color13 = ColorConverter.get((String)dataLineColor);
                    color13 = this.getTransparentColor(color13, dataLineStyle.opacity());
                    hs.setHistogramBarLineColor(color13);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if (dataLineBetweenPointsColor != null) {
                try {
                    color13 = ColorConverter.get((String)dataLineBetweenPointsColor);
                    hs.setLineColor(color13);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if (dataMarkerColor != null) {
                try {
                    color13 = ColorConverter.get((String)dataMarkerColor);
                    color13 = this.getTransparentColor(color13, dataMarkerStyle.opacity());
                    hs.setDataPointColor(color13);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            try {
                if (errorBarsColor != null) {
                    color13 = ColorConverter.get((String)errorBarsColor);
                    color13 = this.getTransparentColor(color13, dataStyle.errorBarStyle().opacity());
                    hs.setErrorBarColor(color13);
                }
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
            String dataLineType = dataLineStyle.lineType();
            if (dataLineStyle instanceof LineStyle) {
                dataLineType = ((LineStyle)dataLineStyle).lineType(globalIndex, overlayIndex);
            }
            hs.setHistogramBarLineStyle(this.lineType(dataLineType));
            hs.setHistogramBarLineWidth(this.lineThickness(dataLineStyle.thickness()));
            String lineType = dataStyle.outlineStyle().lineType();
            if (dataStyle.outlineStyle() instanceof LineStyle) {
                lineType = ((LineStyle)dataStyle.outlineStyle()).lineType(globalIndex, overlayIndex);
            }
            hs.setLinesBetweenPointsStyle(this.lineType(lineType));
            hs.setLinesBetweenPointsWidth(this.lineThickness(dataStyle.outlineStyle().thickness()));
            String dataMarkerShape = dataMarkerStyle.shape();
            if (dataMarkerStyle instanceof MarkerStyle) {
                dataMarkerShape = ((MarkerStyle)dataMarkerStyle).shape(globalIndex, overlayIndex);
            }
            if (dataMarkerShape != null) {
                hs.setDataPointStyle(this.markerShape(dataMarkerShape));
            }
            hs.setDataPointSize(dataMarkerStyle.size());
            String errorLineType = dataStyle.outlineStyle().lineType();
            if (dataStyle.errorBarStyle() instanceof LineStyle) {
                errorLineType = ((LineStyle)dataStyle.errorBarStyle()).lineType(globalIndex, overlayIndex);
            }
            hs.setErrorBarStyle(this.lineType(errorLineType));
            hs.setErrorBarWidth(this.lineThickness(dataStyle.errorBarStyle().thickness()));
            ILineStyle errorBarSt = dataStyle.errorBarStyle();
            try {
                String tmp = errorBarSt.parameterValue("errorBarDecoration");
                if (tmp != null && !tmp.trim().equals("")) {
                    float tmpFl = Float.parseFloat(tmp);
                    hs.setErrorBarDecoration(tmpFl);
                } else {
                    hs.setErrorBarDecoration(-1.0f);
                }
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if (histStyle instanceof JASHistScatterPlotStyle) {
            JASHistScatterPlotStyle sphs = (JASHistScatterPlotStyle)histStyle;
            IMarkerStyle dataMarkerStyle = style.dataStyle().markerStyle();
            String dataMarkerShape = dataMarkerStyle.shape();
            if (dataMarkerStyle instanceof MarkerStyle) {
                dataMarkerShape = ((MarkerStyle)dataMarkerStyle).shape(globalIndex, overlayIndex);
            }
            if (dataMarkerShape != null) {
                sphs.setDataPointStyle(this.markerShapeScatter(dataMarkerShape));
            }
            sphs.setDataPointSize(dataMarkerStyle.size());
            String dataMarkerColor = dataMarkerStyle.color();
            if (dataMarkerStyle instanceof BrushStyle) {
                dataMarkerColor = ((BrushStyle)dataMarkerStyle).color(globalIndex, overlayIndex);
            }
            if (dataMarkerColor != null) {
                try {
                    Color color14 = ColorConverter.get((String)dataMarkerColor);
                    color14 = this.getTransparentColor(color14, dataMarkerStyle.opacity());
                    sphs.setDataPointColor(color14);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            sphs.setDisplayAsScatterPlot(Boolean.valueOf(style.parameterValue("showAsScatterPlot")).booleanValue());
        }
        boolean isBinned2D = false;
        boolean showZHB = true;
        if (histStyle instanceof JASHist2DHistogramStyle) {
            if (histStyle instanceof JASHistScatterPlotStyle) {
                if (((JASHistScatterPlotStyle)histStyle).getDisplayAsScatterPlot()) {
                    isBinned2D = true;
                }
            } else {
                isBinned2D = true;
            }
            try {
                String tmpSt = style.dataStyle().fillStyle().parameterValue("showZeroHeightBins");
                showZHB = tmpSt.trim().equalsIgnoreCase("true");
            }
            catch (Exception cce) {
                throw new RuntimeException(cce);
            }
        }
        if (isBinned2D) {
            String logZ;
            String colorMapScheme;
            JASHist2DHistogramStyle hs = (JASHist2DHistogramStyle)histStyle;
            String hist2DStyle = style.parameterValue("hist2DStyle");
            if (hist2DStyle != null) {
                if (hist2DStyle.equals("box") || hist2DStyle.equals("0")) {
                    hs.setHistStyle(0);
                } else if (hist2DStyle.equals("ellipse") || hist2DStyle.equals("1")) {
                    hs.setHistStyle(1);
                } else if (hist2DStyle.equals("colorMap") || hist2DStyle.equals("2")) {
                    hs.setHistStyle(2);
                } else {
                    hs.setHistStyle(0);
                }
            }
            if ((colorMapScheme = style.dataStyle().fillStyle().parameterValue("colorMapScheme")) != null) {
                if (colorMapScheme.equals("warm") || colorMapScheme.equals("0")) {
                    hs.setColorMapScheme(0);
                } else if (colorMapScheme.equals("cool") || colorMapScheme.equals("1")) {
                    hs.setColorMapScheme(1);
                } else if (colorMapScheme.equals("thermal") || colorMapScheme.equals("2")) {
                    hs.setColorMapScheme(2);
                } else if (colorMapScheme.equals("rainbow") || colorMapScheme.equals("3")) {
                    hs.setColorMapScheme(3);
                } else if (colorMapScheme.equals("grayscale") || colorMapScheme.equals("4")) {
                    hs.setColorMapScheme(4);
                } else if (colorMapScheme.equals("userdefined") || colorMapScheme.equals("5")) {
                    hs.setColorMapScheme(5);
                    String startColor = style.dataStyle().fillStyle().parameterValue("startColor");
                    String endColor = style.dataStyle().fillStyle().parameterValue("endColor");
                    try {
                        hs.setStartDataColor(startColor == null ? Color.WHITE : ColorConverter.get((String)startColor));
                    }
                    catch (ColorConverter.ColorConversionException x) {
                        hs.setStartDataColor(Color.WHITE);
                    }
                    try {
                        hs.setEndDataColor(endColor == null ? Color.BLACK : ColorConverter.get((String)endColor));
                    }
                    catch (ColorConverter.ColorConversionException x) {
                        hs.setStartDataColor(Color.BLACK);
                    }
                } else {
                    hs.setColorMapScheme(0);
                }
            }
            String shapeColor = style.dataStyle().markerStyle().color();
            if (style.dataStyle().markerStyle() instanceof BrushStyle) {
                shapeColor = ((BrushStyle)style.dataStyle().markerStyle()).color(globalIndex, overlayIndex);
            }
            if (shapeColor != null) {
                try {
                    Color color15 = ColorConverter.get((String)shapeColor);
                    color15 = this.getTransparentColor(color15, style.dataStyle().markerStyle().opacity());
                    hs.setShapeColor(color15);
                }
                catch (Exception cce) {
                    throw new RuntimeException(cce);
                }
            }
            if ((logZ = style.zAxisStyle().scaling()) != null) {
                hs.setLogZ(logZ.toLowerCase().startsWith("log"));
            }
            hs.setShowZeroHeightBins(showZHB);
        }
        jasHistData.show(style.dataStyle().isVisible());
    }

    private Color getTransparentColor(Color c, double alpha) {
        if (alpha == -1.0 || alpha < 0.0 || alpha > 1.0) {
            return c;
        }
        int t = (int)(255.0 * alpha);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), t);
    }

    private float lineThickness(String thickness) {
        return Float.parseFloat(thickness) / 2.0f;
    }

    private float lineThickness(int thickness) {
        return (float)thickness / 2.0f;
    }

    private int lineType(String lineType) {
        if (lineType == null || lineType.equals("solid") || lineType.equals("0")) {
            return 0;
        }
        if (lineType.equals("dotted") || lineType.equals("1")) {
            return 1;
        }
        if (lineType.equals("dashed") || lineType.equals("2")) {
            return 2;
        }
        if (lineType.equals("dotdash") || lineType.equals("3")) {
            return 3;
        }
        return 0;
    }

    private int markerShape(String markerShape) {
        if (markerShape.equals("dot") || markerShape.equals("0")) {
            return 0;
        }
        if (markerShape.equals("box") || markerShape.equals("1")) {
            return 1;
        }
        if (markerShape.equals("triangle") || markerShape.equals("2")) {
            return 2;
        }
        if (markerShape.equals("diamond") || markerShape.equals("3")) {
            return 3;
        }
        if (markerShape.equals("star") || markerShape.equals("4")) {
            return 4;
        }
        if (markerShape.equals("verticalLine") || markerShape.equals("5")) {
            return 5;
        }
        if (markerShape.equals("horizontalLine") || markerShape.equals("6")) {
            return 6;
        }
        if (markerShape.equals("cross") || markerShape.equals("7")) {
            return 7;
        }
        if (markerShape.equals("circle") || markerShape.equals("8")) {
            return 8;
        }
        if (markerShape.equals("square") || markerShape.equals("9")) {
            return 9;
        }
        return 0;
    }

    private int markerShapeScatter(String markerShape) {
        if (markerShape.equals("box") || markerShape.equals("1")) {
            return 0;
        }
        if (markerShape.equals("triangle") || markerShape.equals("2")) {
            return 1;
        }
        if (markerShape.equals("diamond") || markerShape.equals("3")) {
            return 2;
        }
        if (markerShape.equals("star") || markerShape.equals("4")) {
            return 3;
        }
        if (markerShape.equals("verticalLine") || markerShape.equals("5")) {
            return 4;
        }
        if (markerShape.equals("horizontalLine") || markerShape.equals("6")) {
            return 5;
        }
        if (markerShape.equals("cross") || markerShape.equals("7")) {
            return 6;
        }
        if (markerShape.equals("square") || markerShape.equals("9")) {
            return 7;
        }
        return 0;
    }

    void removeAllObjectsFromRegion() {
        int nData = this.dataList.size();
        ArrayList tmpDataList = (ArrayList)this.dataList.clone();
        for (int i = 0; i < nData; ++i) {
            this.removeObj(tmpDataList.get(i), false);
        }
        this.rebuild();
    }

    public void removeObjectFromRegion(Object thing) {
        this.removeObj(thing, true);
    }

    void removeObj(Object thing, boolean rebuild) {
        int thingIndex = this.dataList.indexOf(thing);
        boolean removed = false;
        for (int i = 0; i < this.dataStyleList.size(); ++i) {
            DataStyleEntry dse = (DataStyleEntry)this.dataStyleList.get(i);
            if (thing != dse.data()) continue;
            dse.cleanUp();
            this.removeDataSourceFromRegion(dse.data().getDataSource());
            this.dataStyleList.remove(i);
            removed = true;
            break;
        }
        if (!removed) {
            DataStyleEntry dse = (DataStyleEntry)this.dataStyleList.get(thingIndex);
            dse.cleanUp();
            this.removeDataSourceFromRegion(dse.data().getDataSource());
            this.dataStyleList.remove(thingIndex);
            removed = true;
        }
        this.dataList.remove(thingIndex);
        if (rebuild && this.dataList.size() > 0) {
            this.rebuild();
        }
    }

    public void removeDataSourceFromRegion(DataSource ds) {
    }

    public void refresh() {
        this.rebuild();
    }

    int getOverlayIndex(IPlotterStyle style) {
        int overlayIndex = 0;
        ArrayList tmpDataStyleList = (ArrayList)this.dataStyleList.clone();
        for (int i = 0; i < tmpDataStyleList.size(); ++i) {
            DataStyleEntry dse = (DataStyleEntry)tmpDataStyleList.get(i);
            PlotterStyle ps = (PlotterStyle)dse.style();
            if (ps != style) continue;
            overlayIndex = i;
        }
        return overlayIndex;
    }

    public void refreshStyles() {
        int i;
        ArrayList tmpDataList = (ArrayList)this.dataList.clone();
        ArrayList tmpDataStyleList = (ArrayList)this.dataStyleList.clone();
        String options = "OverlayTotal=" + tmpDataList.size();
        List list = null;
        for (i = 0; i < tmpDataList.size(); ++i) {
            Object dataObj = tmpDataList.get(i);
            DataStyleEntry dse = (DataStyleEntry)tmpDataStyleList.get(i);
            PlotterStyle ps = (PlotterStyle)dse.style();
            ps.removeStyleListener(this.styleListener);
            ps.setParentList(list);
            String tmp = options + ", " + "OverlayIndex" + "=" + i;
            PlotterStyle style = (PlotterStyle)this.applyDefaultStyles(dataObj, ps, tmp);
            this.styleChanged(style);
        }
        for (i = 0; i < tmpDataList.size(); ++i) {
            DataStyleEntry dse = (DataStyleEntry)tmpDataStyleList.get(i);
            PlotterStyle ps = (PlotterStyle)dse.style();
            ps.addStyleListener(this.styleListener);
        }
    }

    private void rebuild() {
        PlotterRegion.invokeOnSwingThread(new RebuildRegion());
    }

    public void clearRegion() {
        this.removeAllObjectsFromRegion();
        JASHist plot = this.getPlot();
        if (plot != null) {
            this.panel.remove((Component)plot);
            plot.destroy();
            this.setPlot(null);
            this.regionTitle = null;
        }
        this.setStyle(new PlotterStyle());
    }

    private void createPlot() {
        this.plot = new JASHistPlot((DummyPlotter)this.plotter);
        this.plot.setShowStatistics(true);
        this.panel.add((Component)this.plot, "Center");
        this.panel.revalidate();
    }

    private static void invokeOnSwingThread(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException x) {
                x.printStackTrace();
            }
            catch (InterruptedException x) {
                x.printStackTrace();
            }
        }
    }

    public void addToRegion(Object thing, IPlotterStyle styleObj, String options) {
        this.add(thing, styleObj, options);
    }

    private String getRange(String options) {
        if (options != null) {
            Map optionsMap = AidaUtils.parseOptions(options);
            return (String)optionsMap.get("range");
        }
        return null;
    }

    public int getMode(String options) {
        if (options == null) {
            return this.defaultMode();
        }
        Map optionsMap = AidaUtils.parseOptions(options);
        String mode = (String)optionsMap.get("mode");
        return this.modeConversion(mode);
    }

    private int modeConversion(String mode) {
        if (mode != null) {
            if (mode.equals("replace")) {
                return 0;
            }
            if (mode.equals("overlay")) {
                return 1;
            }
            if (mode.equals("add")) {
                return 2;
            }
            if (mode.equals("stack")) {
                return 3;
            }
        }
        return this.defaultMode();
    }

    public void setDefaultMode(String value) {
        this.defaultMode = this.modeConversion(value);
    }

    int defaultMode() {
        return this.defaultMode;
    }

    private void placeMovableObject(MovableObject movableObject, IBoxStyle boxStyle) {
        if (!Double.isNaN(boxStyle.x()) && !Double.isNaN(boxStyle.y())) {
            movableObject.moveMovableObject((int)boxStyle.x(), (int)boxStyle.y());
        }
        if (!Double.isNaN(boxStyle.width()) && !Double.isNaN(boxStyle.height())) {
            movableObject.resizeMovableObject((int)boxStyle.width(), (int)boxStyle.height());
        }
    }

    private class JASHistPlot
    extends JASHist
    implements org.freehep.swing.popup.HasPopupItems,
    ActionListener {
        private DummyPlotter plotter;
        private Component parent;

        protected JASHistPlot(DummyPlotter plotter) {
            this.setShowStatistics(true);
            this.setBackground(Color.white);
            this.setAllowPopupMenus(false);
            this.plotter = plotter;
            this.parent = SwingUtilities.getAncestorOfClass(class$java$awt$Component == null ? (class$java$awt$Component = PlotterRegion.class$("java.awt.Component")) : class$java$awt$Component, plotter.panel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String command = actionEvent.getActionCommand();
            if (command.equals("saveRegion")) {
                ExportDialog dlg = new ExportDialog(null, true);
                dlg.showExportDialog(this.parent, "Save As...", (Component)((Object)this), "plot");
            } else if (command.equals("copyRegion")) {
                Clipboard cb = this.getToolkit().getSystemClipboard();
                VectorGraphicsTransferable t = new VectorGraphicsTransferable((Component)((Object)this));
                cb.setContents((Transferable)t, (ClipboardOwner)t);
            } else if (command.equals("printRegion")) {
                Studio studio = (Studio)Application.getApplication();
                try {
                    PrintHelper ph = new PrintHelper((Component)((Object)this), studio);
                    ph.print();
                }
                catch (PrinterException x) {
                    studio.error("Error printing plot", (Throwable)x);
                }
            } else if (command.equals("savePlotter")) {
                ExportDialog dlg = new ExportDialog(null, true);
                dlg.showExportDialog(this.parent, "Save As...", (Component)this.plotter.panel(), "plotter");
            } else if (command.equals("copyPlotter")) {
                Clipboard cb = this.getToolkit().getSystemClipboard();
                VectorGraphicsTransferable t = new VectorGraphicsTransferable((Component)this.plotter.panel());
                cb.setContents((Transferable)t, (ClipboardOwner)t);
            } else if (command.equals("printPlotter")) {
                Studio studio = (Studio)Application.getApplication();
                try {
                    PrintHelper ph = new PrintHelper((Component)this.plotter.panel(), studio);
                    ph.print();
                }
                catch (PrinterException x) {
                    studio.error("Error printing plot", (Throwable)x);
                }
            }
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
            for (Component c = source; c != null; c = c.getParent()) {
                if (!(c instanceof HasPopupItems)) continue;
                ((HasPopupItems)c).modifyPopupMenu(menu, source);
            }
            for (int i = 0; i < menu.getComponentCount(); ++i) {
                Component item = menu.getComponent(i);
                if (!(item instanceof JMenuItem)) continue;
                JMenuItem mItem = (JMenuItem)item;
                String name = mItem.getText();
                if (name.indexOf("Advanced") >= 0) {
                    menu.remove(i--);
                    continue;
                }
                if (name.equals("Save Plot As...")) {
                    menu.remove(i--);
                    continue;
                }
                if (name.equals("Print")) {
                    menu.remove(i--);
                    continue;
                }
                if (!name.equals("Copy Plot to Clipboard...")) continue;
                menu.remove(i--);
            }
            menu.addSeparator();
            JMenuItem item = new JMenuItem("Copy Plot Region");
            item.setActionCommand("copyRegion");
            item.addActionListener(this);
            menu.add(item);
            item = new JMenuItem("Copy Plotter");
            item.setActionCommand("copyPlotter");
            item.addActionListener(this);
            menu.add(item);
            item = new JMenuItem("Save Plot Region As...");
            item.setActionCommand("saveRegion");
            item.addActionListener(this);
            menu.add(item);
            item = new JMenuItem("Save Plotter As...");
            item.setActionCommand("savePlotter");
            item.addActionListener(this);
            menu.add(item);
            return menu;
        }
    }

    private class DataStyleEntry
    implements Runnable {
        private JASHistData jasHistData;
        private IPlotterStyle style;
        private int mode;

        DataStyleEntry(JASHistData jasHistData, IPlotterStyle style, int mode) {
            this.setData(jasHistData);
            this.setStyle(style);
            this.mode = mode;
        }

        IPlotterStyle style() {
            return this.style;
        }

        JASHistData data() {
            return this.jasHistData;
        }

        void setStyle(IPlotterStyle style) {
            this.style = style;
        }

        void setData(JASHistData jasHistData) {
            this.jasHistData = jasHistData;
        }

        int mode() {
            return this.mode;
        }

        void cleanUp() {
            ((PlotterStyle)this.style).removeStyleListener(PlotterRegion.this.styleListener);
            this.style.reset();
        }

        public void run() {
            PlotterRegion.this.applyStyle(this.data(), this.style());
        }
    }

    private class RebuildRegion
    implements Runnable {
        private RebuildRegion() {
        }

        public void run() {
            if (PlotterRegion.this.getPlot() != null) {
                PlotterRegion.this.getPlot().removeAllData();
            }
            ArrayList tmpDataList = (ArrayList)PlotterRegion.this.dataList.clone();
            ArrayList tmpDataStyleList = (ArrayList)PlotterRegion.this.dataStyleList.clone();
            PlotterRegion.this.dataList.clear();
            PlotterRegion.this.dataStyleList.clear();
            Object list = null;
            String options = "OverlayTotal=" + tmpDataList.size();
            for (int i = 0; i < tmpDataList.size(); ++i) {
                Object dataObj = tmpDataList.get(i);
                DataStyleEntry dse = (DataStyleEntry)tmpDataStyleList.get(i);
                PlotterStyle ps = (PlotterStyle)dse.style();
                ps.removeStyleListener(PlotterRegion.this.styleListener);
                ps.removeAllParents();
                String tmp = options + ", " + "OverlayIndex" + "=" + i;
                PlotterRegion.this.add(dse.data().getDataSource(), ps, dse.mode(), dataObj, tmp);
            }
        }
    }

    private class TitleChanged
    implements Runnable {
        TitleChanged(String title) {
            PlotterRegion.this.regionTitle = title;
        }

        public void run() {
            if (PlotterRegion.this.getPlot() == null) {
                PlotterRegion.this.createPlot();
            }
            PlotterRegion.this.getPlot().setTitle(PlotterRegion.this.regionTitle);
        }
    }

    private class LimitsChanged
    implements Runnable {
        static final int XAXIS = 0;
        static final int YAXIS = 1;
        static final int YAXIS1 = 11;
        static final int ZAXIS = 2;
        private int axis;
        private double min;
        private double max;

        LimitsChanged(int axis, double min, double max) {
            this.axis = axis;
            this.min = min;
            this.max = max;
        }

        public void run() {
            if (PlotterRegion.this.getPlot() != null) {
                JASHistAxis plotAxis = null;
                if (this.axis == 0) {
                    plotAxis = PlotterRegion.this.getPlot().getXAxis();
                } else if (this.axis == 1) {
                    plotAxis = PlotterRegion.this.getPlot().getYAxis(0);
                } else if (this.axis == 11) {
                    plotAxis = PlotterRegion.this.getPlot().getYAxis(1);
                }
                if (plotAxis != null) {
                    if (Double.isNaN(this.min) && Double.isNaN(this.max)) {
                        plotAxis.setRangeAutomatic(true);
                    } else {
                        if (Double.isNaN(this.min)) {
                            this.min = plotAxis.getMin();
                        }
                        if (Double.isNaN(this.max)) {
                            this.max = plotAxis.getMax();
                        }
                        plotAxis.setRange(this.min, this.max);
                    }
                }
            }
        }
    }

    private class ClearRegion
    implements Runnable {
        private ClearRegion() {
        }

        public void run() {
            PlotterRegion.this.clearRegion();
        }
    }

    private static class AddRemove
    implements Runnable {
        private boolean add;
        private PlotterRegion region;
        private Object thing;
        private IPlotterStyle styleObj;
        private String options;

        AddRemove(boolean add, PlotterRegion region, Object thing) {
            this(add, region, thing, null);
        }

        AddRemove(boolean add, PlotterRegion region, Object thing, IPlotterStyle styleObj) {
            this(add, region, thing, styleObj, null);
        }

        AddRemove(boolean add, PlotterRegion region, Object thing, IPlotterStyle styleObj, String options) {
            this.add = add;
            this.region = region;
            this.thing = thing;
            this.styleObj = styleObj;
            this.options = options;
        }

        public void run() {
            if (this.add) {
                this.region.addToRegion(this.thing, this.styleObj, this.options);
            } else {
                this.region.removeObjectFromRegion(this.thing);
            }
            this.region.panel.repaint();
        }
    }
}

