/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IHistogram;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.AbstractBaseHistogram;
import java.util.EventObject;

public abstract class Histogram
extends AbstractBaseHistogram
implements IHistogram,
IsObservable {
    protected static final int X_AXIS = 0;
    protected static final int Y_AXIS = 1;
    protected static final int Z_AXIS = 2;
    protected int allEntries = 0;
    protected int validEntries = 0;
    protected double sumOfWeights = 0.0;
    protected double sumOfWeightsSquared = 0.0;
    protected boolean isFillable = true;
    private String options;
    private boolean useOutflows = false;
    protected boolean meanAndRmsIsSet = false;

    protected Histogram(String name, String title, int dimension, String options) {
        super(name, title, dimension, options);
        this.options = options;
    }

    protected EventObject createEvent() {
        return new HistogramEvent(this);
    }

    public void reset() {
        super.reset();
        this.allEntries = 0;
        this.validEntries = 0;
        this.isFillable = true;
        this.sumOfWeights = 0.0;
        this.sumOfWeightsSquared = 0.0;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public int entries() {
        return this.validEntries;
    }

    public int allEntries() {
        return this.allEntries;
    }

    public abstract int extraEntries();

    public double equivalentBinEntries() {
        if (this.validEntries != 0) {
            return this.sumOfWeights * this.sumOfWeights / this.sumOfWeightsSquared;
        }
        return 0.0;
    }

    public double sumBinHeights() {
        return this.sumAllBinHeights() - this.sumExtraBinHeights();
    }

    public abstract double sumAllBinHeights();

    public abstract double sumExtraBinHeights();

    public abstract double minBinHeight();

    public abstract double maxBinHeight();

    public abstract void scale(double var1);

    public void setNEntries(int entries) {
        this.allEntries = entries;
    }

    public void setValidEntries(int entries) {
        this.validEntries = entries;
    }

    protected String options() {
        return this.options;
    }

    protected boolean useOutflows() {
        return this.useOutflows;
    }

    protected void setUseOutflows(boolean useOutflows) {
        this.useOutflows = useOutflows;
    }

    public int nanEntries() {
        return this.allEntries() - this.entries() - this.extraEntries();
    }

    public boolean isMeanAndRmsSet() {
        return this.meanAndRmsIsSet;
    }
}

