/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.dataset;

import hep.aida.ref.dataset.MeanAndRmsStatistics;

public class DataStatistics {
    private double sw;
    private double sws;
    private int en;
    private MeanAndRmsStatistics[] stats;
    private int dimension;

    public DataStatistics(String[] descriptions) {
        this(descriptions.length);
        this.setDescription(descriptions);
    }

    public DataStatistics(int dimension) {
        this.dimension = dimension;
        this.stats = new MeanAndRmsStatistics[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.stats[i] = new MeanAndRmsStatistics(String.valueOf(i));
        }
        this.reset();
    }

    public int dimension() {
        return this.dimension;
    }

    public void addEntry(double[] x, double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("Cannot accept an entry with negative weight " + w);
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.stats[i].addEntry(x[i], w);
        }
        this.sw += w;
        this.sws += w * w;
        ++this.en;
    }

    public void addEntry(double[] x) {
        this.addEntry(x, 1.0);
    }

    public void removeEntry(double[] x, double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("Cannot accept an entry with negative weight " + w);
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.stats[i].removeEntry(x[i], w);
        }
        this.sw -= w;
        this.sws -= w * w;
        --this.en;
    }

    public void removeEntry(double[] x) {
        this.removeEntry(x, 1.0);
    }

    public void addEntries(double[] mean, double[] rms, double sumw, double sumw2, int entries) {
        for (int i = 0; i < this.dimension; ++i) {
            this.stats[i].addEntries(mean[i], rms[i], sumw);
        }
        this.sw += sumw;
        this.sws += sumw2;
        this.en += entries;
    }

    public void addEntries(double[] mean, double[] rms, int entries) {
        this.addEntries(mean, rms, entries, entries, entries);
    }

    public void removeEntries(double[] mean, double[] rms, double sumw, double sumw2, int entries) {
        for (int i = 0; i < this.dimension; ++i) {
            this.stats[i].removeEntries(mean[i], rms[i], sumw);
        }
        this.sw -= sumw;
        this.sws -= sumw2;
        this.en -= entries;
    }

    public void removeEntries(double[] mean, double[] rms, int entries) {
        this.removeEntries(mean, rms, entries, entries, entries);
    }

    public double mean(int coord) {
        return this.stats[coord].mean();
    }

    public double rms(int coord) {
        return this.stats[coord].rms();
    }

    public double sumOfWeights() {
        return this.sw;
    }

    public double equivalentEntries() {
        if (this.en > 0) {
            return this.sw * this.sw / this.sws;
        }
        return 0.0;
    }

    public int entries() {
        return this.en;
    }

    public void scale(double scaleFactor) {
        if (scaleFactor > 0.0) {
            for (int i = 0; i < this.dimension; ++i) {
                this.stats[i].scale(scaleFactor);
            }
            this.sw *= scaleFactor;
            this.sws *= scaleFactor * scaleFactor;
        } else {
            throw new IllegalArgumentException("Invalid scale factor " + scaleFactor + ". It must be positive");
        }
    }

    public void reset() {
        this.sw = 0.0;
        this.sws = 0.0;
        this.en = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.stats[i].reset();
        }
    }

    public void setDescription(String[] descriptions) {
        if (descriptions.length != this.dimension) {
            throw new IllegalArgumentException("Illegal dimension " + descriptions.length + " for the array of descriptions. It has to be equal to the dimension of the data set: " + this.dimension);
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.setDescription(i, descriptions[i]);
        }
    }

    public void setDescription(int coord, String description) {
        if (coord < 0 || coord >= this.dimension) {
            throw new IllegalArgumentException("Illegal coordinate " + coord + ". It must be between 0 and " + this.dimension);
        }
        this.stats[coord].setDescription(description);
    }

    public String description(int coord) {
        return this.stats[coord].description();
    }
}

