/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.webdav.WebDavProtocol;
import com.bradmcevoy.property.PropertySource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class PropertyMap {
    private final Map<String, StandardProperty> writersMap = new HashMap<String, StandardProperty>();
    private final String nameSpace;

    public PropertyMap(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public boolean hasProperty(QName name) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return false;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        return pa != null;
    }

    public Object getProperty(QName name, Resource r) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return null;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        if (pa == null) {
            return null;
        }
        if (r instanceof PropFindableResource) {
            return pa.getValue((PropFindableResource)r);
        }
        return null;
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        if (pa == null) {
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        if (r instanceof PropFindableResource) {
            return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.READ_ONLY, pa.getValueClass());
        }
        return PropertySource.PropertyMetaData.UNKNOWN;
    }

    public List<QName> getAllPropertyNames(Resource r) {
        ArrayList<QName> list = new ArrayList<QName>();
        for (String nm : this.writersMap.keySet()) {
            QName qname = new QName(WebDavProtocol.NS_DAV.getName(), nm);
            list.add(qname);
        }
        return list;
    }

    public void add(StandardProperty pw) {
        this.writersMap.put(pw.fieldName(), pw);
    }

    public static interface StandardProperty<T> {
        public String fieldName();

        public T getValue(PropFindableResource var1);

        public Class getValueClass();
    }
}

