/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandlerHelper;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.webdav.DefaultPropFindRequestFieldParser;
import com.bradmcevoy.http.webdav.MsPropFindRequestFieldParser;
import com.bradmcevoy.http.webdav.PropFindPropertyBuilder;
import com.bradmcevoy.http.webdav.PropFindRequestFieldParser;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.http.webdav.ResourceTypeHelper;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.bradmcevoy.property.DefaultPropertyAuthoriser;
import com.bradmcevoy.property.PropertyAuthoriser;
import com.bradmcevoy.property.PropertyHandler;
import com.bradmcevoy.property.PropertySource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindHandler
implements ExistingEntityHandler,
PropertyHandler {
    private static final Logger log = LoggerFactory.getLogger(PropFindHandler.class);
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final PropFindRequestFieldParser requestFieldParser;
    private final WebDavResponseHandler responseHandler;
    private final PropFindPropertyBuilder propertyBuilder;
    private PropertyAuthoriser permissionService = new DefaultPropertyAuthoriser();

    public PropFindHandler(ResourceHandlerHelper resourceHandlerHelper, ResourceTypeHelper resourceTypeHelper, WebDavResponseHandler responseHandler, List<PropertySource> propertySources) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        DefaultPropFindRequestFieldParser defaultFieldParse = new DefaultPropFindRequestFieldParser();
        this.requestFieldParser = new MsPropFindRequestFieldParser(defaultFieldParse);
        this.responseHandler = responseHandler;
        this.propertyBuilder = new PropFindPropertyBuilder(propertySources);
    }

    public PropFindHandler(ResourceHandlerHelper resourceHandlerHelper, PropFindRequestFieldParser requestFieldParser, WebDavResponseHandler responseHandler, PropFindPropertyBuilder propertyBuilder) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.requestFieldParser = requestFieldParser;
        this.responseHandler = responseHandler;
        this.propertyBuilder = propertyBuilder;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.PROPFIND.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof PropFindableResource;
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, ConflictException, BadRequestException {
        long t = System.currentTimeMillis();
        try {
            manager.onProcessResourceStart(request, response, resource);
            if (this.resourceHandlerHelper.isNotCompatible(resource, request.getMethod()) || !this.isCompatible(resource)) {
                if (log.isTraceEnabled()) {
                    log.trace("resource not compatible. Resource class: " + resource.getClass() + " handler: " + this.getClass());
                }
                this.responseHandler.respondMethodNotImplemented(resource, response, request);
                return;
            }
            AuthenticationService.AuthStatus authStatus = this.resourceHandlerHelper.checkAuthentication(manager, resource, request);
            if (authStatus != null && authStatus.loginFailed) {
                if (log.isTraceEnabled()) {
                    log.trace("authentication failed. respond with: " + this.responseHandler.getClass().getCanonicalName() + " resource: " + resource.getClass().getCanonicalName());
                }
                this.responseHandler.respondUnauthorised(resource, response, request);
                return;
            }
            if (request.getMethod().isWrite && this.resourceHandlerHelper.isLockedOut(request, resource)) {
                response.setStatus(Response.Status.SC_LOCKED);
                return;
            }
            this.processExistingResource(manager, request, response, resource);
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        PropFindRequestFieldParser.ParseResult parseResult;
        log.trace("processExistingResource");
        PropFindableResource pfr = (PropFindableResource)resource;
        int depth = request.getDepthHeader();
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        try {
            parseResult = this.requestFieldParser.getRequestedFields(request.getInputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String url = request.getAbsoluteUrl();
        Set<QName> allFields = this.getAllFields(parseResult, pfr);
        Set<PropertyAuthoriser.CheckResult> errorFields = this.permissionService.checkPermissions(request, request.getMethod(), PropertyAuthoriser.PropertyPermission.READ, allFields, resource);
        if (errorFields != null && errorFields.size() > 0) {
            if (log.isTraceEnabled()) {
                log.trace("permissionService denied access: " + this.permissionService.getClass().getCanonicalName());
            }
            this.responseHandler.respondUnauthorised(resource, response, request);
        } else {
            List<PropFindResponse> propFindResponses;
            try {
                propFindResponses = this.propertyBuilder.buildProperties(pfr, depth, parseResult, url);
            }
            catch (URISyntaxException ex) {
                log.error("Exception parsing url. request class: " + request.getClass() + ". Please check the client application is usign percentage encoding (see http://en.wikipedia.org/wiki/Percent-encoding)");
                throw new RuntimeException("Exception parsing url, indicating the requested URL is not correctly encoded. Please check the client application. Requested url is: " + url, ex);
            }
            if (log.isTraceEnabled()) {
                log.trace("responses: " + propFindResponses.size());
            }
            this.responseHandler.respondPropFind(propFindResponses, response, request, pfr);
        }
    }

    private Set<QName> getAllFields(PropFindRequestFieldParser.ParseResult parseResult, PropFindableResource resource) {
        HashSet<QName> set = new HashSet<QName>();
        if (parseResult.isAllProp()) {
            set.addAll(this.propertyBuilder.findAllProps(resource));
        } else {
            set.addAll(parseResult.getNames());
        }
        return set;
    }

    @Override
    public PropertyAuthoriser getPermissionService() {
        return this.permissionService;
    }

    @Override
    public void setPermissionService(PropertyAuthoriser permissionService) {
        this.permissionService = permissionService;
    }
}

