/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11.auth;

import com.bradmcevoy.http.http11.auth.Nonce;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredNonceRemover
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExpiredNonceRemover.class);
    private static final int INTERVAL = 10;
    private final Map<UUID, Nonce> nonces;
    private final int nonceValiditySeconds;
    private final ScheduledExecutorService scheduler;

    public ExpiredNonceRemover(Map<UUID, Nonce> nonces, int nonceValiditySeconds) {
        this.nonces = nonces;
        this.nonceValiditySeconds = nonceValiditySeconds;
        log.debug("scheduling checks for expired nonces every 10 seconds");
        this.scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory());
        this.scheduler.scheduleAtFixedRate(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        Iterator<UUID> it = this.nonces.keySet().iterator();
        while (it.hasNext()) {
            UUID key = it.next();
            Nonce n = this.nonces.get(key);
            if (!this.isExpired(n.getIssued())) continue;
            log.debug("removing expired nonce: " + key);
            it.remove();
        }
    }

    private boolean isExpired(Date issued) {
        long dif = (System.currentTimeMillis() - issued.getTime()) / 1000L;
        return dif > (long)this.nonceValiditySeconds;
    }

    private class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

