/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.MakeCollectionableResource;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.ReplaceableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.http.http11.PartialllyUpdateableResource;
import com.bradmcevoy.http.http11.PutHelper;
import com.bradmcevoy.http.quota.StorageChecker;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.bradmcevoy.io.FileUtils;
import com.bradmcevoy.io.RandomFileOutputStream;
import com.ettrema.common.LogUtils;
import com.ettrema.event.NewFolderEvent;
import com.ettrema.event.PutEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutHandler
implements Handler {
    private static final Logger log = LoggerFactory.getLogger(PutHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private final PutHelper putHelper;

    public PutHandler(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.putHelper = new PutHelper();
        this.checkResponseHandler();
    }

    public PutHandler(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper, PutHelper putHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.putHelper = putHelper;
        this.checkResponseHandler();
    }

    private void checkResponseHandler() {
        if (!(this.responseHandler instanceof WebDavResponseHandler)) {
            log.warn("response handler is not a WebDavResponseHandler, so locking and quota checking will not be enabled");
        }
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.PUT.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof PutableResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String urlToCreateOrUpdate = HttpManager.decodeUrl(request.getAbsolutePath());
        log.debug("process request: host: " + host + " url: " + urlToCreateOrUpdate);
        Path path = Path.path(urlToCreateOrUpdate);
        urlToCreateOrUpdate = path.toString();
        Resource existingResource = manager.getResourceFactory().getResource(host, urlToCreateOrUpdate);
        StorageChecker.StorageErrorReason storageErr = null;
        if (existingResource != null) {
            if (this.handlerHelper.isLockedOut(request, existingResource)) {
                log.warn("resource is locked, but not by the current user");
                this.respondLocked(request, response, existingResource);
                return;
            }
            Resource parent = manager.getResourceFactory().getResource(host, path.getParent().toString());
            if (parent instanceof CollectionResource) {
                CollectionResource parentCol = (CollectionResource)parent;
                storageErr = this.handlerHelper.checkStorageOnReplace(request, parentCol, existingResource, host);
            } else {
                log.warn("parent exists but is not a collection resource: " + path.getParent());
            }
        } else {
            CollectionResource parentCol = this.putHelper.findNearestParent(manager, host, path);
            storageErr = this.handlerHelper.checkStorageOnAdd(request, parentCol, path.getParent(), host);
        }
        if (storageErr != null) {
            this.respondInsufficientStorage(request, response, storageErr);
            return;
        }
        ReplaceableResource replacee = existingResource != null && existingResource instanceof ReplaceableResource ? (ReplaceableResource)existingResource : null;
        if (replacee != null) {
            if (log.isTraceEnabled()) {
                log.trace("replacing content in: " + replacee.getName() + " - " + replacee.getClass());
            }
            long t = System.currentTimeMillis();
            try {
                manager.onProcessResourceStart(request, response, replacee);
                this.processReplace(manager, request, response, replacee);
            }
            finally {
                t = System.currentTimeMillis() - t;
                manager.onProcessResourceFinish(request, response, replacee, t);
            }
        } else {
            String nameToCreate = path.getName();
            CollectionResource folderResource = this.findOrCreateFolders(manager, host, path.getParent());
            if (folderResource != null) {
                long t = System.currentTimeMillis();
                try {
                    if (folderResource instanceof PutableResource) {
                        if (this.handlerHelper.isLockedOut(request, folderResource)) {
                            this.respondLocked(request, response, folderResource);
                            return;
                        }
                        PutableResource putableResource = (PutableResource)folderResource;
                        this.processCreate(manager, request, response, putableResource, nameToCreate);
                    }
                    manager.getResponseHandler().respondMethodNotImplemented(folderResource, response, request);
                }
                finally {
                    t = System.currentTimeMillis() - t;
                    manager.onProcessResourceFinish(request, response, folderResource, t);
                }
            } else {
                this.responseHandler.respondNotFound(response, request);
            }
        }
    }

    private void processCreate(HttpManager manager, Request request, Response response, PutableResource folder, String newName) throws ConflictException, BadRequestException, NotAuthorizedException {
        if (!this.handlerHelper.checkAuthorisation(manager, folder, request)) {
            this.responseHandler.respondUnauthorised(folder, response, request);
            return;
        }
        LogUtils.debug(log, "process: putting to: ", folder.getName());
        try {
            Long l = this.putHelper.getContentLength(request);
            String ct = this.putHelper.findContentTypes(request, newName);
            LogUtils.debug(log, "PutHandler: creating resource of type: ", ct);
            Resource newlyCreated = folder.createNew(newName, request.getInputStream(), l, ct);
            manager.getEventManager().fireEvent(new PutEvent(newlyCreated));
        }
        catch (IOException ex) {
            log.warn("IOException reading input stream. Probably interrupted upload: " + ex.getMessage());
            return;
        }
        manager.getResponseHandler().respondCreated(folder, response, request);
    }

    private CollectionResource findOrCreateFolders(HttpManager manager, String host, Path path) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (path == null) {
            return null;
        }
        Resource thisResource = manager.getResourceFactory().getResource(host, path.toString());
        if (thisResource != null) {
            if (thisResource.getName() != null && !thisResource.getName().equals(path.getName())) {
                log.warn("Your resource factory returned a resource with a different name to that requested!!! Requested: " + path.getName() + " returned: " + thisResource.getName() + " - resource factory: " + manager.getResourceFactory().getClass());
            }
            if (thisResource instanceof CollectionResource) {
                return (CollectionResource)thisResource;
            }
            log.warn("parent is not a collection: " + path);
            return null;
        }
        CollectionResource parent = this.findOrCreateFolders(manager, host, path.getParent());
        if (parent == null) {
            log.warn("couldnt find parent: " + path);
            return null;
        }
        Resource r = parent.child(path.getName());
        if (r == null) {
            if (parent instanceof MakeCollectionableResource) {
                MakeCollectionableResource mkcol = (MakeCollectionableResource)parent;
                log.debug("autocreating new folder: " + path.getName());
                CollectionResource newCol = mkcol.createCollection(path.getName());
                manager.getEventManager().fireEvent(new NewFolderEvent(newCol));
                return newCol;
            }
            log.debug("parent folder isnt a MakeCollectionableResource: " + parent.getName());
            return null;
        }
        if (r instanceof CollectionResource) {
            return (CollectionResource)r;
        }
        log.debug("parent in URL is not a collection: " + r.getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplace(HttpManager manager, Request request, Response response, ReplaceableResource replacee) throws BadRequestException, NotAuthorizedException, ConflictException, NotFoundException {
        block8: {
            if (!this.handlerHelper.checkAuthorisation(manager, replacee, request)) {
                this.responseHandler.respondUnauthorised(replacee, response, request);
                return;
            }
            try {
                block9: {
                    block10: {
                        long length;
                        Range range = this.putHelper.parseContentRange(replacee, request);
                        if (range == null) break block9;
                        log.debug("partial put: " + range);
                        if (replacee instanceof PartialllyUpdateableResource) {
                            log.debug("doing partial put on a PartialllyUpdateableResource");
                            PartialllyUpdateableResource partialllyUpdateableResource = (PartialllyUpdateableResource)replacee;
                            partialllyUpdateableResource.replacePartialContent(range, request.getInputStream());
                            break block8;
                        }
                        if (!(replacee instanceof GetableResource)) break block10;
                        log.debug("doing partial put on a GetableResource");
                        File tempFile = File.createTempFile("milton-partial", null);
                        RandomAccessFile randomAccessFile = null;
                        try {
                            int numBytesRead;
                            randomAccessFile = new RandomAccessFile(tempFile, "rw");
                            RandomFileOutputStream tempOut = new RandomFileOutputStream(tempFile);
                            GetableResource gr = (GetableResource)((Object)replacee);
                            gr.sendContent(tempOut, null, null, null);
                            length = randomAccessFile.length();
                            if (range.getFinish() + 1L > length) {
                                length = range.getFinish() + 1L;
                            }
                            randomAccessFile.setLength(length);
                            randomAccessFile.seek(range.getStart());
                            byte[] copyBuffer = new byte[1024];
                            InputStream newContent = request.getInputStream();
                            while ((numBytesRead = newContent.read(copyBuffer)) != -1) {
                                randomAccessFile.write(copyBuffer, 0, numBytesRead);
                            }
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(randomAccessFile);
                            throw throwable;
                        }
                        FileUtils.close(randomAccessFile);
                        FileInputStream updatedContent = new FileInputStream(tempFile);
                        BufferedInputStream bufin = new BufferedInputStream(updatedContent);
                        replacee.replaceContent(bufin, length);
                        break block8;
                    }
                    throw new BadRequestException(replacee, "Cant apply partial update. Resource does not support PartialllyUpdateableResource or GetableResource");
                }
                Long l = request.getContentLengthHeader();
                replacee.replaceContent(request.getInputStream(), l);
            }
            catch (IOException ex) {
                log.warn("IOException reading input stream. Probably interrupted upload: " + ex.getMessage());
                return;
            }
        }
        this.responseHandler.respondNoContent(replacee, response, request);
        log.debug("process: finished");
    }

    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        String host = request.getHostHeader();
        String urlToCreateOrUpdate = HttpManager.decodeUrl(request.getAbsolutePath());
        log.debug("process request: host: " + host + " url: " + urlToCreateOrUpdate);
        Path path = Path.path(urlToCreateOrUpdate);
        urlToCreateOrUpdate = path.toString();
        Resource existingResource = manager.getResourceFactory().getResource(host, urlToCreateOrUpdate);
        if (existingResource != null && this.handlerHelper.isLockedOut(request, existingResource)) {
            log.warn("resource is locked, but not by the current user");
            response.setStatus(Response.Status.SC_LOCKED);
            return;
        }
        ReplaceableResource replacee = existingResource != null && existingResource instanceof ReplaceableResource ? (ReplaceableResource)existingResource : null;
        if (replacee != null) {
            this.processReplace(manager, request, response, (ReplaceableResource)existingResource);
        } else {
            String urlFolder = path.getParent().toString();
            String nameToCreate = path.getName();
            CollectionResource folderResource = this.findOrCreateFolders(manager, host, path.getParent());
            if (folderResource != null) {
                if (log.isDebugEnabled()) {
                    log.debug("found folder: " + urlFolder + " - " + folderResource.getClass());
                }
                if (folderResource instanceof PutableResource) {
                    if (this.handlerHelper.isLockedOut(request, folderResource)) {
                        response.setStatus(Response.Status.SC_LOCKED);
                        return;
                    }
                    PutableResource putableResource = (PutableResource)folderResource;
                    this.processCreate(manager, request, response, putableResource, nameToCreate);
                } else {
                    this.responseHandler.respondMethodNotImplemented(folderResource, response, request);
                }
            } else {
                this.responseHandler.respondNotFound(response, request);
            }
        }
    }

    private void respondLocked(Request request, Response response, Resource existingResource) {
        if (this.responseHandler instanceof WebDavResponseHandler) {
            WebDavResponseHandler rh = (WebDavResponseHandler)this.responseHandler;
            rh.respondLocked(request, response, existingResource);
        } else {
            response.setStatus(Response.Status.SC_LOCKED);
        }
    }

    private void respondInsufficientStorage(Request request, Response response, StorageChecker.StorageErrorReason storageErrorReason) {
        if (this.responseHandler instanceof WebDavResponseHandler) {
            WebDavResponseHandler rh = (WebDavResponseHandler)this.responseHandler;
            rh.respondInsufficientStorage(request, response, storageErrorReason);
        } else {
            response.setStatus(Response.Status.SC_INSUFFICIENT_STORAGE);
        }
    }
}

