/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(StandardFilter.class);
    public static final String INTERNAL_SERVER_ERROR_HTML = "<html><body><h1>Internal Server Error (500)</h1></body></html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(FilterChain chain, Request request, Response response) {
        HttpManager manager = chain.getHttpManager();
        try {
            Request.Method method = request.getMethod();
            Handler handler = manager.getMethodHandler(method);
            if (handler == null) {
                this.log.trace("No handler for: " + (Object)((Object)method));
                manager.getResponseHandler().respondMethodNotImplemented(null, response, request);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("delegate to method handler: " + handler.getClass().getCanonicalName());
                }
                handler.process(manager, request, response);
            }
        }
        catch (BadRequestException ex) {
            this.log.warn("BadRequestException: " + ex.getReason());
            manager.getResponseHandler().respondBadRequest(ex.getResource(), response, request);
        }
        catch (ConflictException ex) {
            this.log.warn("conflictException: " + ex.getMessage());
            manager.getResponseHandler().respondConflict(ex.getResource(), response, request, INTERNAL_SERVER_ERROR_HTML);
        }
        catch (NotAuthorizedException ex) {
            this.log.warn("NotAuthorizedException");
            manager.getResponseHandler().respondUnauthorised(ex.getResource(), response, request);
        }
        catch (Throwable e) {
            this.log.error("process", e);
            try {
                manager.getResponseHandler().respondServerError(request, response, INTERNAL_SERVER_ERROR_HTML);
            }
            catch (Throwable ex) {
                this.log.error("Exception generating server error response, setting response status to 500", ex);
                response.setStatus(Response.Status.SC_INTERNAL_SERVER_ERROR);
            }
        }
        finally {
            response.close();
        }
    }
}

