/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AbstractWrappingResponseHandler;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.bradmcevoy.http.http11.CacheControlHelper;
import com.bradmcevoy.http.http11.DefaultCacheControlHelper;
import com.bradmcevoy.http.http11.DefaultHttp11ResponseHandler;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.bradmcevoy.io.BufferingOutputStream;
import com.bradmcevoy.io.FileUtils;
import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.StreamUtils;
import com.bradmcevoy.io.WritingException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressingResponseHandler
extends AbstractWrappingResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(CompressingResponseHandler.class);
    private int maxMemorySize = 100000;
    private CacheControlHelper cacheControlHelper = new DefaultCacheControlHelper();

    public CompressingResponseHandler() {
    }

    public CompressingResponseHandler(WebDavResponseHandler wrapped) {
        super(wrapped);
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        if (resource instanceof GetableResource) {
            GetableResource r = (GetableResource)resource;
            String acceptableContentTypes = request.getAcceptHeader();
            String contentType = r.getContentType(acceptableContentTypes);
            if (this.canCompress(r, contentType, request.getAcceptEncodingHeader())) {
                log.trace("respondContent: compressable");
                BufferingOutputStream tempOut = new BufferingOutputStream(this.maxMemorySize);
                try {
                    GZIPOutputStream gzipOut = new GZIPOutputStream(tempOut);
                    r.sendContent(gzipOut, null, params, contentType);
                    ((OutputStream)gzipOut).flush();
                    ((OutputStream)gzipOut).close();
                    tempOut.flush();
                }
                catch (NotFoundException e) {
                    throw e;
                }
                catch (Exception ex) {
                    tempOut.deleteTempFileIfExists();
                    throw new RuntimeException(ex);
                }
                finally {
                    FileUtils.close(tempOut);
                }
                log.trace("respondContent-compressed: " + resource.getClass());
                this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, request.getAuthorization());
                response.setContentEncodingHeader(Response.ContentEncoding.GZIP);
                response.setVaryHeader("Accept-Encoding");
                Long contentLength = tempOut.getSize();
                response.setContentLengthHeader(contentLength);
                response.setContentTypeHeader(contentType);
                this.cacheControlHelper.setCacheControl(r, response, request.getAuthorization());
                InputStream in = tempOut.getInputStream();
                try {
                    StreamUtils.readTo(in, response.getOutputStream());
                }
                catch (ReadingException ex) {
                    throw new RuntimeException(ex);
                }
                catch (WritingException ex) {
                    log.warn("exception writing, client probably closed connection", (Throwable)ex);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                log.trace("finished sending content");
                return;
            }
        } else {
            throw new RuntimeException("Cant generate content for non-Getable resource: " + resource.getClass());
        }
        log.trace("respondContent: not compressable");
        this.wrapped.respondContent(resource, response, request, params);
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        response.setStatus(status);
        response.setDateHeader(new Date());
        String etag = this.wrapped.generateEtag(resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        DefaultHttp11ResponseHandler.setModifiedDate(response, resource, auth);
    }

    private boolean canCompress(GetableResource r, String contentType, String acceptableEncodings) {
        log.trace("canCompress: contentType: " + contentType + " acceptable-encodings: " + acceptableEncodings);
        if (contentType != null) {
            boolean contentIsCompressable;
            boolean bl = contentIsCompressable = (contentType = contentType.toLowerCase()).contains("text") || contentType.contains("css") || contentType.contains("js") || contentType.contains("javascript");
            if (contentIsCompressable) {
                boolean supportsGzip = acceptableEncodings != null && acceptableEncodings.toLowerCase().indexOf("gzip") > -1;
                log.trace("supports gzip: " + supportsGzip);
                return supportsGzip;
            }
        }
        return false;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }
}

