/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.common;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeUtils {
    private static Logger log = LoggerFactory.getLogger(ContentTypeUtils.class);

    public static String findContentTypes(String name) {
        Collection mimeTypes = MimeUtil.getMimeTypes((String)name);
        return mimeTypes.toString();
    }

    public static String findContentTypes(File file) {
        Collection mimeTypes = null;
        try {
            mimeTypes = MimeUtil.getMimeTypes((String)file.getName());
        }
        catch (MimeException e) {
            log.warn("exception retrieving content type for file: " + file.getAbsolutePath(), (Throwable)e);
            return "application/binary";
        }
        String s = mimeTypes.toString();
        log.trace("findContentTypes: {}", (Object)file.getName(), (Object)mimeTypes);
        return s;
    }

    public static String findAcceptableContentType(String mime, String preferredList) {
        MimeType mt = MimeUtil.getPreferedMimeType((String)preferredList, (String)mime);
        return mt.toString();
    }

    private static String buildContentTypeText(Collection mimeTypes) {
        StringBuilder sb = null;
        for (Object o : mimeTypes) {
            MimeType mt = (MimeType)o;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(",");
            }
            sb.append(mt.toString());
        }
        if (sb == null) {
            return "";
        }
        return sb.toString();
    }

    static {
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
    }
}

