/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import diskCacheV111.movers.NetIFContainer;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.NetworkUtils;
import org.dcache.vehicles.XrootdDoorAdressInfoMessage;
import org.dcache.vehicles.XrootdProtocolInfo;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.pool.ReadDescriptor;
import org.dcache.xrootd.pool.WriteDescriptor;
import org.dcache.xrootd.pool.XrootdPoolNettyServer;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.util.FileStatus;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdProtocol_3
implements MoverProtocol {
    private static final int DEFAULT_FILESTATUS_ID = 0;
    private static final int DEFAULT_FILESTATUS_FLAGS = 0;
    private static final int DEFAULT_FILESTATUS_MODTIME = 0;
    private static final long CONNECT_TIMEOUT = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private static final long SPACE_INC = 0x3200000L;
    private static final Logger _log = LoggerFactory.getLogger(XrootdProtocol_3.class);
    private static final Logger _logSpaceAllocation = LoggerFactory.getLogger((String)("logger.dev.org.dcache.poolspacemonitor." + XrootdProtocol_3.class.getName()));
    private final CellEndpoint _endpoint;
    private final CountDownLatch _closeLatch = new CountDownLatch(1);
    private RepositoryChannel _fileChannel;
    private static XrootdPoolNettyServer _server;
    private XrootdProtocolInfo _protocolInfo;
    private volatile InetSocketAddress _doorAddress;
    private Allocator _allocator;
    protected long _reservedSpace;
    private volatile boolean _inProgress = false;
    private volatile boolean _hasOpenedDescriptor = false;
    private volatile boolean _wasChanged = false;
    private volatile long _transferStarted;
    private static int _maxFrameSize;
    private AtomicLong _lastTransferred = new AtomicLong();
    private AtomicLong _bytesTransferred = new AtomicLong();
    private Set<FileDescriptor> _openedDescriptors = Collections.synchronizedSet(new HashSet());

    private static synchronized void initSharedResources(Args args) {
        if (_server == null) {
            int threads = args.getIntOption("xrootd-mover-disk-threads");
            int perChannelLimit = args.getIntOption("xrootd-mover-max-memory-per-connection");
            int totalLimit = args.getIntOption("xrootd-mover-max-memory");
            int clientIdleTimeout = args.getIntOption("xrootd-mover-idle-client-timeout");
            String socketThreads = args.getOpt("xrootd-mover-socket-threads");
            _server = socketThreads == null || socketThreads.isEmpty() ? new XrootdPoolNettyServer(threads, perChannelLimit, totalLimit, clientIdleTimeout) : new XrootdPoolNettyServer(threads, perChannelLimit, totalLimit, clientIdleTimeout, Integer.parseInt(socketThreads));
        }
    }

    public XrootdProtocol_3(CellEndpoint endpoint) {
        this._endpoint = endpoint;
        XrootdProtocol_3.initSharedResources(this._endpoint.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runIO(RepositoryChannel fileChannel, ProtocolInfo protocol, StorageInfo storage, PnfsId pnfsId, Allocator allocator, IoMode access) throws Exception {
        boolean transferSuccess;
        this._protocolInfo = (XrootdProtocolInfo)protocol;
        this._doorAddress = this._protocolInfo.getDoorAddress();
        UUID uuid = this._protocolInfo.getUUID();
        _log.debug("Received opaque information {}", (Object)uuid);
        try {
            _server.register(uuid, this);
            this._fileChannel = fileChannel;
            this._allocator = allocator;
            this._transferStarted = System.currentTimeMillis();
            this._lastTransferred.set(this._transferStarted);
            InetSocketAddress address = _server.getServerAddress();
            this.sendAddressToDoor(address.getPort());
            _log.debug("Starting xrootd server");
            this._inProgress = true;
            if (!this._closeLatch.await(CONNECT_TIMEOUT, TimeUnit.MILLISECONDS)) {
                if (!this._hasOpenedDescriptor) {
                    throw new TimeoutCacheException("No connection from Xrootd client after " + TimeUnit.MILLISECONDS.toSeconds(CONNECT_TIMEOUT) + " seconds. Giving up.");
                }
                this._closeLatch.await();
            }
        }
        finally {
            _server.unregister(uuid);
            this._fileChannel = null;
            this._allocator = null;
            this._inProgress = false;
            transferSuccess = this.isTransferSuccessful(access);
            this._openedDescriptors.clear();
        }
        if (!transferSuccess) {
            _log.warn("Xrootd transfer failed");
            throw new CacheException("xrootd transfer failed");
        }
        _log.debug("Xrootd transfer completed, transferred {} bytes.", (Object)this._bytesTransferred.get());
    }

    private void sendAddressToDoor(int port) throws UnknownHostException, SocketException, CacheException, NoRouteToCellException {
        ArrayList<NetIFContainer> netifsCol = new ArrayList<NetIFContainer>();
        InetAddress localIP = NetworkUtils.getLocalAddress((InetAddress)this._protocolInfo.getSocketAddress().getAddress());
        if (localIP != null && !localIP.isLoopbackAddress() && localIP instanceof Inet4Address) {
            ArrayList<InetAddress> col = new ArrayList<InetAddress>(1);
            col.add(localIP);
            netifsCol.add(new NetIFContainer("", col));
            _log.debug("sending ip-address derived from hostname to Xrootd-door: " + localIP + " port: " + port);
        } else {
            Enumeration<NetworkInterface> ifList = NetworkInterface.getNetworkInterfaces();
            while (ifList.hasMoreElements()) {
                NetworkInterface netif = ifList.nextElement();
                Enumeration<InetAddress> ips = netif.getInetAddresses();
                ArrayList<InetAddress> ipsCol = new ArrayList<InetAddress>(2);
                while (ips.hasMoreElements()) {
                    InetAddress addr = ips.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    ipsCol.add(addr);
                    _log.debug("sending ip-address derived from network-if to Xrootd-door: " + addr + " port: " + port);
                }
                if (ipsCol.size() <= 0) continue;
                netifsCol.add(new NetIFContainer(netif.getName(), ipsCol));
            }
            if (netifsCol.isEmpty()) {
                throw new CacheException("Error: Cannot determine my ipaddress. Aborting transfer");
            }
        }
        CellPath cellpath = this._protocolInfo.getXrootdDoorCellPath();
        boolean uuidEnabledPool = true;
        XrootdDoorAdressInfoMessage doorMsg = new XrootdDoorAdressInfoMessage(this._protocolInfo.getXrootdFileHandle(), port, netifsCol, uuidEnabledPool);
        this._endpoint.sendMessage(new CellMessage(cellpath, (Object)doorMsg));
        _log.debug("sending redirect message to Xrootd-door " + cellpath);
    }

    @Override
    public long getBytesTransferred() {
        return this._bytesTransferred.get();
    }

    @Override
    public long getTransferTime() {
        return (this._inProgress ? System.currentTimeMillis() : this._lastTransferred.get()) - this._transferStarted;
    }

    @Override
    public long getLastTransferred() {
        return this._lastTransferred.get();
    }

    @Override
    public boolean wasChanged() {
        return this._wasChanged;
    }

    RepositoryChannel getChannel() throws ClosedChannelException {
        RepositoryChannel channel = this._fileChannel;
        if (channel == null) {
            throw new ClosedChannelException();
        }
        return channel;
    }

    synchronized FileDescriptor open(OpenRequest msg) throws IOException {
        if (!this._inProgress) {
            throw new IOException("Open request failed, please retry.");
        }
        this._lastTransferred.set(System.currentTimeMillis());
        this._hasOpenedDescriptor = true;
        FileDescriptor handler = msg.isNew() || msg.isReadWrite() ? new WriteDescriptor(this) : new ReadDescriptor(this);
        this._openedDescriptors.add(handler);
        return handler;
    }

    synchronized void close(FileDescriptor descriptor) {
        this._lastTransferred.set(System.currentTimeMillis());
        this._openedDescriptors.remove(descriptor);
        if (this._openedDescriptors.isEmpty()) {
            this._inProgress = false;
            this._closeLatch.countDown();
        }
    }

    FileStatus stat() throws IOException {
        this._lastTransferred.set(System.currentTimeMillis());
        return new FileStatus(0, this._fileChannel.size(), 0, 0L);
    }

    InetSocketAddress getDoorAddress() {
        return this._doorAddress;
    }

    private boolean isTransferSuccessful(IoMode access) {
        boolean isRead = access == IoMode.READ;
        return this._openedDescriptors.isEmpty() && (this._hasOpenedDescriptor || isRead);
    }

    void addTransferredBytes(long length) {
        this._bytesTransferred.getAndAdd(length);
    }

    void updateLastTransferred() {
        this._lastTransferred.set(System.currentTimeMillis());
    }

    void setWasChanged(boolean wasChanged) {
        this._wasChanged = wasChanged;
    }

    synchronized void preallocate(long position) throws IOException {
        try {
            if (position < 0L) {
                throw new IllegalArgumentException("Position must be positive");
            }
            if (position > this._reservedSpace) {
                long additional = Math.max(position - this._reservedSpace, 0x3200000L);
                _logSpaceAllocation.debug("ALLOC: " + additional);
                this._allocator.allocate(additional);
                this._reservedSpace += additional;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new ClosedChannelException();
        }
    }

    static int getMaxFrameSize() {
        return _maxFrameSize;
    }

    static {
        _maxFrameSize = 0x200000;
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
    }
}

