/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.dcache.pool.movers.AbstractNettyServer;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.pool.ReadDescriptor;
import org.dcache.xrootd.pool.Reader;
import org.dcache.xrootd.pool.VectorReader;
import org.dcache.xrootd.pool.WriteDescriptor;
import org.dcache.xrootd.pool.XrootdProtocol_3;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.OpenResponse;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.ProtocolResponse;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadResponse;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RedirectResponse;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.FileStatus;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdPoolRequestHandler
extends XrootdRequestHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdPoolRequestHandler.class);
    private final List<FileDescriptor> _descriptors = new ArrayList<FileDescriptor>();
    private final Queue<Reader> _readers = new ArrayDeque<Reader>();
    private AbstractResponseMessage _block;
    private boolean _hasOpenedFiles = false;
    private InetSocketAddress _redirectingDoor = null;
    private AbstractNettyServer<XrootdProtocol_3> _server;

    public XrootdPoolRequestHandler(AbstractNettyServer<XrootdProtocol_3> server) {
        this._server = server;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws IOException {
        this._server.clientConnected();
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) {
        if (event.getState() == IdleState.ALL_IDLE && !this._hasOpenedFiles) {
            if (_log.isInfoEnabled()) {
                long idleTime = System.currentTimeMillis() - event.getLastActivityTimeMillis();
                _log.info("Closing idling connection without opened files. Connection has been idle for {} ms.", (Object)idleTime);
            }
            ctx.getChannel().close();
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) throws IOException {
        for (FileDescriptor descriptor : this._descriptors) {
            if (descriptor == null) continue;
            descriptor.close();
        }
        this._server.clientDisconnected();
        this._readers.clear();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Throwable t = e.getCause();
        if (t instanceof ClosedChannelException) {
            _log.info("Connection unexpectedly closed");
        } else if (t instanceof RuntimeException || t instanceof Error) {
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        } else {
            _log.warn(t.toString());
        }
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.sendToClient(e.getChannel());
    }

    protected AbstractResponseMessage doOnLogin(ChannelHandlerContext ctx, MessageEvent event, LoginRequest msg) {
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnAuthentication(ChannelHandlerContext ctx, MessageEvent event, AuthenticationRequest msg) {
        return this.withOk((XrootdRequest)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractResponseMessage doOnOpen(ChannelHandlerContext ctx, MessageEvent event, OpenRequest msg) throws XrootdException {
        OpenResponse openResponse;
        block13: {
            UUID uuid;
            Map opaque;
            try {
                opaque = OpaqueStringParser.getOpaqueMap((String)msg.getOpaque());
            }
            catch (ParseException e) {
                _log.warn("Could not parse the opaque information in {}: {}", (Object)msg, (Object)e.getMessage());
                throw new XrootdException(3010, "Cannot parse opaque data: " + e.getMessage());
            }
            String uuidString = (String)opaque.get("org.dcache.uuid");
            if (uuidString == null) {
                _log.warn("Request contains no UUID: {}", (Object)msg);
                throw new XrootdException(3010, "org.dcache.uuid is missing. Contact redirector to obtain a new UUID.");
            }
            try {
                uuid = UUID.fromString(uuidString);
            }
            catch (IllegalArgumentException e) {
                _log.warn("Failed to parse UUID in {}: {}", (Object)msg, (Object)e.getMessage());
                throw new XrootdException(3010, "Cannot parse " + uuidString + ": " + e.getMessage());
            }
            XrootdProtocol_3 mover = this._server.getMover(uuid);
            if (mover == null) {
                _log.warn("No mover found for {}", (Object)msg);
                throw new XrootdException(3010, "Request UUID is no longer valid. Contact redirector to obtain a new UUID.");
            }
            FileDescriptor descriptor = null;
            try {
                descriptor = mover.open(msg);
                FileStatus stat = null;
                if (msg.isRetStat()) {
                    stat = mover.stat();
                }
                int fd = this.getUnusedFileDescriptor();
                this._descriptors.set(fd, descriptor);
                this._redirectingDoor = mover.getDoorAddress();
                descriptor = null;
                this._hasOpenedFiles = true;
                openResponse = new OpenResponse(msg.getStreamId(), (long)fd, null, null, stat);
                if (descriptor == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (descriptor != null) {
                        descriptor.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new XrootdException(3007, e.getMessage());
                }
            }
            descriptor.close();
        }
        return openResponse;
    }

    protected AbstractResponseMessage doOnStat(ChannelHandlerContext ctx, MessageEvent event, StatRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnDirList(ChannelHandlerContext ctx, MessageEvent event, DirListRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnMv(ChannelHandlerContext ctx, MessageEvent event, MvRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnRm(ChannelHandlerContext ctx, MessageEvent event, RmRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnRmDir(ChannelHandlerContext ctx, MessageEvent event, RmDirRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnMkDir(ChannelHandlerContext ctx, MessageEvent event, MkDirRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnStatx(ChannelHandlerContext ctx, MessageEvent event, StatxRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    private AbstractResponseMessage redirectToDoor(ChannelHandlerContext ctx, MessageEvent event, XrootdRequest msg) throws XrootdException {
        if (this._redirectingDoor == null) {
            return this.unsupported(ctx, event, msg);
        }
        return new RedirectResponse(msg.getStreamId(), this._redirectingDoor.getHostName(), this._redirectingDoor.getPort());
    }

    protected AbstractResponseMessage doOnRead(ChannelHandlerContext ctx, MessageEvent event, ReadRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.error("Could not find a file descriptor for handle {}", (Object)fd);
            throw new XrootdException(3004, "The file handle does not refer to an open file.");
        }
        ReadDescriptor descriptor = (ReadDescriptor)this._descriptors.get(fd);
        try {
            this._readers.add(descriptor.read(msg));
        }
        catch (IllegalStateException e) {
            _log.error("File with file descriptor {}: Could not be read", (Object)fd);
            throw new XrootdException(3012, "Descriptor error. File reported not open, even though it should be.");
        }
        this.sendToClient(event.getChannel());
        return null;
    }

    protected AbstractResponseMessage doOnReadV(ChannelHandlerContext ctx, MessageEvent event, ReadVRequest msg) throws XrootdException {
        GenericReadRequestMessage.EmbeddedReadRequest[] list = msg.getReadRequestList();
        if (list == null || list.length == 0) {
            throw new XrootdException(3001, "Request contains no vector");
        }
        int maxFrameSize = XrootdProtocol_3.getMaxFrameSize();
        for (GenericReadRequestMessage.EmbeddedReadRequest req : list) {
            int fd = req.getFileHandle();
            if (!this.isValidFileDescriptor(fd)) {
                _log.error("Could not find file descriptor for handle {}!", (Object)fd);
                throw new XrootdException(3004, "Descriptor for the embedded read request does not refer to an open file.");
            }
            int totalBytesToRead = req.BytesToRead() + 16;
            if (totalBytesToRead <= maxFrameSize) continue;
            _log.warn("Vector read of {} bytes requested, exceeds maximum frame size of {} bytes!", (Object)totalBytesToRead, (Object)maxFrameSize);
            throw new XrootdException(3000, "Single readv transfer is too large");
        }
        this._readers.add(new VectorReader(msg.getStreamId(), Lists.newArrayList(this._descriptors), list));
        this.sendToClient(event.getChannel());
        return null;
    }

    protected AbstractResponseMessage doOnWrite(ChannelHandlerContext ctx, MessageEvent event, WriteRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.info("No file descriptor for file handle {}", (Object)fd);
            throw new XrootdException(3004, "The file descriptor does not refer to an open file.");
        }
        FileDescriptor descriptor = this._descriptors.get(fd);
        if (!(descriptor instanceof WriteDescriptor)) {
            _log.info("File descriptor for handle {} is read-only, user to write.", (Object)fd);
            throw new XrootdException(3007, "Tried to write on read only file.");
        }
        try {
            descriptor.write(msg);
        }
        catch (ClosedChannelException e) {
            throw new XrootdException(3004, "The file was forcefully closed by the server");
        }
        catch (IOException e) {
            throw new XrootdException(3007, e.getMessage());
        }
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnSync(ChannelHandlerContext ctx, MessageEvent event, SyncRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.error("Could not find file descriptor for handle {}", (Object)fd);
            throw new XrootdException(3004, "The file descriptor does not refer to an open file.");
        }
        FileDescriptor descriptor = this._descriptors.get(fd);
        try {
            descriptor.sync(msg);
        }
        catch (ClosedChannelException e) {
            throw new XrootdException(3004, "The file was forcefully closed by the server");
        }
        catch (IOException e) {
            throw new XrootdException(3007, e.getMessage());
        }
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnClose(ChannelHandlerContext ctx, MessageEvent event, CloseRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.error("Could not find file descriptor for handle {}", (Object)fd);
            throw new XrootdException(3004, "The file descriptor does not refer to an open file.");
        }
        ((FileDescriptor)this._descriptors.set(fd, null)).close();
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnProtocolRequest(ChannelHandlerContext ctx, MessageEvent event, ProtocolRequest msg) throws XrootdException {
        return new ProtocolResponse(msg.getStreamId(), 1);
    }

    private AbstractResponseMessage readBlock(Channel channel) {
        try {
            while (this._readers.peek() != null) {
                Reader reader = this._readers.element();
                ReadResponse block = reader.read(XrootdProtocol_3.getMaxFrameSize());
                if (block != null) {
                    return block;
                }
                this._readers.remove();
            }
            return null;
        }
        catch (ClosedChannelException e) {
            Reader reader = this._readers.remove();
            return new ErrorResponse(reader.getStreamID(), 3004, "File was forcefully closed by the server");
        }
        catch (IOException e) {
            Reader reader = this._readers.remove();
            return new ErrorResponse(reader.getStreamID(), 3007, e.getMessage() == null ? e.toString() : e.getMessage());
        }
    }

    private void sendToClient(Channel channel) {
        if (this._block == null) {
            this._block = this.readBlock(channel);
        }
        while (this._block != null && channel.isWritable()) {
            channel.write((Object)this._block);
            this._block = this.readBlock(channel);
        }
    }

    private int getUnusedFileDescriptor() {
        for (int i = 0; i < this._descriptors.size(); ++i) {
            if (this._descriptors.get(i) != null) continue;
            return i;
        }
        this._descriptors.add(null);
        return this._descriptors.size() - 1;
    }

    private boolean isValidFileDescriptor(int fd) {
        return fd >= 0 && fd < this._descriptors.size() && this._descriptors.get(fd) != null;
    }
}

