/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.pool.movers.AbstractNettyServer;
import org.dcache.util.PortRange;
import org.dcache.xrootd.core.XrootdDecoder;
import org.dcache.xrootd.core.XrootdEncoder;
import org.dcache.xrootd.core.XrootdHandshakeHandler;
import org.dcache.xrootd.pool.XrootdPoolRequestHandler;
import org.dcache.xrootd.pool.XrootdProtocol_3;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdPoolNettyServer
extends AbstractNettyServer<XrootdProtocol_3> {
    private static final Logger _logger = LoggerFactory.getLogger(XrootdPoolNettyServer.class);
    private static final PortRange DEFAULT_PORTRANGE = new PortRange(20000, 25000);

    public XrootdPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int clientIdleTimeout) {
        this(threadPoolSize, memoryPerConnection, maxMemory, clientIdleTimeout, -1);
    }

    public XrootdPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int clientIdleTimeout, int socketThreads) {
        super(threadPoolSize, memoryPerConnection, maxMemory, clientIdleTimeout, socketThreads);
    }

    @Override
    protected ChannelPipelineFactory newPipelineFactory() {
        return new XrootdPoolPipelineFactory();
    }

    @Override
    protected PortRange getPortRange() {
        String portRange = System.getProperty("org.globus.tcp.port.range");
        PortRange range = portRange != null ? PortRange.valueOf(portRange) : DEFAULT_PORTRANGE;
        return range;
    }

    @Override
    protected void toggleServer() throws IOException {
        if (this.isRunning() && this.getMoversPerUUID().isEmpty() && this.getConnectedClients() == 0) {
            this.stopServer();
            _logger.debug("No movers, no connections, stopping server.");
        } else if (!this.isRunning() && !this.getMoversPerUUID().isEmpty()) {
            _logger.debug("Starting server.");
            this.startServer();
        }
    }

    private class XrootdPoolPipelineFactory
    implements ChannelPipelineFactory {
        private XrootdPoolPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("encoder", (ChannelHandler)new XrootdEncoder());
            pipeline.addLast("decoder", (ChannelHandler)new XrootdDecoder());
            if (_logger.isDebugEnabled()) {
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(XrootdPoolNettyServer.class));
            }
            pipeline.addLast("handshake", (ChannelHandler)new XrootdHandshakeHandler(1));
            pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(XrootdPoolNettyServer.this.getDiskExecutor()));
            pipeline.addLast("timeout", (ChannelHandler)new IdleStateHandler(XrootdPoolNettyServer.this.getTimer(), 0L, 0L, XrootdPoolNettyServer.this.getClientIdleTimeout(), TimeUnit.MILLISECONDS));
            pipeline.addLast("transfer", (ChannelHandler)new XrootdPoolRequestHandler(XrootdPoolNettyServer.this));
            return pipeline;
        }
    }
}

