/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.pool.Reader;
import org.dcache.xrootd.pool.RegularReader;
import org.dcache.xrootd.pool.XrootdProtocol_3;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteDescriptor
implements FileDescriptor {
    private static final Logger _log = LoggerFactory.getLogger(WriteDescriptor.class);
    private XrootdProtocol_3 _mover;

    public WriteDescriptor(XrootdProtocol_3 mover) {
        this._mover = mover;
    }

    @Override
    public void close() {
        this._mover.close(this);
    }

    @Override
    public Reader read(ReadRequest msg) {
        return new RegularReader(msg.getStreamId(), msg.getReadOffset(), msg.bytesToRead(), this);
    }

    @Override
    public void sync(SyncRequest msg) throws IOException {
        this._mover.updateLastTransferred();
        this._mover.getChannel().sync();
    }

    @Override
    public void write(WriteRequest msg) throws IOException {
        this._mover.preallocate(msg.getWriteOffset() + (long)msg.getDataLength());
        this._mover.updateLastTransferred();
        this._mover.addTransferredBytes(msg.getDataLength());
        this._mover.setWasChanged(true);
        long position = msg.getWriteOffset();
        for (ByteBuffer buffer : msg.toByteBuffers()) {
            while (buffer.hasRemaining()) {
                position += (long)this._mover.getChannel().write(buffer, position);
            }
        }
    }

    @Override
    public RepositoryChannel getChannel() throws ClosedChannelException {
        return this._mover.getChannel();
    }

    @Override
    public XrootdProtocol_3 getMover() {
        return this._mover;
    }
}

