/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.pool.Reader;
import org.dcache.xrootd.pool.XrootdProtocol_3;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;
import org.dcache.xrootd.protocol.messages.ReadResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class VectorReader
implements Reader {
    private final int _id;
    private final List<FileDescriptor> _descriptors;
    private final GenericReadRequestMessage.EmbeddedReadRequest[] _requests;
    private int _index;

    public VectorReader(int id, List<FileDescriptor> descriptors, GenericReadRequestMessage.EmbeddedReadRequest[] requests) {
        this._id = id;
        this._descriptors = descriptors;
        this._requests = requests;
        this._index = 0;
    }

    @Override
    public int getStreamID() {
        return this._id;
    }

    private int getLengthOfRequest(GenericReadRequestMessage.EmbeddedReadRequest request) throws IOException {
        FileDescriptor descriptor = this._descriptors.get(request.getFileHandle());
        RepositoryChannel channel = descriptor.getChannel();
        return (int)Math.min((long)request.BytesToRead(), channel.size() - request.getOffset());
    }

    private int getChunksInNextFrame(int maxFrameSize) throws IOException {
        long length = 0L;
        int count = 0;
        for (int i = this._index; i < this._requests.length && length < (long)maxFrameSize; ++i) {
            length += 16L;
            length += (long)this.getLengthOfRequest(this._requests[i]);
            ++count;
        }
        if (length > (long)maxFrameSize) {
            --count;
        }
        if (count == 0) {
            throw new IllegalStateException("Maximum chunk size exceeded");
        }
        return count;
    }

    private ChannelBuffer readBlock(GenericReadRequestMessage.EmbeddedReadRequest request) throws IOException {
        int bytes;
        int remaining;
        FileDescriptor descriptor = this._descriptors.get(request.getFileHandle());
        RepositoryChannel channel = descriptor.getChannel();
        long position = request.getOffset();
        byte[] chunkArray = new byte[remaining];
        ByteBuffer chunk = ByteBuffer.wrap(chunkArray);
        for (remaining = request.BytesToRead(); remaining > 0 && (bytes = channel.read(chunk, position)) >= 0; remaining -= bytes) {
            position += (long)bytes;
        }
        XrootdProtocol_3 mover = descriptor.getMover();
        mover.addTransferredBytes(chunkArray.length - remaining);
        mover.updateLastTransferred();
        return ChannelBuffers.wrappedBuffer((byte[])chunkArray, (int)0, (int)(chunkArray.length - remaining));
    }

    @Override
    public ReadResponse read(int maxFrameSize) throws IOException {
        if (this._index == this._requests.length) {
            return null;
        }
        int count = this.getChunksInNextFrame(maxFrameSize);
        ChannelBuffer[] chunks = new ChannelBuffer[this._requests.length];
        for (int i = this._index; i < this._index + count; ++i) {
            chunks[i] = this.readBlock(this._requests[i]);
        }
        VectorReadResponse response = new VectorReadResponse(this._id);
        response.write(this._requests, chunks, this._index, count);
        response.setIncomplete(this._index + count < this._requests.length);
        this._index += count;
        return response;
    }

    public static class VectorReadResponse
    extends ReadResponse {
        public VectorReadResponse(int sId) {
            super(sId, 0);
        }

        private ChannelBuffer getReadListHeader(GenericReadRequestMessage.EmbeddedReadRequest request, int actualLength) {
            ChannelBuffer buffer = ChannelBuffers.buffer((int)16);
            buffer.writeInt(request.getFileHandle());
            buffer.writeInt(actualLength);
            buffer.writeLong(request.getOffset());
            return buffer;
        }

        public void write(GenericReadRequestMessage.EmbeddedReadRequest[] requests, ChannelBuffer[] buffers, int offset, int length) {
            ChannelBuffer[] reply = new ChannelBuffer[2 * length + 1];
            reply[0] = this._buffer;
            for (int i = 0; i < length; ++i) {
                reply[2 * i + 1] = this.getReadListHeader(requests[offset + i], buffers[offset + i].readableBytes());
                reply[2 * i + 2] = buffers[offset + i];
            }
            this._buffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])reply);
        }
    }
}

