/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.pool.Reader;
import org.dcache.xrootd.pool.XrootdProtocol_3;
import org.dcache.xrootd.protocol.messages.ReadResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class RegularReader
implements Reader {
    private final int _id;
    private long _position;
    private int _length;
    private FileDescriptor _descriptor;

    public RegularReader(int id, long position, int length, FileDescriptor descriptor) {
        this._id = id;
        this._position = position;
        this._length = length;
        this._descriptor = descriptor;
    }

    @Override
    public int getStreamID() {
        return this._id;
    }

    @Override
    public ReadResponse read(int maxFrameSize) throws IOException {
        if (this._length == 0) {
            return null;
        }
        RepositoryChannel channel = this._descriptor.getChannel();
        int length = Math.min(this._length, maxFrameSize);
        RegularReadResponse response = new RegularReadResponse(this._id);
        length = response.write(channel, this._position, length);
        this._position += (long)length;
        this._length -= length;
        response.setIncomplete(this._length != 0);
        XrootdProtocol_3 mover = this._descriptor.getMover();
        mover.addTransferredBytes(length);
        mover.updateLastTransferred();
        return response;
    }

    private static class RegularReadResponse
    extends ReadResponse {
        public RegularReadResponse(int sId) {
            super(sId, 0);
        }

        public int write(RepositoryChannel channel, long srcIndex, int length) throws IOException {
            int remaining;
            int bytes;
            byte[] chunkArray = new byte[length];
            ByteBuffer chunk = ByteBuffer.wrap(chunkArray);
            for (remaining = length; remaining > 0 && (bytes = channel.read(chunk, srcIndex)) >= 0; remaining -= bytes) {
                srcIndex += (long)bytes;
            }
            this._buffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{this._buffer, ChannelBuffers.wrappedBuffer((byte[])chunkArray, (int)0, (int)(length - remaining))});
            return length - remaining;
        }
    }
}

