/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import com.google.common.collect.Iterables;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.TimeoutCacheException;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.dcache.auth.LoginReply;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.util.list.DirectoryEntries;
import org.dcache.vehicles.PnfsListDirectoryMessage;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.door.LoginEvent;
import org.dcache.xrootd.door.XrootdDoor;
import org.dcache.xrootd.door.XrootdTransfer;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.DirListResponse;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.ProtocolResponse;
import org.dcache.xrootd.protocol.messages.RedirectResponse;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatResponse;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.StatxResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.FileStatus;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdRedirectHandler
extends XrootdRequestHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdRedirectHandler.class);
    private final XrootdDoor _door;
    private boolean _isReadOnly = true;
    private FsPath _rootPath = new FsPath();
    private final Set<Thread> _threads = Collections.synchronizedSet(new HashSet());

    public XrootdRedirectHandler(XrootdDoor door) {
        this._door = door;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        if (event instanceof LoginEvent) {
            this.loggedIn((LoginEvent)event);
        }
        super.handleUpstream(ctx, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Thread me = Thread.currentThread();
        this._threads.add(me);
        try {
            super.messageReceived(ctx, event);
        }
        finally {
            this._threads.remove(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        Set<Thread> set = this._threads;
        synchronized (set) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        super.channelDisconnected(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable t = event.getCause();
        if (t instanceof ClosedChannelException) {
            _log.info("Connection closed");
        } else if (t instanceof RuntimeException || t instanceof Error) {
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        } else {
            _log.warn(t.toString());
        }
    }

    protected AbstractResponseMessage doOnOpen(ChannelHandlerContext ctx, MessageEvent event, OpenRequest req) throws XrootdException {
        XrootdProtocol.FilePerm neededPerm;
        Channel channel = event.getChannel();
        InetSocketAddress localAddress = (InetSocketAddress)channel.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.getRemoteAddress();
        int options = req.getOptions();
        if (req.isNew() || req.isReadWrite()) {
            if (this._isReadOnly) {
                throw new XrootdException(3010, "Read-only access");
            }
            neededPerm = XrootdProtocol.FilePerm.WRITE;
        } else {
            neededPerm = XrootdProtocol.FilePerm.READ;
        }
        _log.info("Opening {} for {}", (Object)req.getPath(), (Object)neededPerm.xmlText());
        if (_log.isDebugEnabled()) {
            this.logDebugOnOpen(req);
        }
        try {
            XrootdTransfer transfer;
            UUID uuid = UUID.randomUUID();
            String opaque = OpaqueStringParser.buildOpaqueString((String)"org.dcache.uuid", (String)uuid.toString());
            if (neededPerm == XrootdProtocol.FilePerm.WRITE) {
                boolean createDir = (options & 0x100) == 256;
                boolean overwrite = (options & 2) == 2;
                transfer = this._door.write(remoteAddress, req.getPath(), uuid, createDir, overwrite, localAddress, req.getSubject(), this._rootPath);
            } else {
                transfer = this._door.read(remoteAddress, req.getPath(), uuid, localAddress, req.getSubject(), this._rootPath);
            }
            InetSocketAddress address = (InetSocketAddress)transfer.getRedirect();
            _log.info("Redirecting to {}", (Object)address);
            if (transfer.isUUIDSupported()) {
                return new RedirectResponse(req.getStreamId(), address.getHostName(), address.getPort(), opaque, "");
            }
            return new RedirectResponse(req.getStreamId(), address.getHostName(), address.getPort());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3004, "No such file");
        }
        catch (FileExistsCacheException e) {
            throw new XrootdException(3013, "File already exists");
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to open file (%s [%d])", e.getMessage(), e.getRc()));
        }
        catch (InterruptedException e) {
            throw new XrootdException(3012, "Server shutdown");
        }
    }

    protected AbstractResponseMessage doOnStat(ChannelHandlerContext ctx, MessageEvent event, StatRequest req) throws XrootdException {
        String path = req.getPath();
        try {
            FileMetaData meta = this._door.getFileMetaData(path, req.getSubject(), this._rootPath);
            FileStatus fs = this.convertToFileStatus(meta);
            return new StatResponse(req.getStreamId(), fs);
        }
        catch (FileNotFoundCacheException e) {
            _log.info("No PnfsId found for path: {}", (Object)path);
            return new StatResponse(req.getStreamId(), FileStatus.FILE_NOT_FOUND);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to open file (%s [%d])", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnStatx(ChannelHandlerContext ctx, MessageEvent event, StatxRequest req) throws XrootdException {
        if (req.getPaths().length == 0) {
            throw new XrootdException(3001, "no paths specified");
        }
        try {
            FileMetaData[] metas = this._door.getMultipleFileMetaData(req.getPaths(), req.getSubject(), this._rootPath);
            int[] flags = new int[metas.length];
            for (int i = 0; i < metas.length; ++i) {
                flags[i] = metas[i] == null ? 4 : this.getFileStatusFlags(metas[i]);
            }
            return new StatxResponse(req.getStreamId(), flags);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to open file (%s [%d])", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnRm(ChannelHandlerContext ctx, MessageEvent event, RmRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to delete {}", (Object)req.getPath());
        try {
            this._door.deleteFile(req.getPath(), req.getSubject(), this._rootPath);
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to delete file (%s [%d])", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnRmDir(ChannelHandlerContext ctx, MessageEvent event, RmDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to delete directory {}", (Object)req.getPath());
        try {
            this._door.deleteDirectory(req.getPath(), req.getSubject(), this._rootPath);
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3005, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to delete directory (%s [%d]).", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnMkDir(ChannelHandlerContext ctx, MessageEvent event, MkDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to create directory {}", (Object)req.getPath());
        try {
            this._door.createDirectory(req.getPath(), req.shouldMkPath(), req.getSubject(), this._rootPath);
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3005, e.getMessage());
        }
        catch (FileExistsCacheException e) {
            throw new XrootdException(3005, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to create directory (%s [%d]).", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnMv(ChannelHandlerContext ctx, MessageEvent event, MvRequest req) throws XrootdException {
        String sourcePath = req.getSourcePath();
        if (sourcePath.isEmpty()) {
            throw new XrootdException(3001, "no source path specified");
        }
        String targetPath = req.getTargetPath();
        if (targetPath.isEmpty()) {
            throw new XrootdException(3001, "no target path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to rename {} to {}", (Object)req.getSourcePath(), (Object)req.getTargetPath());
        try {
            this._door.moveFile(req.getSourcePath(), req.getTargetPath(), req.getSubject(), this._rootPath);
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3005, String.format("Source file does not exist (%s) ", e.getMessage()));
        }
        catch (FileExistsCacheException e) {
            throw new XrootdException(3005, String.format("Will not overwrite existing file (%s).", e.getMessage()));
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to move file (%s [%d]).", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnDirList(ChannelHandlerContext context, MessageEvent event, DirListRequest request) throws XrootdException {
        String listPath = request.getPath();
        if (listPath.isEmpty()) {
            throw new XrootdException(3001, "no source path specified");
        }
        try {
            _log.info("Listing directory {}", (Object)listPath);
            ListCallback callback = new ListCallback(request, context, event);
            this._door.listPath(listPath, request.getSubject(), this._rootPath, callback);
            return null;
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Internal server error! (%s)", e.getMessage()));
        }
    }

    protected AbstractResponseMessage doOnPrepare(ChannelHandlerContext ctx, MessageEvent event, PrepareRequest msg) throws XrootdException {
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnProtocolRequest(ChannelHandlerContext ctx, MessageEvent event, ProtocolRequest msg) throws XrootdException {
        return new ProtocolResponse(msg.getStreamId(), 1);
    }

    private void logDebugOnOpen(OpenRequest req) {
        int options = req.getOptions();
        String openFlags = "options to apply for open path (raw=" + options + " ):";
        if ((options & 0x40) == 64) {
            openFlags = openFlags + " kXR_async";
        }
        if ((options & 1) == 1) {
            openFlags = openFlags + " kXR_compress";
        }
        if ((options & 2) == 2) {
            openFlags = openFlags + " kXR_delete";
        }
        if ((options & 4) == 4) {
            openFlags = openFlags + " kXR_force";
        }
        if ((options & 8) == 8) {
            openFlags = openFlags + " kXR_new";
        }
        if ((options & 0x10) == 16) {
            openFlags = openFlags + " kXR_open_read";
        }
        if ((options & 0x20) == 32) {
            openFlags = openFlags + " kXR_open_updt";
        }
        if ((options & 0x80) == 128) {
            openFlags = openFlags + " kXR_refresh";
        }
        if ((options & 0x100) == 256) {
            openFlags = openFlags + " kXR_mkpath";
        }
        if ((options & 0x200) == 512) {
            openFlags = openFlags + " kXR_open_apnd";
        }
        if ((options & 0x400) == 1024) {
            openFlags = openFlags + " kXR_retstat";
        }
        _log.debug("open flags: " + openFlags);
        int mode = req.getUMask();
        String s = "";
        s = (mode & 0x100) == 256 ? s + "r" : s + "-";
        s = (mode & 0x80) == 128 ? s + "w" : s + "-";
        s = (mode & 0x40) == 64 ? s + "x" : s + "-";
        s = s + " ";
        s = (mode & 0x20) == 32 ? s + "r" : s + "-";
        s = (mode & 0x10) == 16 ? s + "w" : s + "-";
        s = (mode & 8) == 8 ? s + "x" : s + "-";
        s = s + " ";
        s = (mode & 4) == 4 ? s + "r" : s + "-";
        s = (mode & 2) == 2 ? s + "w" : s + "-";
        s = (mode & 1) == 1 ? s + "x" : s + "-";
        _log.debug("mode to apply to open path: {}", (Object)s);
    }

    private int getFileStatusFlags(FileMetaData meta) {
        FileMetaData.Permissions pm;
        int flags = 0;
        if (meta.isDirectory()) {
            flags |= 2;
        }
        if (!meta.isRegularFile() && !meta.isDirectory()) {
            flags |= 4;
        }
        if ((pm = meta.getWorldPermissions()).canExecute()) {
            flags |= 1;
        }
        if (pm.canRead()) {
            flags |= 0x10;
        }
        if (pm.canWrite()) {
            flags |= 0x20;
        }
        return flags;
    }

    private FileStatus convertToFileStatus(FileMetaData meta) {
        return new FileStatus(0, meta.getFileSize(), this.getFileStatusFlags(meta), meta.getLastModifiedTime() / 1000L);
    }

    private void loggedIn(LoginEvent event) throws PermissionDeniedCacheException, CacheException {
        LoginReply reply = event.getLoginReply();
        this._isReadOnly = false;
        this._rootPath = new FsPath();
        if (reply != null) {
            for (LoginAttribute attribute : reply.getLoginAttributes()) {
                if (attribute instanceof ReadOnly) {
                    this._isReadOnly = ((ReadOnly)attribute).isReadOnly();
                    continue;
                }
                if (!(attribute instanceof RootDirectory)) continue;
                this._rootPath = new FsPath(((RootDirectory)attribute).getRoot());
            }
        }
    }

    private class ListCallback
    extends AbstractMessageCallback<PnfsListDirectoryMessage> {
        private final DirListRequest _request;
        private final ChannelHandlerContext _context;
        private final MessageEvent _event;

        public ListCallback(DirListRequest request, ChannelHandlerContext context, MessageEvent event) {
            this._request = request;
            this._context = context;
            this._event = event;
        }

        @Override
        public void failure(int rc, Object error) {
            switch (rc) {
                case 10006: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Timeout when trying to list directory: " + error.toString()));
                    break;
                }
                case 10018: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3010, "Permission to list that directory denied: " + error.toString()));
                    break;
                }
                default: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Error when processing list response: " + error.toString()));
                }
            }
        }

        @Override
        public void noroute(CellPath path) {
            XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Could not contact PNFS Manager."));
        }

        @Override
        public void success(PnfsListDirectoryMessage message) {
            Iterable directories = Iterables.transform(message.getEntries(), DirectoryEntries.GET_NAME);
            if (message.isFinal()) {
                _log.debug("XrootdRedirectHandler: Received final listing message!");
                XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)new DirListResponse(this._request.getStreamId(), directories));
            } else {
                XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)new DirListResponse(this._request.getStreamId(), 4000, directories));
            }
        }

        @Override
        public void timeout(CellPath path) {
            XrootdRedirectHandler.this.respond(this._context, this._event, (AbstractResponseMessage)XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Timeout when trying to list directory!"));
        }
    }
}

