/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.dcache.auth.LoginStrategy;
import org.dcache.xrootd.core.XrootdAuthorizationHandler;
import org.dcache.xrootd.core.XrootdDecoder;
import org.dcache.xrootd.core.XrootdEncoder;
import org.dcache.xrootd.core.XrootdHandshakeHandler;
import org.dcache.xrootd.door.ConnectionTracker;
import org.dcache.xrootd.door.LoginAuthenticationHandler;
import org.dcache.xrootd.door.XrootdDoor;
import org.dcache.xrootd.door.XrootdRedirectHandler;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthorizationFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class NettyXrootdServer {
    private static final Logger _log = LoggerFactory.getLogger(NettyXrootdServer.class);
    private int _port;
    private int _backlog;
    private Executor _requestExecutor;
    private XrootdDoor _door;
    private AuthenticationFactory _authenticationFactory;
    private AuthorizationFactory _authorizationFactory;
    private ChannelFactory _channelFactory;
    private ConnectionTracker _connectionTracker;
    private LoginStrategy _loginStrategy;
    private LoginStrategy _anonymousLoginStrategy;

    public int getPort() {
        return this._port;
    }

    @Required
    public void setPort(int port) {
        this._port = port;
    }

    @Required
    public void setBacklog(int backlog) {
        this._backlog = backlog;
    }

    @Required
    public void setRequestExecutor(Executor executor) {
        this._requestExecutor = executor;
    }

    @Required
    public void setChannelFactory(ChannelFactory channelFactory) {
        this._channelFactory = channelFactory;
    }

    @Required
    public void setConnectionTracker(ConnectionTracker connectionTracker) {
        this._connectionTracker = connectionTracker;
    }

    @Required
    public void setDoor(XrootdDoor door) {
        this._door = door;
    }

    @Required
    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    @Required
    public void setAnonymousLoginStrategy(LoginStrategy loginStrategy) {
        this._anonymousLoginStrategy = loginStrategy;
    }

    @Required
    public void setAuthenticationFactory(AuthenticationFactory factory) {
        this._authenticationFactory = factory;
    }

    public AuthenticationFactory getAuthenticationFactory() {
        return this._authenticationFactory;
    }

    @Required
    public void setAuthorizationFactory(AuthorizationFactory factory) {
        this._authorizationFactory = factory;
    }

    public AuthorizationFactory getAuthorizationFactory() {
        return this._authorizationFactory;
    }

    public void init() {
        ServerBootstrap bootstrap = new ServerBootstrap(this._channelFactory);
        bootstrap.setOption("backlog", (Object)this._backlog);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("tracker", (ChannelHandler)NettyXrootdServer.this._connectionTracker);
                pipeline.addLast("encoder", (ChannelHandler)new XrootdEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new XrootdDecoder());
                if (_log.isDebugEnabled()) {
                    pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(NettyXrootdServer.class));
                }
                pipeline.addLast("handshake", (ChannelHandler)new XrootdHandshakeHandler(0));
                pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(NettyXrootdServer.this._requestExecutor));
                pipeline.addLast("authenticator", (ChannelHandler)new LoginAuthenticationHandler(NettyXrootdServer.this._authenticationFactory, NettyXrootdServer.this._loginStrategy, NettyXrootdServer.this._anonymousLoginStrategy));
                pipeline.addLast("authorizer", (ChannelHandler)new XrootdAuthorizationHandler(NettyXrootdServer.this._authorizationFactory));
                pipeline.addLast("redirector", (ChannelHandler)new XrootdRedirectHandler(NettyXrootdServer.this._door));
                return pipeline;
            }
        });
        bootstrap.bind((SocketAddress)new InetSocketAddress(this._port));
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
    }
}

