/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.xrootd.core.XrootdAuthenticationHandler;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.door.LoginEvent;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginAuthenticationHandler
extends XrootdAuthenticationHandler {
    private static final Logger _log = LoggerFactory.getLogger(LoginAuthenticationHandler.class);
    private LoginStrategy _loginStrategy;
    private LoginStrategy _anonymousLoginStrategy;

    public LoginAuthenticationHandler(AuthenticationFactory authenticationFactory, LoginStrategy loginStrategy, LoginStrategy anonymousLoginStrategy) {
        super(authenticationFactory);
        this._loginStrategy = loginStrategy;
        this._anonymousLoginStrategy = anonymousLoginStrategy;
    }

    protected Subject login(ChannelHandlerContext context, Subject subject) throws XrootdException {
        try {
            LoginReply reply = subject == null ? this._anonymousLoginStrategy.login(null) : this._loginStrategy.login(subject);
            context.sendUpstream((ChannelEvent)new LoginEvent(context.getChannel(), reply));
            return reply.getSubject();
        }
        catch (PermissionDeniedCacheException e) {
            _log.warn("Authorization denied for {}: {}", (Object)subject, (Object)e.getMessage());
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            _log.error("Authorization failed for {}: {}", (Object)subject, (Object)e.getMessage());
            throw new XrootdException(3012, e.getMessage());
        }
    }
}

