/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsMessage;
import dmg.util.CollectionFactory;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.Glob;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.vehicles.FileAttributes;

public class PnfsListDirectoryMessage
extends PnfsMessage {
    static final long serialVersionUID = -5774904472984157638L;
    public final Glob _pattern;
    public final Integer _lower;
    public final Integer _upper;
    public final BoundType _lowerBoundType;
    public final BoundType _upperBoundType;
    public final UUID _uuid = UUID.randomUUID();
    public final Set<FileAttribute> _requestedAttributes;
    public Collection<DirectoryEntry> _entries = CollectionFactory.newArrayList();
    public boolean _isFinal = true;

    public PnfsListDirectoryMessage(String path, Glob pattern, Range<Integer> range, Set<FileAttribute> attr) {
        this.setReplyRequired(true);
        this.setPnfsPath(path);
        this._pattern = pattern;
        this._lower = range.hasLowerBound() ? (Integer)range.lowerEndpoint() : null;
        this._upper = range.hasUpperBound() ? (Integer)range.upperEndpoint() : null;
        this._lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : null;
        this._upperBoundType = range.hasUpperBound() ? range.upperBoundType() : null;
        this._requestedAttributes = attr;
    }

    public UUID getUUID() {
        return this._uuid;
    }

    public Glob getPattern() {
        return this._pattern;
    }

    public Range<Integer> getRange() {
        if (this._lower == null && this._upper == null) {
            return Ranges.all();
        }
        if (this._lower == null) {
            return Ranges.upTo((Comparable)this._upper, (BoundType)this._upperBoundType);
        }
        if (this._upper == null) {
            return Ranges.downTo((Comparable)this._lower, (BoundType)this._lowerBoundType);
        }
        return Ranges.range((Comparable)this._lower, (BoundType)this._lowerBoundType, (Comparable)this._upper, (BoundType)this._upperBoundType);
    }

    public Set<FileAttribute> getRequestedAttributes() {
        return this._requestedAttributes;
    }

    public void addEntry(String name, FileAttributes attr) {
        this._entries.add(new DirectoryEntry(name, attr));
    }

    public void setEntries(Collection<DirectoryEntry> entries) {
        this._entries = entries;
    }

    public Collection<DirectoryEntry> getEntries() {
        return this._entries;
    }

    public void clear() {
        this._entries.clear();
    }

    public void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    @Override
    public boolean invalidates(Message message) {
        return false;
    }
}

