/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.expression;

import org.dcache.util.expression.Expression;
import org.dcache.util.expression.Symbol;
import org.dcache.util.expression.SymbolTable;
import org.dcache.util.expression.Type;
import org.dcache.util.expression.TypeMismatchException;
import org.dcache.util.expression.UnknownIdentifierException;

public class TypeChecker {
    private final SymbolTable _symbols;

    public TypeChecker(SymbolTable symbols) {
        this._symbols = symbols;
    }

    private Type ensureSame(Type actual, Type expected) throws TypeMismatchException {
        if (actual != expected) {
            throw new TypeMismatchException("Type mismatch: Expected " + (Object)((Object)expected) + ", but found " + (Object)((Object)actual));
        }
        return actual;
    }

    public void check(Expression expression, Type expected) throws TypeMismatchException, UnknownIdentifierException {
        this.ensureSame(this.check(expression), expected);
    }

    public Type check(Expression expression) throws TypeMismatchException, UnknownIdentifierException {
        switch (expression.getToken()) {
            case NUMBER_LITERAL: {
                expression.setType(Type.DOUBLE);
                break;
            }
            case STRING_LITERAL: {
                expression.setType(Type.STRING);
                break;
            }
            case IDENTIFIER: {
                String identifier = expression.getString();
                Symbol symbol = (Symbol)this._symbols.get(identifier);
                if (symbol == null) {
                    throw new UnknownIdentifierException(identifier);
                }
                expression.setType(symbol.getType());
                break;
            }
            case TRUE: {
                expression.setType(Type.BOOLEAN);
                break;
            }
            case FALSE: {
                expression.setType(Type.BOOLEAN);
                break;
            }
            case IF: {
                this.ensureSame(this.check(expression.get(0)), Type.BOOLEAN);
                expression.setType(this.ensureSame(this.check(expression.get(1)), this.check(expression.get(2))));
                break;
            }
            case EQ: 
            case NE: {
                this.ensureSame(this.check(expression.get(0)), this.check(expression.get(1)));
                expression.setType(Type.BOOLEAN);
                break;
            }
            case AND: 
            case OR: {
                this.ensureSame(this.check(expression.get(0)), Type.BOOLEAN);
                this.ensureSame(this.check(expression.get(1)), Type.BOOLEAN);
                expression.setType(Type.BOOLEAN);
                break;
            }
            case NOT: {
                this.ensureSame(this.check(expression.get(0)), Type.BOOLEAN);
                expression.setType(Type.BOOLEAN);
                break;
            }
            case UMINUS: {
                this.ensureSame(this.check(expression.get(0)), Type.DOUBLE);
                expression.setType(Type.DOUBLE);
                break;
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                this.ensureSame(this.check(expression.get(0)), Type.DOUBLE);
                this.ensureSame(this.check(expression.get(1)), Type.DOUBLE);
                expression.setType(Type.BOOLEAN);
                break;
            }
            case MINUS: 
            case PLUS: 
            case MULT: 
            case DIV: 
            case MOD: 
            case POWER: {
                this.ensureSame(this.check(expression.get(0)), Type.DOUBLE);
                this.ensureSame(this.check(expression.get(1)), Type.DOUBLE);
                expression.setType(Type.DOUBLE);
                break;
            }
            case MATCH: 
            case NOT_MATCH: {
                this.ensureSame(this.check(expression.get(0)), Type.STRING);
                this.ensureSame(this.check(expression.get(1)), Type.STRING);
                expression.setType(Type.BOOLEAN);
            }
        }
        return expression.getType();
    }
}

